/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.ConcurrentEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.store.Chain;

public abstract class ServerStoreOpMessage
extends EhcacheEntityMessage
implements ConcurrentEntityMessage {
    private final String cacheId;

    private ServerStoreOpMessage(String cacheId) {
        this.cacheId = cacheId;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    @Override
    public int concurrencyKey() {
        return this.cacheId.hashCode();
    }

    @Override
    public EhcacheEntityMessage.Type getType() {
        return EhcacheEntityMessage.Type.SERVER_STORE_OP;
    }

    public abstract ServerStoreOp operation();

    @Override
    public byte getOpCode() {
        return this.operation().getStoreOpCode();
    }

    public String toString() {
        return (Object)((Object)this.getType()) + "#" + (Object)((Object)this.operation());
    }

    static class ClearMessage
    extends ServerStoreOpMessage {
        ClearMessage(String cacheId) {
            super(cacheId);
        }

        @Override
        public ServerStoreOp operation() {
            return ServerStoreOp.CLEAR;
        }

        @Override
        public byte getOpCode() {
            return ServerStoreOp.CLEAR.getStoreOpCode();
        }
    }

    public static class ClientInvalidationAck
    extends ServerStoreOpMessage {
        private final int invalidationId;

        ClientInvalidationAck(String cacheId, int invalidationId) {
            super(cacheId);
            this.invalidationId = invalidationId;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }

        @Override
        public ServerStoreOp operation() {
            return ServerStoreOp.CLIENT_INVALIDATION_ACK;
        }

        @Override
        public byte getOpCode() {
            return ServerStoreOp.CLIENT_INVALIDATION_ACK.getStoreOpCode();
        }
    }

    public static class ReplaceAtHeadMessage
    extends KeyBasedServerStoreOpMessage {
        private final Chain expect;
        private final Chain update;

        ReplaceAtHeadMessage(String cacheId, long key, Chain expect, Chain update) {
            super(cacheId, key);
            this.expect = expect;
            this.update = update;
        }

        @Override
        public ServerStoreOp operation() {
            return ServerStoreOp.REPLACE;
        }

        public Chain getExpect() {
            return this.expect;
        }

        public Chain getUpdate() {
            return this.update;
        }
    }

    public static class AppendMessage
    extends KeyBasedServerStoreOpMessage {
        private final ByteBuffer payload;

        AppendMessage(String cacheId, long key, ByteBuffer payload) {
            super(cacheId, key);
            this.payload = payload;
        }

        @Override
        public ServerStoreOp operation() {
            return ServerStoreOp.APPEND;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }
    }

    public static class GetAndAppendMessage
    extends KeyBasedServerStoreOpMessage {
        private final ByteBuffer payload;

        GetAndAppendMessage(String cacheId, long key, ByteBuffer payload) {
            super(cacheId, key);
            this.payload = payload;
        }

        @Override
        public ServerStoreOp operation() {
            return ServerStoreOp.GET_AND_APPEND;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }
    }

    public static class GetMessage
    extends KeyBasedServerStoreOpMessage {
        GetMessage(String cacheId, long key) {
            super(cacheId, key);
        }

        @Override
        public ServerStoreOp operation() {
            return ServerStoreOp.GET;
        }
    }

    static abstract class KeyBasedServerStoreOpMessage
    extends ServerStoreOpMessage {
        private final long key;

        KeyBasedServerStoreOpMessage(String cacheId, long key) {
            super(cacheId);
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public int concurrencyKey() {
            return (int)((long)super.concurrencyKey() + this.key);
        }
    }

    public static enum ServerStoreOp {
        GET(10),
        GET_AND_APPEND(11),
        APPEND(12),
        REPLACE(13),
        CLIENT_INVALIDATION_ACK(14),
        CLEAR(15);

        private final byte storeOpCode;

        private ServerStoreOp(byte storeOpCode) {
            this.storeOpCode = storeOpCode;
        }

        public byte getStoreOpCode() {
            return this.storeOpCode;
        }

        public static ServerStoreOp getServerStoreOp(byte storeOpCode) {
            switch (storeOpCode) {
                case 10: {
                    return GET;
                }
                case 11: {
                    return GET_AND_APPEND;
                }
                case 12: {
                    return APPEND;
                }
                case 13: {
                    return REPLACE;
                }
                case 14: {
                    return CLIENT_INVALIDATION_ACK;
                }
                case 15: {
                    return CLEAR;
                }
            }
            throw new IllegalArgumentException("Store operation not defined for : " + storeOpCode);
        }
    }
}

