/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.ehcache.Cache;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.ClusteredStoreConfiguration;
import org.ehcache.clustered.client.internal.store.ClusteredValueHolder;
import org.ehcache.clustered.client.internal.store.ResolvedChain;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.client.internal.store.operations.ConditionalRemoveOperation;
import org.ehcache.clustered.client.internal.store.operations.ConditionalReplaceOperation;
import org.ehcache.clustered.client.internal.store.operations.PutIfAbsentOperation;
import org.ehcache.clustered.client.internal.store.operations.PutOperation;
import org.ehcache.clustered.client.internal.store.operations.RemoveOperation;
import org.ehcache.clustered.client.internal.store.operations.ReplaceOperation;
import org.ehcache.clustered.client.internal.store.operations.Result;
import org.ehcache.clustered.client.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.Ehcache;
import org.ehcache.core.events.CacheEventListenerConfiguration;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.internal.service.ServiceLocator;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.StoreAccessTimeoutException;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.impl.internal.events.NullStoreEventDispatcher;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.observer.OperationObserver;

public class ClusteredStore<K, V>
implements AuthoritativeTier<K, V> {
    private static final String STATISTICS_TAG = "clustered-store";
    private final OperationsCodec<K, V> codec;
    private final ChainResolver<K, V> resolver;
    private final TimeSource timeSource;
    private volatile ServerStoreProxy storeProxy;
    private volatile AuthoritativeTier.InvalidationValve invalidationValve;
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;

    private ClusteredStore(OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource) {
        this.codec = codec;
        this.resolver = resolver;
        this.timeSource = timeSource;
        this.getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).of((Object)this)).named("get")).tag(new String[]{STATISTICS_TAG})).build();
        this.putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).of((Object)this)).named("put")).tag(new String[]{STATISTICS_TAG})).build();
        this.removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).of((Object)this)).named("remove")).tag(new String[]{STATISTICS_TAG})).build();
        this.putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutIfAbsentOutcome.class).of((Object)this)).named("putIfAbsent")).tag(new String[]{STATISTICS_TAG})).build();
        this.conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalRemoveOutcome.class).of((Object)this)).named("conditionalRemove")).tag(new String[]{STATISTICS_TAG})).build();
        this.replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ReplaceOutcome.class).of((Object)this)).named("replace")).tag(new String[]{STATISTICS_TAG})).build();
        this.conditionalReplaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalReplaceOutcome.class).of((Object)this)).named("conditionalReplace")).tag(new String[]{STATISTICS_TAG})).build();
    }

    ClusteredStore(OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, ServerStoreProxy proxy, TimeSource timeSource) {
        this(codec, resolver, timeSource);
        this.storeProxy = proxy;
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        V value;
        this.getObserver.begin();
        try {
            value = this.getInternal(key);
        }
        catch (TimeoutException e) {
            this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.TIMEOUT);
            return null;
        }
        if (value == null) {
            this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
            return null;
        }
        this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
        return new ClusteredValueHolder<V>(value);
    }

    private V getInternal(K key) throws StoreAccessException, TimeoutException {
        V value = null;
        try {
            Chain chain = this.storeProxy.get(key.hashCode());
            if (!chain.isEmpty()) {
                ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
                Chain compactedChain = resolvedChain.getCompactedChain();
                this.storeProxy.replaceAtHead(key.hashCode(), chain, compactedChain);
                Result<V> resolvedResult = resolvedChain.getResolvedResult(key);
                if (resolvedResult != null) {
                    value = resolvedResult.getValue();
                }
            }
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        return value;
    }

    public boolean containsKey(K key) throws StoreAccessException {
        try {
            return this.getInternal(key) != null;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        this.putObserver.begin();
        Store.PutStatus status = this.silentPut(key, value);
        switch (status) {
            case PUT: {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.PUT);
                break;
            }
            case UPDATE: {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.REPLACED);
                break;
            }
            case NOOP: {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.NOOP);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid put status: " + status));
            }
        }
        return status;
    }

    private Store.PutStatus silentPut(K key, V value) throws StoreAccessException {
        try {
            PutOperation<K, V> operation = new PutOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            Chain chain = this.storeProxy.getAndAppend(key.hashCode(), payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            if (resolvedChain.getResolvedResult(key) == null) {
                return Store.PutStatus.PUT;
            }
            return Store.PutStatus.UPDATE;
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return Store.PutStatus.NOOP;
        }
        catch (TimeoutException e) {
            throw new StoreAccessTimeoutException((Throwable)e);
        }
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws StoreAccessException {
        this.putIfAbsentObserver.begin();
        try {
            PutIfAbsentOperation<K, V> operation = new PutIfAbsentOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            Chain chain = this.storeProxy.getAndAppend(key.hashCode(), payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            Result<V> result = resolvedChain.getResolvedResult(key);
            if (result == null) {
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
                return null;
            }
            this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
            return new ClusteredValueHolder<V>(result.getValue());
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
        catch (TimeoutException e) {
            throw new StoreAccessTimeoutException((Throwable)e);
        }
    }

    public boolean remove(K key) throws StoreAccessException {
        this.removeObserver.begin();
        if (this.silentRemove(key)) {
            this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.REMOVED);
            return true;
        }
        this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.MISS);
        return false;
    }

    private boolean silentRemove(K key) throws StoreAccessException {
        try {
            RemoveOperation operation = new RemoveOperation(key, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            Chain chain = this.storeProxy.getAndAppend(key.hashCode(), payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            return resolvedChain.getResolvedResult(key) != null;
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return false;
        }
        catch (TimeoutException e) {
            throw new StoreAccessTimeoutException((Throwable)e);
        }
    }

    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        this.conditionalRemoveObserver.begin();
        try {
            ConditionalRemoveOperation<K, V> operation = new ConditionalRemoveOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            Chain chain = this.storeProxy.getAndAppend(key.hashCode(), payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            Result<V> result = resolvedChain.getResolvedResult(key);
            if (result != null) {
                if (value.equals(result.getValue())) {
                    this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
                    return Store.RemoveStatus.REMOVED;
                }
                this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
                return Store.RemoveStatus.KEY_PRESENT;
            }
            this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
            return Store.RemoveStatus.KEY_MISSING;
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
        catch (TimeoutException e) {
            throw new StoreAccessTimeoutException((Throwable)e);
        }
    }

    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        this.replaceObserver.begin();
        try {
            ReplaceOperation<K, V> operation = new ReplaceOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            Chain chain = this.storeProxy.getAndAppend(key.hashCode(), payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            Result<V> result = resolvedChain.getResolvedResult(key);
            if (result == null) {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.MISS);
                return null;
            }
            this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.REPLACED);
            return new ClusteredValueHolder<V>(result.getValue());
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
        catch (TimeoutException e) {
            throw new StoreAccessTimeoutException((Throwable)e);
        }
    }

    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        this.conditionalReplaceObserver.begin();
        try {
            ConditionalReplaceOperation<K, V> operation = new ConditionalReplaceOperation<K, V>(key, oldValue, newValue, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            Chain chain = this.storeProxy.getAndAppend(key.hashCode(), payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            Result<V> result = resolvedChain.getResolvedResult(key);
            if (result != null) {
                if (oldValue.equals(result.getValue())) {
                    this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
                    return Store.ReplaceStatus.HIT;
                }
                this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
                return Store.ReplaceStatus.MISS_PRESENT;
            }
            this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
            return Store.ReplaceStatus.MISS_NOT_PRESENT;
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
        catch (TimeoutException e) {
            throw new StoreAccessTimeoutException((Throwable)e);
        }
    }

    public void clear() throws StoreAccessException {
        try {
            this.storeProxy.clear();
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        catch (TimeoutException e) {
            throw new StoreAccessTimeoutException((Throwable)e);
        }
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return new NullStoreEventDispatcher();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        throw new UnsupportedOperationException("Implement me");
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        throw new UnsupportedOperationException("Implement me");
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        throw new UnsupportedOperationException("Implement me");
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        throw new UnsupportedOperationException("Implement me");
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        HashMap valueHolderMap = new HashMap();
        if (remappingFunction instanceof Ehcache.PutAllFunction) {
            Ehcache.PutAllFunction putAllFunction = (Ehcache.PutAllFunction)remappingFunction;
            Map entriesToRemap = putAllFunction.getEntriesToRemap();
            for (Map.Entry entry : entriesToRemap.entrySet()) {
                Store.PutStatus putStatus = this.silentPut(entry.getKey(), entry.getValue());
                if (putStatus != Store.PutStatus.PUT && putStatus != Store.PutStatus.UPDATE) continue;
                putAllFunction.getActualPutCount().incrementAndGet();
                valueHolderMap.put(entry.getKey(), new ClusteredValueHolder(entry.getValue()));
            }
        } else if (remappingFunction instanceof Ehcache.RemoveAllFunction) {
            Ehcache.RemoveAllFunction removeAllFunction = (Ehcache.RemoveAllFunction)remappingFunction;
            for (K key : keys) {
                boolean removed = this.silentRemove(key);
                if (!removed) continue;
                removeAllFunction.getActualRemoveCount().incrementAndGet();
            }
        } else {
            throw new UnsupportedOperationException("This compute method is not yet capable of handling generic computation functions");
        }
        return valueHolderMap;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        throw new UnsupportedOperationException("Implement me");
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        if (mappingFunction instanceof Ehcache.GetAllFunction) {
            HashMap<K, ClusteredValueHolder<V>> map = new HashMap<K, ClusteredValueHolder<V>>();
            for (K key : keys) {
                V value;
                try {
                    value = this.getInternal(key);
                }
                catch (TimeoutException e) {
                    value = null;
                }
                ClusteredValueHolder<V> holder = null;
                if (value != null) {
                    holder = new ClusteredValueHolder<V>(value);
                }
                map.put(key, holder);
            }
            return map;
        }
        throw new UnsupportedOperationException("This compute method is not yet capable of handling generic computation functions");
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    public Store.ValueHolder<V> getAndFault(K key) throws StoreAccessException {
        return this.get(key);
    }

    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        return this.computeIfAbsent(key, mappingFunction);
    }

    public boolean flush(K key, Store.ValueHolder<V> valueHolder) {
        return true;
    }

    public void setInvalidationValve(AuthoritativeTier.InvalidationValve valve) {
        this.invalidationValve = valve;
    }

    private static class StoreConfig {
        private final ClusteringService.ClusteredCacheIdentifier cacheIdentifier;
        private final Store.Configuration storeConfig;
        private final Consistency consistency;

        StoreConfig(ClusteringService.ClusteredCacheIdentifier cacheIdentifier, Store.Configuration storeConfig, Consistency consistency) {
            this.cacheIdentifier = cacheIdentifier;
            this.storeConfig = storeConfig;
            this.consistency = consistency;
        }

        public Store.Configuration getStoreConfig() {
            return this.storeConfig;
        }

        public ClusteringService.ClusteredCacheIdentifier getCacheIdentifier() {
            return this.cacheIdentifier;
        }

        public Consistency getConsistency() {
            return this.consistency;
        }
    }

    public static class Provider
    implements Store.Provider,
    AuthoritativeTier.Provider {
        private static final Logger LOGGER = LoggerFactory.getLogger(Provider.class);
        private static final Set<ResourceType<?>> CLUSTER_RESOURCES;
        private volatile ServiceProvider<Service> serviceProvider;
        private volatile ClusteringService clusteringService;
        private final Map<Store<?, ?>, StoreConfig> createdStores = new ConcurrentWeakIdentityHashMap();

        public <K, V> ClusteredStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            DefaultCacheLoaderWriterConfiguration loaderWriterConfiguration = (DefaultCacheLoaderWriterConfiguration)ServiceLocator.findSingletonAmongst(DefaultCacheLoaderWriterConfiguration.class, (Object[])serviceConfigs);
            if (loaderWriterConfiguration != null) {
                throw new IllegalStateException("CacheLoaderWriter is not supported with clustered tiers");
            }
            CacheEventListenerConfiguration eventListenerConfiguration = (CacheEventListenerConfiguration)ServiceLocator.findSingletonAmongst(CacheEventListenerConfiguration.class, (Object[])serviceConfigs);
            if (eventListenerConfiguration != null) {
                throw new IllegalStateException("CacheEventListener is not supported with clustered tiers");
            }
            if (this.clusteringService == null) {
                throw new IllegalStateException(Provider.class.getCanonicalName() + ".createStore called without ClusteringServiceConfiguration");
            }
            HashSet clusteredResourceTypes = new HashSet(storeConfig.getResourcePools().getResourceTypeSet());
            clusteredResourceTypes.retainAll(CLUSTER_RESOURCES);
            if (clusteredResourceTypes.isEmpty()) {
                throw new IllegalStateException(Provider.class.getCanonicalName() + ".createStore called without ClusteredResourcePools");
            }
            if (clusteredResourceTypes.size() != 1) {
                throw new IllegalStateException(Provider.class.getCanonicalName() + ".createStore can not create clustered tier with multiple clustered resources");
            }
            ClusteredStoreConfiguration clusteredStoreConfiguration = (ClusteredStoreConfiguration)ServiceLocator.findSingletonAmongst(ClusteredStoreConfiguration.class, (Object[])serviceConfigs);
            if (clusteredStoreConfiguration == null) {
                clusteredStoreConfiguration = new ClusteredStoreConfiguration();
            }
            ClusteringService.ClusteredCacheIdentifier cacheId = (ClusteringService.ClusteredCacheIdentifier)ServiceLocator.findSingletonAmongst(ClusteringService.ClusteredCacheIdentifier.class, (Object[])serviceConfigs);
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            OperationsCodec codec = new OperationsCodec(storeConfig.getKeySerializer(), storeConfig.getValueSerializer());
            ChainResolver resolver = new ChainResolver(codec, storeConfig.getExpiry());
            ClusteredStore store = new ClusteredStore(codec, resolver, timeSource);
            this.createdStores.put((Store<?, ?>)store, new StoreConfig(cacheId, storeConfig, clusteredStoreConfiguration.getConsistency()));
            return store;
        }

        public void releaseStore(Store<?, ?> resource) {
            if (this.createdStores.remove(resource) == null) {
                throw new IllegalArgumentException("Given clustered tier is not managed by this provider : " + resource);
            }
            ClusteredStore clusteredStore = (ClusteredStore)resource;
            this.clusteringService.releaseServerStoreProxy(clusteredStore.storeProxy);
        }

        public void initStore(Store<?, ?> resource) {
            StoreConfig storeConfig = this.createdStores.get(resource);
            if (storeConfig == null) {
                throw new IllegalArgumentException("Given clustered tier is not managed by this provider : " + resource);
            }
            final ClusteredStore clusteredStore = (ClusteredStore)resource;
            try {
                clusteredStore.storeProxy = this.clusteringService.getServerStoreProxy(storeConfig.getCacheIdentifier(), storeConfig.getStoreConfig(), storeConfig.getConsistency());
            }
            catch (CachePersistenceException e) {
                throw new RuntimeException("Unable to create clustered tier proxy - " + storeConfig.getCacheIdentifier(), e);
            }
            clusteredStore.storeProxy.addInvalidationListener(new ServerStoreProxy.InvalidationListener(){

                @Override
                public void onInvalidateHash(long hash) {
                    if (clusteredStore.invalidationValve != null) {
                        try {
                            LOGGER.debug("CLIENT: calling invalidation valve for hash {}", (Object)hash);
                            clusteredStore.invalidationValve.invalidateAllWithHash(hash);
                        }
                        catch (StoreAccessException sae) {
                            LOGGER.error("Error invalidating hash {}", (Object)hash, (Object)sae);
                        }
                    }
                }

                @Override
                public void onInvalidateAll() {
                    if (clusteredStore.invalidationValve != null) {
                        try {
                            LOGGER.debug("CLIENT: calling invalidation valve for all");
                            clusteredStore.invalidationValve.invalidateAll();
                        }
                        catch (StoreAccessException sae) {
                            LOGGER.error("Error invalidating all", (Throwable)sae);
                        }
                    }
                }
            });
        }

        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            if (this.clusteringService == null || resourceTypes.size() > 1 || Collections.disjoint(resourceTypes, CLUSTER_RESOURCES)) {
                return 0;
            }
            return 1;
        }

        public int rankAuthority(ResourceType<?> authorityResource, Collection<ServiceConfiguration<?>> serviceConfigs) {
            if (this.clusteringService == null) {
                return 0;
            }
            return CLUSTER_RESOURCES.contains(authorityResource) ? 1 : 0;
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
            this.clusteringService = (ClusteringService)this.serviceProvider.getService(ClusteringService.class);
        }

        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore(storeConfig, serviceConfigs);
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }

        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore((Store<?, ?>)resource);
        }

        static {
            HashSet resourceTypes = new HashSet();
            Collections.addAll(resourceTypes, ClusteredResourceType.Types.values());
            CLUSTER_RESOURCES = Collections.unmodifiableSet(resourceTypes);
        }
    }
}

