/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.exception.TCNotRunningException;
import com.tc.logging.TCLogger;
import com.tc.object.ClientIDProvider;
import com.tc.object.locks.ClientLock;
import com.tc.object.locks.ClientLockImpl;
import com.tc.object.locks.ClientLockManager;
import com.tc.object.locks.ClientLockManagerConfig;
import com.tc.object.locks.ClientLockManagerTestMethods;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.GarbageLockException;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockLevel;
import com.tc.object.locks.LockStateNode;
import com.tc.object.locks.Notify;
import com.tc.object.locks.NotifyImpl;
import com.tc.object.locks.RemoteLockManager;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.object.locks.WaitListener;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.session.SessionID;
import com.tc.object.session.SessionManager;
import com.tc.operatorevent.LockEventListener;
import com.tc.text.PrettyPrinter;
import com.tc.util.FindbugsSuppressWarnings;
import com.tc.util.Util;
import com.tc.util.concurrent.TaskRunner;
import com.tc.util.concurrent.Timer;
import com.tc.util.runtime.ThreadIDManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClientLockManagerImpl
implements ClientLockManager,
ClientLockManagerTestMethods {
    private static final WaitListener NULL_LISTENER = new WaitListener(){

        @Override
        public void handleWaitEvent() {
        }
    };
    private final ConcurrentMap<LockID, ClientLock> locks;
    private final ReentrantReadWriteLock stateGuard = new ReentrantReadWriteLock();
    private final Condition runningCondition = this.stateGuard.writeLock().newCondition();
    private State state = State.RUNNING;
    private final RemoteLockManager remoteLockManager;
    private final ThreadIDManager threadManager;
    private final SessionManager sessionManager;
    private final TCLogger logger;
    private final ConcurrentMap<ThreadID, Object> inFlightLockQueries = new ConcurrentHashMap<ThreadID, Object>();
    private final List<LockEventListener> lockEventListeners = new CopyOnWriteArrayList<LockEventListener>();
    private final Timer gcTimer;
    private final Timer lockLeaseTimer;
    private final AtomicLong lockAwardSequence = new AtomicLong();
    private final ClientIDProvider clientIdProvider;

    public ClientLockManagerImpl(TCLogger logger, SessionManager sessionManager, ClientIDProvider clientIdProvider, RemoteLockManager remoteLockManager, ThreadIDManager threadManager, ClientLockManagerConfig config, TaskRunner taskRunner) {
        this.logger = logger;
        this.clientIdProvider = clientIdProvider;
        this.remoteLockManager = remoteLockManager;
        this.threadManager = threadManager;
        this.sessionManager = sessionManager;
        this.locks = new ConcurrentHashMap<LockID, ClientLock>(config.getStripedCount());
        long gcPeriod = Math.max(config.getTimeoutInterval(), 100L);
        this.gcTimer = taskRunner.newTimer("ClientLockManager LockGC");
        this.lockLeaseTimer = taskRunner.newTimer("ClientLockManager Lock Lease Timer");
        this.gcTimer.scheduleWithFixedDelay(new LockGcTimerTask(), gcPeriod, gcPeriod, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientLock getOrCreateClientLockState(LockID lock) {
        this.stateGuard.readLock().lock();
        try {
            ClientLock racer;
            this.throwExceptionIfNecessary();
            ClientLock lockState = (ClientLock)this.locks.get(lock);
            if (lockState == null && (racer = this.locks.putIfAbsent(lock, lockState = new ClientLockImpl(lock))) != null) {
                ClientLock clientLock = racer;
                return clientLock;
            }
            ClientLock clientLock = lockState;
            return clientLock;
        }
        finally {
            this.stateGuard.readLock().unlock();
        }
    }

    private ClientLock getClientLockState(LockID lock) {
        return (ClientLock)this.locks.get(lock);
    }

    @Override
    public void lock(LockID lock, LockLevel level) {
        this.waitUntilRunning();
        while (true) {
            ClientLock lockState = this.getOrCreateClientLockState(lock);
            try {
                lockState.lock(this.remoteLockManager, this.threadManager.getThreadID(), level);
            }
            catch (GarbageLockException e) {
                this.logger.info("Hitting garbage lock state during lock on " + lock);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean tryLock(LockID lock, LockLevel level) {
        this.waitUntilRunning();
        while (true) {
            ClientLock lockState = this.getOrCreateClientLockState(lock);
            try {
                return lockState.tryLock(this.remoteLockManager, this.threadManager.getThreadID(), level);
            }
            catch (GarbageLockException e) {
                this.logger.info("Hitting garbage lock state during tryLock on " + lock);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean tryLock(LockID lock, LockLevel level, long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("tryLock is passed with negative timeout, timeout=" + timeout);
        }
        this.waitUntilRunning();
        while (true) {
            ClientLock lockState = this.getOrCreateClientLockState(lock);
            try {
                return lockState.tryLock(this.remoteLockManager, this.threadManager.getThreadID(), level, timeout);
            }
            catch (GarbageLockException e) {
                this.logger.info("Hitting garbage lock state during tryLock with timeout on " + lock);
                continue;
            }
            break;
        }
    }

    @Override
    public void lockInterruptibly(LockID lock, LockLevel level) throws InterruptedException {
        this.waitUntilRunning();
        while (true) {
            ClientLock lockState = this.getOrCreateClientLockState(lock);
            try {
                lockState.lockInterruptibly(this.remoteLockManager, this.threadManager.getThreadID(), level);
            }
            catch (GarbageLockException e) {
                this.logger.info("Hitting garbage lock state during lockInterruptibly on " + lock);
                continue;
            }
            break;
        }
    }

    @Override
    public void unlock(LockID lock, LockLevel level) {
        ClientLock lockState = this.getOrCreateClientLockState(lock);
        lockState.unlock(this.remoteLockManager, this.threadManager.getThreadID(), level);
    }

    @Override
    public Notify notify(LockID lock, Object waitObject) {
        this.waitUntilRunning();
        ClientLock lockState = this.getOrCreateClientLockState(lock);
        ThreadID thread = this.threadManager.getThreadID();
        if (lockState.notify(this.remoteLockManager, thread, null)) {
            return new NotifyImpl(lock, thread, false);
        }
        return NotifyImpl.NULL;
    }

    @Override
    public Notify notifyAll(LockID lock, Object waitObject) {
        this.waitUntilRunning();
        ClientLock lockState = this.getOrCreateClientLockState(lock);
        ThreadID thread = this.threadManager.getThreadID();
        if (lockState.notifyAll(this.remoteLockManager, thread, null)) {
            return new NotifyImpl(lock, thread, true);
        }
        return NotifyImpl.NULL;
    }

    @Override
    public void wait(LockID lock, Object waitObject) throws InterruptedException {
        this.wait(lock, NULL_LISTENER, waitObject);
    }

    @Override
    public void wait(LockID lock, Object waitObject, long timeout) throws InterruptedException {
        this.wait(lock, NULL_LISTENER, waitObject, timeout);
    }

    @Override
    public boolean isLocked(LockID lock, LockLevel level) {
        this.waitUntilRunning();
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState != null && lockState.isLocked(level)) {
            return true;
        }
        block4: for (ClientServerExchangeLockContext cselc : this.queryLock(lock)) {
            if (this.remoteLockManager.getClientID().equals(cselc.getNodeID())) continue;
            switch (cselc.getState()) {
                case GREEDY_HOLDER_READ: 
                case HOLDER_READ: {
                    if (level != LockLevel.READ) continue block4;
                    return true;
                }
                case GREEDY_HOLDER_WRITE: 
                case HOLDER_WRITE: {
                    if (level != LockLevel.WRITE && level != LockLevel.SYNCHRONOUS_WRITE) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isLockedByCurrentThread(LockID lock, LockLevel level) {
        this.waitUntilRunning();
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState == null) {
            return false;
        }
        return lockState.isLockedBy(this.threadManager.getThreadID(), level);
    }

    @Override
    public boolean isLockedByCurrentThread(LockLevel level) {
        ThreadID thread = this.threadManager.getThreadID();
        for (ClientLock lockState : this.locks.values()) {
            if (!lockState.isLockedBy(thread, level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int localHoldCount(LockID lock, LockLevel level) {
        this.waitUntilRunning();
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState == null) {
            return 0;
        }
        return lockState.holdCount(level);
    }

    @Override
    public int globalHoldCount(LockID lock, LockLevel level) {
        this.waitUntilRunning();
        int holdCount = 0;
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState != null) {
            holdCount += lockState.holdCount(level);
        }
        for (ClientServerExchangeLockContext cselc : this.queryLock(lock)) {
            if (this.remoteLockManager.getClientID().equals(cselc.getNodeID())) continue;
            switch (cselc.getState()) {
                case GREEDY_HOLDER_READ: 
                case HOLDER_READ: {
                    if (level != LockLevel.READ) break;
                    ++holdCount;
                    break;
                }
                case GREEDY_HOLDER_WRITE: {
                    ++holdCount;
                    break;
                }
                case HOLDER_WRITE: {
                    if (level != LockLevel.WRITE && level != LockLevel.SYNCHRONOUS_WRITE) break;
                    ++holdCount;
                    break;
                }
            }
        }
        return holdCount;
    }

    @Override
    public int globalPendingCount(LockID lock) {
        this.waitUntilRunning();
        int pendingCount = 0;
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState != null) {
            pendingCount += lockState.pendingCount();
        }
        block3: for (ClientServerExchangeLockContext cselc : this.queryLock(lock)) {
            switch (cselc.getState()) {
                case PENDING_READ: 
                case PENDING_WRITE: {
                    ++pendingCount;
                    continue block3;
                }
            }
        }
        return pendingCount;
    }

    @Override
    public int globalWaitingCount(LockID lock) {
        this.waitUntilRunning();
        int waiterCount = 0;
        block3: for (ClientServerExchangeLockContext cselc : this.queryLock(lock)) {
            switch (cselc.getState()) {
                case WAITER: {
                    ++waiterCount;
                    continue block3;
                }
            }
        }
        if (waiterCount > 0) {
            return waiterCount;
        }
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState != null) {
            return lockState.waitingCount();
        }
        return 0;
    }

    @Override
    public void pinLock(LockID lock, long awardID) {
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState != null) {
            lockState.pinLock(awardID);
        }
    }

    @Override
    public void unpinLock(LockID lock, long awardID) {
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState != null) {
            lockState.unpinLock(awardID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void award(SessionID session, LockID lock, ThreadID thread, ServerLockLevel level) {
        block13: {
            this.stateGuard.readLock().lock();
            try {
                if (!this.sessionManager.isCurrentSession(session)) {
                    this.logger.warn("Ignoring lock award from a dead server :" + session + ", " + this.sessionManager + " : " + lock + " " + thread + " " + (Object)((Object)level) + " state = " + (Object)((Object)this.state));
                    return;
                }
                if (ThreadID.VM_ID.equals(thread)) {
                    while (true) {
                        ClientLock lockState = this.getOrCreateClientLockState(lock);
                        try {
                            lockState.award(this.remoteLockManager, thread, level, this.lockAwardSequence.incrementAndGet());
                            break block13;
                        }
                        catch (GarbageLockException e) {
                            this.logger.info("Hitting garbage lock state during award on " + lock);
                            continue;
                        }
                        break;
                    }
                }
                ClientLock lockState = this.getClientLockState(lock);
                if (lockState == null) {
                    this.remoteLockManager.unlock(lock, thread, level);
                } else {
                    try {
                        lockState.award(this.remoteLockManager, thread, level, this.lockAwardSequence.incrementAndGet());
                    }
                    catch (GarbageLockException e) {
                        this.remoteLockManager.unlock(lock, thread, level);
                    }
                }
            }
            finally {
                this.stateGuard.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notified(LockID lock, ThreadID thread) {
        this.stateGuard.readLock().lock();
        try {
            ClientLock lockState;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Got a notification for " + lock + " with thread " + thread);
            }
            if ((lockState = this.getClientLockState(lock)) == null) {
                throw new AssertionError((Object)("Server attempting to notify on non-existent lock " + lock));
            }
            lockState.notified(thread);
            return;
        }
        finally {
            this.stateGuard.readLock().unlock();
        }
    }

    @Override
    public void recall(SessionID session, LockID lock, ServerLockLevel level, int lease) {
        this.recall(session, lock, level, lease, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recall(SessionID session, LockID lock, ServerLockLevel level, int lease, boolean batch) {
        this.stateGuard.readLock().lock();
        try {
            if (this.isShutdown() || !this.sessionManager.isCurrentSession(session)) {
                this.logger.warn("Ignoring recall request from a dead server :" + session + ", " + this.sessionManager + " : " + lock + ", interestedLevel : " + (Object)((Object)level) + " state: " + (Object)((Object)this.state));
                return;
            }
            ClientLock lockState = this.getClientLockState(lock);
            if (lockState != null && lockState.recall(this.remoteLockManager, level, lease, batch)) {
                this.lockLeaseTimer.schedule(new LeaseTask(session, lock, level, batch), lease, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.stateGuard.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refuse(SessionID session, LockID lock, ThreadID thread, ServerLockLevel level) {
        this.stateGuard.readLock().lock();
        try {
            if (!this.sessionManager.isCurrentSession(session)) {
                this.logger.warn("Ignoring lock refuse from a dead server :" + session + ", " + this.sessionManager + " : " + lock + " " + thread + " " + (Object)((Object)level) + " state = " + (Object)((Object)this.state));
                return;
            }
            ClientLock lockState = this.getClientLockState(lock);
            if (lockState != null) {
                lockState.refuse(thread, level);
                return;
            }
        }
        finally {
            this.stateGuard.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FindbugsSuppressWarnings(value={"NN_NAKED_NOTIFY"})
    public void info(LockID lock, ThreadID requestor, Collection<ClientServerExchangeLockContext> contexts) {
        this.stateGuard.readLock().lock();
        try {
            Collection<ClientServerExchangeLockContext> old;
            Collection<ClientServerExchangeLockContext> collection = old = this.inFlightLockQueries.put(requestor, contexts);
            synchronized (collection) {
                old.notifyAll();
            }
        }
        finally {
            this.stateGuard.readLock().unlock();
        }
    }

    @Override
    public void wait(LockID lock, WaitListener listener, Object waitObject) throws InterruptedException {
        this.waitUntilRunning();
        ClientLock lockState = this.getOrCreateClientLockState(lock);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.threadManager.getThreadID() + " waiting on log " + lock);
        }
        lockState.wait(this.remoteLockManager, listener, this.threadManager.getThreadID(), waitObject);
    }

    @Override
    public void wait(LockID lock, WaitListener listener, Object waitObject, long timeout) throws InterruptedException {
        this.waitUntilRunning();
        ClientLock lockState = this.getOrCreateClientLockState(lock);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.threadManager.getThreadID() + " waiting on log " + lock);
        }
        lockState.wait(this.remoteLockManager, listener, this.threadManager.getThreadID(), waitObject, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeHandshake(ClientHandshakeMessage handshakeMessage) {
        this.stateGuard.writeLock().lock();
        try {
            this.state = this.state.initialize();
            if (this.state == State.STARTING) {
                for (ClientLock cls : this.locks.values()) {
                    cls.initializeHandshake(this.clientIdProvider.getClientID(), handshakeMessage);
                }
            }
        }
        finally {
            this.stateGuard.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        this.stateGuard.writeLock().lock();
        try {
            this.state = this.state.pause();
        }
        finally {
            this.stateGuard.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean fromShutdownHook) {
        this.stateGuard.writeLock().lock();
        try {
            this.state = this.state.shutdown();
            this.gcTimer.cancel();
            this.lockLeaseTimer.cancel();
            this.remoteLockManager.shutdown();
            this.runningCondition.signalAll();
            LockStateNode.shutdown();
        }
        finally {
            this.stateGuard.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpause() {
        this.stateGuard.writeLock().lock();
        try {
            this.state = this.state.unpause();
            if (this.state == State.RUNNING) {
                this.runningCondition.signalAll();
            }
        }
        finally {
            this.stateGuard.writeLock().unlock();
        }
        this.resubmitInFlightLockQueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilRunning() {
        this.stateGuard.readLock().lock();
        try {
            if (this.state == State.RUNNING) {
                return;
            }
        }
        finally {
            this.stateGuard.readLock().unlock();
        }
        boolean interrupted = false;
        this.stateGuard.writeLock().lock();
        try {
            while (this.state != State.RUNNING) {
                try {
                    if (this.isShutdown()) {
                        throw new TCNotRunningException();
                    }
                    this.runningCondition.await();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            this.stateGuard.writeLock().unlock();
            Util.selfInterruptIfNeeded(interrupted);
        }
    }

    private void throwExceptionIfNecessary() {
        if (this.isShutdown()) {
            throw new TCNotRunningException();
        }
    }

    private boolean isShutdown() {
        return this.state == State.SHUTDOWN;
    }

    private boolean paused() {
        return this.state == State.PAUSED;
    }

    @Override
    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        out.print("ClientLockManagerImpl [" + this.locks.size() + " locks]").flush();
        for (ClientLock lock : this.locks.values()) {
            out.indent().print(lock).flush();
        }
        return out;
    }

    @Override
    public Collection<ClientServerExchangeLockContext> getAllLockContexts() {
        ArrayList<ClientServerExchangeLockContext> contexts = new ArrayList<ClientServerExchangeLockContext>();
        for (ClientLock lock : this.locks.values()) {
            contexts.addAll(lock.getStateSnapshot(this.remoteLockManager.getClientID()));
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<ClientServerExchangeLockContext> queryLock(LockID lock) {
        ThreadID current = this.threadManager.getThreadID();
        this.inFlightLockQueries.put(current, lock);
        this.remoteLockManager.query(lock, this.threadManager.getThreadID());
        boolean interrupted = false;
        try {
            while (true) {
                LockID lockID = lock;
                synchronized (lockID) {
                    Object data = this.inFlightLockQueries.get(current);
                    if (data instanceof Collection) {
                        Collection<ClientServerExchangeLockContext> collection = ClientLockManagerImpl.castToCollection(data);
                        return collection;
                    }
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
        }
        finally {
            Util.selfInterruptIfNeeded(interrupted);
        }
    }

    private static Collection<ClientServerExchangeLockContext> castToCollection(Object data) {
        return (Collection)data;
    }

    private void resubmitInFlightLockQueries() {
        for (Map.Entry query : this.inFlightLockQueries.entrySet()) {
            if (!(query.getValue() instanceof LockID)) continue;
            this.remoteLockManager.query((LockID)query.getValue(), (ThreadID)query.getKey());
        }
    }

    @Override
    public int runLockGc() {
        new LockGcTimerTask().run();
        return this.locks.size();
    }

    @Override
    public boolean isLockAwardValid(LockID lock, long awardID) {
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState == null) {
            return false;
        }
        return lockState.isAwardValid(awardID);
    }

    @Override
    public long getAwardIDFor(LockID lock) {
        ClientLock lockState = this.getClientLockState(lock);
        if (lockState == null) {
            throw new IllegalStateException("LockState shouldn't be null");
        }
        return lockState.getAwardID();
    }

    class LockGcTimerTask
    implements Runnable {
        private static final int GCED_LOCK_THRESHOLD = 1000;

        LockGcTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int gcCount = 0;
                for (Map.Entry entry : ClientLockManagerImpl.this.locks.entrySet()) {
                    ClientLockManagerImpl.this.stateGuard.readLock().lock();
                    try {
                        if (ClientLockManagerImpl.this.state != State.RUNNING) {
                            return;
                        }
                        LockID lock = (LockID)entry.getKey();
                        ClientLock lockState = (ClientLock)entry.getValue();
                        if (lockState == null || !lockState.tryMarkAsGarbage(ClientLockManagerImpl.this.remoteLockManager) || !ClientLockManagerImpl.this.locks.remove(lock, lockState)) continue;
                        ++gcCount;
                    }
                    finally {
                        ClientLockManagerImpl.this.stateGuard.readLock().unlock();
                    }
                }
                if (gcCount > 0) {
                    ClientLockManagerImpl.this.logger.info("Lock GC collected " + gcCount + " garbage locks");
                }
                if (gcCount > 1000) {
                    for (LockEventListener lockGCEventListener : ClientLockManagerImpl.this.lockEventListeners) {
                        lockGCEventListener.fireLockGCEvent(gcCount);
                    }
                }
            }
            catch (TCNotRunningException e) {
                ClientLockManagerImpl.this.logger.info("Ignoring " + e.getMessage() + " in " + this.getClass().getName() + " and cancelling timer task");
            }
        }
    }

    class LeaseTask
    implements Runnable {
        private final SessionID session;
        private final LockID lock;
        private final ServerLockLevel level;
        private final boolean batch;

        public LeaseTask(SessionID session, LockID lock, ServerLockLevel level, boolean batch) {
            this.session = session;
            this.lock = lock;
            this.level = level;
            this.batch = batch;
        }

        @Override
        public void run() {
            try {
                ClientLockManagerImpl.this.recall(this.session, this.lock, this.level, -1, this.batch);
            }
            catch (TCNotRunningException e) {
                ClientLockManagerImpl.this.logger.info("Ignoring " + e.getMessage() + " in " + this.getClass().getName() + " and cancelling timer task");
            }
        }
    }

    static enum State {
        RUNNING{

            @Override
            State unpause() {
                throw new AssertionError((Object)("unpause is an invalid state transition for " + (Object)((Object)this)));
            }

            @Override
            State pause() {
                return PAUSED;
            }

            @Override
            State initialize() {
                throw new AssertionError((Object)("initialize is an invalid state transition for " + (Object)((Object)this)));
            }

            @Override
            State shutdown() {
                return SHUTDOWN;
            }
        }
        ,
        STARTING{

            @Override
            State unpause() {
                return RUNNING;
            }

            @Override
            State pause() {
                return PAUSED;
            }

            @Override
            State initialize() {
                throw new AssertionError((Object)("initialize is an invalid state transition for " + (Object)((Object)this)));
            }

            @Override
            State shutdown() {
                return SHUTDOWN;
            }
        }
        ,
        PAUSED{

            @Override
            State unpause() {
                throw new AssertionError((Object)("unpause is an invalid state transition for " + (Object)((Object)this)));
            }

            @Override
            State pause() {
                throw new AssertionError((Object)("pause is an invalid state transition for " + (Object)((Object)this)));
            }

            @Override
            State initialize() {
                return STARTING;
            }

            @Override
            State shutdown() {
                return SHUTDOWN;
            }
        }
        ,
        SHUTDOWN{

            @Override
            State pause() {
                return SHUTDOWN;
            }

            @Override
            State unpause() {
                return SHUTDOWN;
            }

            @Override
            State initialize() {
                return SHUTDOWN;
            }

            @Override
            State shutdown() {
                return SHUTDOWN;
            }
        };


        abstract State pause();

        abstract State unpause();

        abstract State initialize();

        abstract State shutdown();
    }
}

