/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.exception.TCRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class TCMessageType {
    public static final int TYPE_PING_MESSAGE = 1;
    public static final int TYPE_LOCK_REQUEST_MESSAGE = 9;
    public static final int TYPE_LOCK_RESPONSE_MESSAGE = 26;
    public static final int TYPE_CLIENT_HANDSHAKE_MESSAGE = 28;
    public static final int TYPE_CLIENT_HANDSHAKE_ACK_MESSAGE = 30;
    public static final int TYPE_LOCK_RECALL_MESSAGE = 33;
    public static final int TYPE_LOCK_QUERY_RESPONSE_MESSAGE = 35;
    public static final int TYPE_CLUSTER_MEMBERSHIP_EVENT_MESSAGE = 39;
    public static final int TYPE_GROUP_WRAPPER_MESSAGE = 46;
    public static final int TYPE_GROUP_HANDSHAKE_MESSAGE = 47;
    public static final int TYPE_CLIENT_HANDSHAKE_REFUSED_MESSAGE = 70;
    public static final int TYPE_LIST_REGISTERED_SERVICES_MESSAGE = 80;
    public static final int TYPE_LIST_REGISTERED_SERVICES_RESPONSE_MESSAGE = 81;
    public static final int TYPE_INVOKE_REGISTERED_SERVICE_MESSAGE = 82;
    public static final int TYPE_INVOKE_REGISTERED_SERVICE_RESPONSE_MESSAGE = 83;
    public static final int TYPE_VOLTRON_ENTITY_RECEIVED_RESPONSE = 86;
    public static final int TYPE_SERVER_ENTITY_MESSAGE = 88;
    public static final int TYPE_SERVER_ENTITY_RESPONSE_MESSAGE = 89;
    public static final int TYPE_VOLTRON_ENTITY_MESSAGE = 90;
    public static final int TYPE_VOLTRON_ENTITY_APPLIED_RESPONSE = 91;
    public static final int TYPE_VOLTRON_ENTITY_RETIRED_RESPONSE = 92;
    public static final TCMessageType PING_MESSAGE = new TCMessageType();
    public static final TCMessageType LOCK_REQUEST_MESSAGE = new TCMessageType();
    public static final TCMessageType LOCK_RECALL_MESSAGE = new TCMessageType();
    public static final TCMessageType LOCK_RESPONSE_MESSAGE = new TCMessageType();
    public static final TCMessageType LOCK_QUERY_RESPONSE_MESSAGE = new TCMessageType();
    public static final TCMessageType CLIENT_HANDSHAKE_MESSAGE = new TCMessageType();
    public static final TCMessageType CLIENT_HANDSHAKE_ACK_MESSAGE = new TCMessageType();
    public static final TCMessageType CLIENT_HANDSHAKE_REFUSED_MESSAGE = new TCMessageType();
    public static final TCMessageType CLUSTER_MEMBERSHIP_EVENT_MESSAGE = new TCMessageType();
    public static final TCMessageType GROUP_WRAPPER_MESSAGE = new TCMessageType();
    public static final TCMessageType GROUP_HANDSHAKE_MESSAGE = new TCMessageType();
    public static final TCMessageType LIST_REGISTERED_SERVICES_MESSAGE = new TCMessageType();
    public static final TCMessageType LIST_REGISTERED_SERVICES_RESPONSE_MESSAGE = new TCMessageType();
    public static final TCMessageType INVOKE_REGISTERED_SERVICE_MESSAGE = new TCMessageType();
    public static final TCMessageType INVOKE_REGISTERED_SERVICE_RESPONSE_MESSAGE = new TCMessageType();
    public static final TCMessageType VOLTRON_ENTITY_RECEIVED_RESPONSE = new TCMessageType();
    public static final TCMessageType SERVER_ENTITY_MESSAGE = new TCMessageType();
    public static final TCMessageType SERVER_ENTITY_RESPONSE_MESSAGE = new TCMessageType();
    public static final TCMessageType VOLTRON_ENTITY_MESSAGE = new TCMessageType();
    public static final TCMessageType VOLTRON_ENTITY_APPLIED_RESPONSE = new TCMessageType();
    public static final TCMessageType VOLTRON_ENTITY_RETIRED_RESPONSE = new TCMessageType();
    private static final Map<Integer, TCMessageType> typeMap = new HashMap<Integer, TCMessageType>();
    private static final String typePrefix = "TYPE_";
    private int type;
    private String typeName;

    public static TCMessageType getInstance(int i) {
        return typeMap.get(i);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String toString() {
        return this.typeName + " (" + this.type + ")";
    }

    private TCMessageType() {
    }

    private void setType(int type) {
        this.type = type;
    }

    private void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int hashCode() {
        return this.typeName.hashCode() + this.type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TCMessageType) {
            TCMessageType other = (TCMessageType)obj;
            return this.typeName.equals(other.typeName) && this.type == other.type;
        }
        return false;
    }

    private static TCMessageType[] init() throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = TCMessageType.class.getDeclaredFields();
        HashMap<String, Field> mtFields = new HashMap<String, Field>();
        HashMap<String, Integer> intFields = new HashMap<String, Integer>();
        for (Field field : fields) {
            boolean shouldInspect;
            String fName = field.getName();
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers)) {
                throw new RuntimeException("TCMessageType: " + fName + " must be final if public");
            }
            boolean bl = shouldInspect = Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
            if (!shouldInspect) continue;
            if (field.getType().equals(TCMessageType.class)) {
                if (!fName.toUpperCase().equals(fName)) {
                    throw new RuntimeException("TCMessageType: Message type names must be all UPPER CASE: " + fName);
                }
                if (fName.startsWith("_")) {
                    throw new RuntimeException("TCMessageType: Message type cannot start with underscore: " + fName);
                }
                mtFields.put(fName, field);
                continue;
            }
            if (!field.getType().equals(Integer.TYPE)) continue;
            if (!fName.startsWith(typePrefix)) {
                throw new RuntimeException("TCMessageType: Illegal integer field name: " + fName);
            }
            Integer value = (Integer)field.get(TCMessageType.class);
            intFields.put(fName, value);
        }
        Iterator iter = mtFields.values().iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            String name = field.getName();
            TCMessageType type = (TCMessageType)field.get(TCMessageType.class);
            String intName = typePrefix + name;
            if (!intFields.containsKey(intName)) {
                throw new RuntimeException("TCMessageType: Missing " + intName + " integer constant");
            }
            int val = (Integer)intFields.remove(intName);
            type.setType(val);
            type.setTypeName(name);
            TCMessageType prev = typeMap.put(type.getType(), type);
            if (prev != null) {
                throw new RuntimeException("TCMessageType: Duplicate message types defined for message number: " + type.getType());
            }
            iter.remove();
        }
        if (!mtFields.isEmpty()) {
            throw new RuntimeException("TCMessageType: internal error - not all message types filled in");
        }
        if (!intFields.isEmpty()) {
            String unused = intFields.keySet().toString();
            throw new RuntimeException("TCMessageType: Unused integer constants (please remove): " + unused);
        }
        TCMessageType[] rv = typeMap.values().toArray(new TCMessageType[0]);
        Arrays.sort(rv, new Comparator<TCMessageType>(){

            @Override
            public int compare(TCMessageType o1, TCMessageType o2) {
                int i2;
                int i1 = o1.getType();
                if (i1 < (i2 = o2.getType())) {
                    return -1;
                }
                if (i1 == i2) {
                    return 0;
                }
                if (i1 > i2) {
                    return 1;
                }
                throw new RuntimeException("internal error");
            }
        });
        return rv;
    }

    static {
        try {
            TCMessageType.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TCRuntimeException(e);
        }
    }
}

