/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ehcache.clustered.client.internal.service.ClusteredTierCreationException;
import org.ehcache.clustered.client.internal.service.ClusteredTierDestructionException;
import org.ehcache.clustered.client.internal.service.ClusteredTierManagerConfigurationException;
import org.ehcache.clustered.client.internal.service.ClusteredTierManagerValidationException;
import org.ehcache.clustered.client.internal.service.ClusteredTierReleaseException;
import org.ehcache.clustered.client.internal.service.ClusteredTierValidationException;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ClusteredEhcacheIdentity;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusteredEhcacheException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class EhcacheClientEntity
implements Entity {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheClientEntity.class);
    private final EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint;
    private final LifeCycleMessageFactory messageFactory;
    private final Map<Class<? extends EhcacheEntityResponse>, List<ResponseListener<? extends EhcacheEntityResponse>>> responseListeners = new ConcurrentHashMap<Class<? extends EhcacheEntityResponse>, List<ResponseListener<? extends EhcacheEntityResponse>>>();
    private final List<DisconnectionListener> disconnectionListeners = new CopyOnWriteArrayList<DisconnectionListener>();
    private volatile boolean connected = true;

    public EhcacheClientEntity(EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint) {
        this.endpoint = endpoint;
        this.messageFactory = new LifeCycleMessageFactory();
        endpoint.setDelegate(new EndpointDelegate(){

            @Override
            public void handleMessage(EntityResponse messageFromServer) {
                if (messageFromServer instanceof EhcacheEntityResponse) {
                    EhcacheClientEntity.this.fireResponseEvent((EhcacheEntityResponse)messageFromServer);
                }
            }

            @Override
            public byte[] createExtendedReconnectData() {
                return new byte[0];
            }

            @Override
            public void didDisconnectUnexpectedly() {
                EhcacheClientEntity.this.fireDisconnectionEvent();
            }
        });
    }

    void fireDisconnectionEvent() {
        this.connected = false;
        for (DisconnectionListener listener : this.disconnectionListeners) {
            listener.onDisconnection();
        }
    }

    void setConnected(boolean connected) {
        this.connected = connected;
    }

    private void fireResponseEvent(EhcacheEntityResponse response) {
        List<ResponseListener<? extends EhcacheEntityResponse>> responseListeners = this.responseListeners.get(response.getClass());
        if (responseListeners == null) {
            return;
        }
        LOGGER.debug("{} registered response listener(s) for {}", (Object)responseListeners.size(), response.getClass());
        for (ResponseListener<? extends EhcacheEntityResponse> responseListener : responseListeners) {
            responseListener.onResponse(response);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void addDisconnectionListener(DisconnectionListener listener) {
        this.disconnectionListeners.add(listener);
    }

    public <T extends EhcacheEntityResponse> void addResponseListener(Class<T> responseType, ResponseListener<T> responseListener) {
        List<ResponseListener<? extends EhcacheEntityResponse>> responseListeners = this.responseListeners.get(responseType);
        if (responseListeners == null) {
            responseListeners = new CopyOnWriteArrayList<ResponseListener<? extends EhcacheEntityResponse>>();
            this.responseListeners.put(responseType, responseListeners);
        }
        responseListeners.add(responseListener);
    }

    public UUID identity() {
        return ClusteredEhcacheIdentity.deserialize(this.endpoint.getEntityConfiguration());
    }

    @Override
    public void close() {
        this.endpoint.close();
    }

    public void validate(ServerSideConfiguration config) throws ClusteredTierManagerValidationException {
        try {
            this.invokeInternal(this.messageFactory.validateStoreManager(config), false);
        }
        catch (Exception e) {
            throw new ClusteredTierManagerValidationException("Error validating server clustered tier manager", e);
        }
    }

    public void configure(ServerSideConfiguration config) throws ClusteredTierManagerConfigurationException {
        try {
            this.invokeInternal(this.messageFactory.configureStoreManager(config), true);
        }
        catch (Exception e) {
            throw new ClusteredTierManagerConfigurationException("Error configuring clustered tier manager", e);
        }
    }

    public void createCache(String name, ServerStoreConfiguration serverStoreConfiguration) throws ClusteredTierCreationException {
        try {
            this.invokeInternal(this.messageFactory.createServerStore(name, serverStoreConfiguration), true);
        }
        catch (Exception e) {
            throw new ClusteredTierCreationException("Error creating clustered tier '" + name + "'", e);
        }
    }

    public void validateCache(String name, ServerStoreConfiguration serverStoreConfiguration) throws ClusteredTierValidationException {
        try {
            this.invokeInternal(this.messageFactory.validateServerStore(name, serverStoreConfiguration), false);
        }
        catch (Exception e) {
            throw new ClusteredTierValidationException("Error validating clustered tier '" + name + "'", e);
        }
    }

    public void releaseCache(String name) throws ClusteredTierReleaseException {
        try {
            this.invokeInternal(this.messageFactory.releaseServerStore(name), false);
        }
        catch (Exception e) {
            throw new ClusteredTierReleaseException("Error releasing clustered tier '" + name + "'", e);
        }
    }

    public void destroyCache(String name) throws ClusteredTierDestructionException {
        try {
            this.invokeInternal(this.messageFactory.destroyServerStore(name), true);
        }
        catch (Exception e) {
            throw new ClusteredTierDestructionException("Error destroying clustered tier '" + name + "'", e);
        }
    }

    public EhcacheEntityResponse invoke(EhcacheEntityMessage message, boolean replicate) throws ClusteredEhcacheException {
        return this.invokeInternal(message, replicate);
    }

    private EhcacheEntityResponse invokeInternal(EhcacheEntityMessage message, boolean replicate) throws ClusteredEhcacheException {
        try {
            EhcacheEntityResponse response = EhcacheClientEntity.waitFor(this.invokeAsync(message, replicate));
            if (EhcacheEntityResponse.Type.FAILURE.equals((Object)response.getType())) {
                Exception cause = ((EhcacheEntityResponse.Failure)response).getCause();
                if (cause instanceof ClusteredEhcacheException) {
                    throw (ClusteredEhcacheException)cause;
                }
                throw new RuntimeException(message + " error: " + cause.toString(), cause);
            }
            return response;
        }
        catch (EntityException e) {
            throw new RuntimeException(message + " error: " + e.toString(), e);
        }
        catch (MessageCodecException e) {
            throw new RuntimeException(message + " error: " + e.toString(), e);
        }
    }

    public InvokeFuture<EhcacheEntityResponse> invokeAsync(EhcacheEntityMessage message, boolean replicate) throws MessageCodecException {
        if (replicate) {
            return this.endpoint.beginInvoke().message(message).replicate(true).ackCompleted().invoke();
        }
        return this.endpoint.beginInvoke().message(message).invoke();
    }

    private static <T> T waitFor(InvokeFuture<T> future) throws EntityException {
        boolean interrupted = false;
        while (true) {
            try {
                T t = future.get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface DisconnectionListener {
        public void onDisconnection();
    }

    public static interface ResponseListener<T extends EhcacheEntityResponse> {
        public void onResponse(T var1);
    }
}

