/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config;

import java.net.URI;
import org.ehcache.CacheManager;
import org.ehcache.PersistentCacheManager;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.CacheManagerConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public final class ClusteringServiceConfiguration
implements ServiceCreationConfiguration<ClusteringService>,
CacheManagerConfiguration<PersistentCacheManager> {
    private static final String CLUSTER_SCEHEME = "terracotta";
    private final URI clusterUri;
    private final boolean autoCreate;
    private final ServerSideConfiguration serverConfiguration;

    public ClusteringServiceConfiguration(URI clusterUri) {
        ClusteringServiceConfiguration.validateClusterUri(clusterUri);
        this.clusterUri = clusterUri;
        this.autoCreate = false;
        this.serverConfiguration = null;
    }

    public ClusteringServiceConfiguration(URI clusterUri, boolean autoCreate, ServerSideConfiguration serverConfig) {
        ClusteringServiceConfiguration.validateClusterUri(clusterUri);
        if (serverConfig == null) {
            throw new NullPointerException("Server configuration cannot be null");
        }
        this.clusterUri = clusterUri;
        this.autoCreate = autoCreate;
        this.serverConfiguration = serverConfig;
    }

    private static void validateClusterUri(URI clusterUri) {
        if (clusterUri == null) {
            throw new IllegalArgumentException("Cluster URI cannot be null.");
        }
        if (!CLUSTER_SCEHEME.equals(clusterUri.getScheme())) {
            throw new IllegalArgumentException("Cluster Uri is not valid, clusterUri : " + clusterUri.toString());
        }
    }

    public URI getClusterUri() {
        return this.clusterUri;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public ServerSideConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public Class<ClusteringService> getServiceType() {
        return ClusteringService.class;
    }

    public CacheManagerBuilder<PersistentCacheManager> builder(CacheManagerBuilder<? extends CacheManager> other) {
        return other.using((ServiceCreationConfiguration)this);
    }
}

