/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.exception.TCInternalError;
import com.tc.exception.TCRuntimeException;
import com.tc.logging.ConnectionIdLogger;
import com.tc.logging.TCLogging;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.ReconnectionRejectedException;
import com.tc.net.core.ConnectionAddressProvider;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.TCConnection;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.JvmIDUtil;
import com.tc.net.protocol.transport.MessageTransportBase;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.MessageTransportState;
import com.tc.net.protocol.transport.MessageTransportStatus;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.net.protocol.transport.SynAckMessage;
import com.tc.net.protocol.transport.TransportHandshakeErrorContext;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeException;
import com.tc.net.protocol.transport.TransportHandshakeMessage;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactory;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import com.tc.util.concurrent.TCExceptionResultException;
import com.tc.util.concurrent.TCFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientMessageTransport
extends MessageTransportBase {
    public static final long TRANSPORT_HANDSHAKE_SYNACK_TIMEOUT = TCPropertiesImpl.getProperties().getLong("tc.transport.handshake.timeout", 10000L);
    private final ClientConnectionEstablisher connectionEstablisher;
    private boolean wasOpened = false;
    private TCFuture waitForSynAckResult;
    private final WireProtocolAdaptorFactory wireProtocolAdaptorFactory;
    private final AtomicBoolean isOpening = new AtomicBoolean(false);
    private final int callbackPort;
    private final TCSecurityManager securityManager;
    private final ConnectionAddressProvider addressProvider;

    public ClientMessageTransport(ClientConnectionEstablisher clientConnectionEstablisher, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, int callbackPort) {
        this(clientConnectionEstablisher, handshakeErrorHandler, messageFactory, wireProtocolAdaptorFactory, callbackPort, ReconnectionRejectedHandlerL1.SINGLETON, null, null);
    }

    public ClientMessageTransport(ClientConnectionEstablisher clientConnectionEstablisher, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, int callbackPort, ReconnectionRejectedHandler reconnectionRejectedHandler, TCSecurityManager securityManager, ConnectionAddressProvider addressProvider) {
        super(MessageTransportState.STATE_START, handshakeErrorHandler, messageFactory, false, TCLogging.getLogger(ClientMessageTransport.class));
        this.addressProvider = addressProvider;
        this.wireProtocolAdaptorFactory = wireProtocolAdaptorFactory;
        this.connectionEstablisher = clientConnectionEstablisher;
        this.callbackPort = callbackPort;
        this.securityManager = securityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkStackID open() throws TCTimeoutException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        this.isOpening.set(true);
        AtomicBoolean atomicBoolean = this.isOpen;
        synchronized (atomicBoolean) {
            Assert.eval("can't open an already open transport", !this.isOpen.get());
            this.connectionEstablisher.open(this);
            Assert.eval(!this.connectionId.isNull());
            this.isOpen.set(true);
            NetworkStackID nid = new NetworkStackID(this.connectionId.getChannelID());
            this.wasOpened = true;
            this.isOpening.set(false);
            return nid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AtomicBoolean atomicBoolean = this.isOpen;
        synchronized (atomicBoolean) {
            this.getLogger().info("Resetting connection " + this.connectionId);
            this.isOpen.set(false);
            this.connectionEstablisher.reset();
            this.connectionId = new ConnectionID(JvmIDUtil.getJvmID(), ChannelID.NULL_ID.toLong());
        }
    }

    private void handleHandshakeError(HandshakeResult result) throws TransportHandshakeException, MaxConnectionsExceededException, CommStackMismatchException, ReconnectionRejectedException {
        if (result.hasErrorContext()) {
            switch (result.getErrorType()) {
                case 5: {
                    this.cleanConnectionWithoutNotifyListeners();
                    throw new MaxConnectionsExceededException(this.getMaxConnectionsExceededMessage(result.maxConnections()));
                }
                case 3: {
                    this.cleanConnectionWithoutNotifyListeners();
                    throw new CommStackMismatchException("Disconnected due to comm stack mismatch");
                }
                case 6: {
                    this.cleanConnectionWithoutNotifyListeners();
                    this.fireTransportReconnectionRejectedEvent();
                    throw new ReconnectionRejectedException("Reconnection rejected by L2 due to stack not found. Client will be unable to join the cluster again unless rejoin is enabled.");
                }
            }
            throw new TransportHandshakeException("Disconnected due to transport handshake error");
        }
    }

    private void cleanConnectionWithoutNotifyListeners() {
        ArrayList<MessageTransportListener> tl = new ArrayList<MessageTransportListener>(this.getTransportListeners());
        this.removeTransportListeners();
        this.getConnectionEstablisher().reset();
        this.clearConnection();
        this.addTransportListeners(tl);
        this.status.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasOpened() {
        AtomicBoolean atomicBoolean = this.isOpen;
        synchronized (atomicBoolean) {
            return this.wasOpened;
        }
    }

    public boolean isNotOpen() {
        return !this.isOpening.get() && !this.isOpen.get();
    }

    @Override
    public void closeEvent(TCConnectionEvent event) {
        if (this.isNotOpen()) {
            return;
        }
        super.closeEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void receiveTransportMessageImpl(WireProtocolMessage message) {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (this.status.isSynSent()) {
                this.handleSynAck(message);
                message.recycle();
                return;
            }
            if (!this.status.isEstablished()) {
                this.getLogger().warn("Ignoring the message received for an Un-Established Connection; " + message.getSource() + "; " + message);
                message.recycle();
                return;
            }
        }
        super.receiveToReceiveLayer(message);
    }

    private void handleSynAck(WireProtocolMessage message) {
        if (!this.verifySynAck(message)) {
            this.handleHandshakeError(new TransportHandshakeErrorContext("Received a message that was not a SYN_ACK while waiting for SYN_ACK: " + message, 1));
        } else {
            SynAckMessage synAck = (SynAckMessage)message;
            if (synAck.hasErrorContext()) {
                if (synAck.getErrorType() == 3) {
                    this.handleHandshakeError(new TransportHandshakeErrorContext(this.getCommsStackMismatchErrorMessage(synAck) + "\n\nPLEASE RECONFIGURE THE STACKS", synAck.getErrorType()));
                } else {
                    this.handleHandshakeError(new TransportHandshakeErrorContext(synAck.getErrorContext() + message, synAck.getErrorType()));
                }
            }
            if (!this.connectionId.isNewConnection()) {
                Assert.eval(this.connectionId.equals(synAck.getConnectionId()));
            }
            if (!synAck.isMaxConnectionsExceeded()) {
                this.connectionId = synAck.getConnectionId();
                Assert.assertNotNull("Connection id from the server was null!", this.connectionId);
                Assert.eval(!ConnectionID.NULL_ID.equals(this.connectionId));
                Assert.assertNotNull(this.waitForSynAckResult);
            }
            this.getConnection().setTransportEstablished();
            this.waitForSynAckResult.set(synAck);
            this.setRemoteCallbackPort(synAck.getCallbackPort());
        }
    }

    private String getCommsStackMismatchErrorMessage(SynAckMessage synAck) {
        String errorMessage = "\n\nLayers Present in Client side communication stack: ";
        errorMessage = errorMessage + this.getCommunicationStackNames(this);
        errorMessage = "\nTHERE IS A MISMATCH IN THE COMMUNICATION STACKS\n" + synAck.getErrorContext() + errorMessage;
        if ((this.getCommunicationStackFlags(this) & 2) != 0) {
            this.getLogger().error("Once and Only Once Protocol Layer is present in client but not in server");
            errorMessage = "\n\nOnce and Only Once Protocol Layer is present in client but not in server" + errorMessage;
        } else {
            this.getLogger().error("Once and Only Once Protocol Layer is present in server but not in client");
            errorMessage = "\n\nOnce and Only Once Protocol Layer is present in server but not in client" + errorMessage;
        }
        return errorMessage;
    }

    private boolean verifySynAck(TCNetworkMessage message) {
        return message instanceof TransportHandshakeMessage && ((TransportHandshakeMessage)message).isSynAck();
    }

    HandshakeResult handShake() throws TCTimeoutException {
        this.sendSyn();
        SynAckMessage synAck = this.waitForSynAck();
        return new HandshakeResult(synAck);
    }

    private SynAckMessage waitForSynAck() throws TCTimeoutException {
        try {
            SynAckMessage synAck = (SynAckMessage)this.waitForSynAckResult.get(TRANSPORT_HANDSHAKE_SYNACK_TIMEOUT);
            return synAck;
        }
        catch (InterruptedException e) {
            throw new TCRuntimeException(e);
        }
        catch (TCExceptionResultException e) {
            throw new TCInternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSyn() {
        this.getConnection().addWeight(1);
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (this.status.isEstablished() || this.status.isSynSent()) {
                throw new AssertionError((Object)(" ERROR !!! " + this.status));
            }
            this.waitForSynAckResult = new TCFuture(this.status);
            short stackLayerFlags = this.getCommunicationStackFlags(this);
            if (this.connectionId.isSecured() && this.connectionId.getPassword() == null) {
                ConnectionInfo connectionInfo = this.addressProvider.getIterator().next();
                this.connectionId.setPassword(this.securityManager.getPasswordForTC(this.connectionId.getUsername(), connectionInfo.getHostname(), connectionInfo.getPort()));
            }
            TransportHandshakeMessage syn = this.messageFactory.createSyn(this.connectionId, this.getConnection(), stackLayerFlags, this.callbackPort);
            this.sendToConnection(syn);
            this.status.synSent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAck() throws TransportHandshakeException {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (!this.status.isSynSent()) {
                throw new TransportHandshakeException("Transport is not " + (Object)((Object)MessageTransportState.STATE_SYN_SENT) + ". Status: " + this.status);
            }
            TransportHandshakeMessage ack = this.messageFactory.createAck(this.connectionId, this.getConnection());
            this.sendToConnection(ack);
            this.status.established();
        }
        this.fireTransportConnectedEvent();
    }

    protected void openConnection(TCConnection connection) throws TCTimeoutException, TransportHandshakeException, MaxConnectionsExceededException, CommStackMismatchException {
        Assert.eval(!this.isConnected());
        this.wireNewConnection(connection);
        try {
            this.handshakeConnection(connection);
        }
        catch (TCTimeoutException e) {
            this.clearConnection();
            this.status.reset();
            throw e;
        }
        catch (ReconnectionRejectedException e) {
            throw new TCRuntimeException("Should not happen here: " + e);
        }
        catch (TransportHandshakeException e) {
            this.clearConnection();
            this.status.reset();
            throw e;
        }
    }

    void reconnect(TCConnection connection) throws Exception {
        if (!this.wasOpened()) {
            this.getLogger().warn("Transport was opened already. Skip reconnect " + connection);
            return;
        }
        Assert.eval(!this.isConnected());
        this.wireNewConnection(connection);
        try {
            this.handshakeConnection(connection);
        }
        catch (Exception t) {
            this.status.reset();
            throw t;
        }
    }

    private void handshakeConnection(TCConnection connection) throws TCTimeoutException, MaxConnectionsExceededException, TransportHandshakeException, CommStackMismatchException, ReconnectionRejectedException {
        HandshakeResult result = this.handShake();
        this.handleHandshakeError(result);
        this.sendAck();
        this.connectionId.authenticated();
    }

    private String getMaxConnectionsExceededMessage(int maxConnections) {
        return "Your product key only allows maximum " + maxConnections + " clients to connect.";
    }

    TCProtocolAdaptor getProtocolAdapter() {
        return this.wireProtocolAdaptorFactory.newWireProtocolAdaptor(new WireProtocolMessageSink(){

            @Override
            public void putMessage(WireProtocolMessage message) {
                ClientMessageTransport.this.receiveTransportMessage(message);
            }
        });
    }

    @Override
    protected void fireTransportConnectAttemptEvent() {
        super.fireTransportConnectAttemptEvent();
    }

    @Override
    public boolean isConnected() {
        return super.isConnected();
    }

    public ClientConnectionEstablisher getConnectionEstablisher() {
        return this.connectionEstablisher;
    }

    public void switchLoggerForTesting(ConnectionIdLogger tmpLogger) {
        this.logger = tmpLogger;
    }

    private static final class HandshakeResult {
        private final SynAckMessage synAck;

        private HandshakeResult(SynAckMessage synAck) {
            this.synAck = synAck;
        }

        public int maxConnections() {
            return this.synAck.getMaxConnections();
        }

        public boolean hasErrorContext() {
            return this.synAck.isMaxConnectionsExceeded() || this.synAck.hasErrorContext();
        }

        public short getErrorType() {
            if (this.synAck.isMaxConnectionsExceeded()) {
                return 5;
            }
            return this.synAck.getErrorType();
        }
    }
}

