/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.maven;

import com.google.common.base.Predicate;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.builder.standalone.LanguageAccessFactory;
import org.eclipse.xtext.builder.standalone.StandaloneBuilder;
import org.eclipse.xtext.builder.standalone.compiler.CompilerConfiguration;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.maven.AbstractXtextMojo;
import org.eclipse.xtext.maven.ClusteringConfig;
import org.eclipse.xtext.maven.MavenLog4JConfigurator;
import org.eclipse.xtext.maven.MavenStandaloneBuilderModule;
import org.eclipse.xtext.maven.ProjectMapping;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractXtextGeneratorMojo
extends AbstractXtextMojo {
    @Parameter(property="xtext.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project.build.directory}/xtext-temp")
    private String tmpClassDirectory;
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true)
    private List<String> javaSourceRoots;
    @Parameter
    private List<ProjectMapping> projectMappings;
    @Parameter(property="xtext.generator.skip", defaultValue="false")
    private Boolean skip;
    @Parameter(defaultValue="true")
    private Boolean failOnValidationError;
    @Parameter(property="maven.compiler.source", defaultValue="11")
    private String compilerSourceLevel;
    @Parameter(property="maven.compiler.target", defaultValue="11")
    private String compilerTargetLevel;
    @Parameter(defaultValue="false")
    private Boolean compilerSkipAnnotationProcessing;
    @Parameter(defaultValue="false")
    private Boolean compilerPreserveInformationAboutFormalParameters;
    @Parameter
    private String classPathLookupFilter;
    @Parameter
    private ClusteringConfig clusteringConfig;
    @Parameter(defaultValue="false")
    private Boolean autoFillPlatformResourceMap = Boolean.FALSE;
    @Parameter(defaultValue="true")
    private Boolean addOutputDirectoriesToCompileSourceRoots = Boolean.TRUE;
    @Parameter(defaultValue="false")
    private Boolean incrementalXtextBuild = Boolean.FALSE;

    public String getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"skipped.");
        } else {
            Object object = lock;
            synchronized (object) {
                new MavenLog4JConfigurator().configureLog4j(this.getLog());
                this.autoAddToPlatformResourceMap(this.getProject());
                this.manuallyAddToPlatformResourceMap();
                this.internalExecute();
            }
        }
    }

    protected void internalExecute() throws MojoExecutionException {
        boolean errorDetected;
        if (this.addOutputDirectoriesToCompileSourceRoots.booleanValue()) {
            this.configureMavenOutputs();
        }
        Map languages = new LanguageAccessFactory().createLanguageAccess(this.getLanguages(), ((Object)((Object)this)).getClass().getClassLoader());
        Injector injector = Guice.createInjector((Module[])new Module[]{new MavenStandaloneBuilderModule()});
        StandaloneBuilder builder = (StandaloneBuilder)injector.getInstance(StandaloneBuilder.class);
        builder.setBaseDir(this.getProject().getBasedir().getAbsolutePath());
        builder.setLanguages(languages);
        builder.setEncoding(this.getEncoding());
        builder.setClassPathEntries(this.getClasspathElements());
        builder.setClassPathLookUpFilter(this.classPathLookupFilter);
        builder.setSourceDirs(this.getSourceRoots());
        builder.setJavaSourceDirs(this.javaSourceRoots);
        builder.setFailOnValidationError(this.failOnValidationError.booleanValue());
        builder.setTempDir(this.createTempDir().getAbsolutePath());
        builder.setDebugLog(this.getLog().isDebugEnabled());
        builder.setIncrementalBuild(this.incrementalXtextBuild.booleanValue());
        if (this.clusteringConfig != null) {
            builder.setClusteringConfig(this.clusteringConfig.convertToStandaloneConfig());
        }
        this.configureCompiler(builder.getCompiler());
        this.logState();
        boolean bl = errorDetected = !builder.launch();
        if (errorDetected && this.failOnValidationError.booleanValue()) {
            throw new MojoExecutionException("Execution failed due to a severe validation error.");
        }
    }

    protected abstract List<String> getSourceRoots();

    private void configureCompiler(IJavaCompiler compiler) {
        CompilerConfiguration conf = compiler.getConfiguration();
        conf.setSourceLevel(this.compilerSourceLevel);
        conf.setTargetLevel(this.compilerTargetLevel);
        conf.setVerbose(this.getLog().isDebugEnabled());
        conf.setSkipAnnotationProcessing(this.compilerSkipAnnotationProcessing.booleanValue());
        conf.setPreserveInformationAboutFormalParameters(this.compilerPreserveInformationAboutFormalParameters.booleanValue());
    }

    private void logState() {
        this.getLog().info((CharSequence)("Encoding: " + (this.getEncoding() == null ? "not set. Encoding provider will be used." : this.getEncoding())));
        this.getLog().info((CharSequence)("Compiler source level: " + this.compilerSourceLevel));
        this.getLog().info((CharSequence)("Compiler target level: " + this.compilerTargetLevel));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Source dirs: " + IterableExtensions.join(this.getSourceRoots(), (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Java source dirs: " + IterableExtensions.join(this.javaSourceRoots, (CharSequence)", ")));
            this.getLog().debug((CharSequence)("Classpath entries: " + IterableExtensions.join(this.getClasspathElements(), (CharSequence)", ")));
        }
    }

    private File createTempDir() {
        File tmpDir = new File(String.valueOf(this.tmpClassDirectory) + this.tmpDirSuffix());
        if (!tmpDir.mkdirs() && !tmpDir.exists()) {
            throw new IllegalArgumentException("Couldn't create directory '" + this.tmpClassDirectory + "'.");
        }
        return tmpDir;
    }

    protected String tmpDirSuffix() {
        return "";
    }

    protected Predicate<String> emptyStringFilter() {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isEmpty((String)input.trim());
            }
        };
    }

    public abstract Set<String> getClasspathElements();

    protected abstract void configureMavenOutputs();

    public List<ProjectMapping> getProjectMappings() {
        return this.projectMappings;
    }

    public void setProjectMappings(List<ProjectMapping> projectMappings) {
        this.projectMappings = projectMappings;
    }

    private void autoAddToPlatformResourceMap(MavenProject project) {
        if (this.autoFillPlatformResourceMap.booleanValue()) {
            this.addToPlatformResourceMap(project.getBasedir());
            project.getModules().stream().map(module -> new File(project.getBasedir(), (String)module)).forEach(this::addToPlatformResourceMap);
            if (project.getParent() != null) {
                this.autoAddToPlatformResourceMap(project.getParent());
            }
        }
    }

    private void manuallyAddToPlatformResourceMap() {
        if (this.projectMappings != null) {
            for (ProjectMapping projectMapping : this.projectMappings) {
                if (projectMapping.getPath() == null || projectMapping.getProjectName() == null) continue;
                String path = projectMapping.getPath().toURI().toString();
                String name = projectMapping.getProjectName();
                this.getLog().info((CharSequence)("Adding project '" + name + "' with path '" + path + "' to Platform Resource Map"));
                URI uri = URI.createURI((String)path);
                EcorePlugin.getPlatformResourceMap().put(name, uri);
            }
        }
    }

    private URI addToPlatformResourceMap(File file) {
        this.getLog().info((CharSequence)("Adding project '" + file.getName() + "' with path '" + file.toURI().toString() + "' to Platform Resource Map"));
        URI uri = URI.createURI((String)file.toURI().toString());
        return EcorePlugin.getPlatformResourceMap().put(file.getName(), uri);
    }
}

