/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.maven.trace;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationProvider;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceToBytecodeInstaller;
import org.eclipse.xtext.generator.trace.TraceAsPrimarySourceInstaller;
import org.eclipse.xtext.generator.trace.TraceAsSmapInstaller;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.maven.AbstractXtextMojo;
import org.eclipse.xtext.maven.Language;
import org.eclipse.xtext.maven.MavenLog4JConfigurator;
import org.eclipse.xtext.maven.MavenStandaloneBuilderModule;
import org.eclipse.xtext.maven.trace.ClassFileDebugSourceExtractor;
import org.eclipse.xtext.resource.FileExtensionProvider;

public abstract class AbstractInstallDebugInfoMojo
extends AbstractXtextMojo {
    @Inject
    private Provider<TraceAsPrimarySourceInstaller> traceAsPrimarySourceInstallerProvider;
    @Inject
    private Provider<TraceAsSmapInstaller> traceAsSmapInstaller;
    @Inject
    private TraceRegionSerializer traceRegionSerializer;
    @Inject
    private ClassFileDebugSourceExtractor debugSourceExtractor;
    @Parameter(property="project.basedir")
    private File baseDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Object object = lock;
        synchronized (object) {
            new MavenLog4JConfigurator().configureLog4j(this.getLog());
            Injector injector = Guice.createInjector((Module[])new Module[]{new MavenStandaloneBuilderModule()});
            injector.injectMembers((Object)this);
            for (Language language : this.getLanguages()) {
                Set outputConfigurations = language.getOutputConfigurations();
                if (outputConfigurations == null) {
                    this.getLog().warn((CharSequence)("No output configurations available for language " + language.getSetup() + ", assuming default layout and using SMAP trace."));
                    outputConfigurations = new OutputConfigurationProvider().getOutputConfigurations();
                }
                try {
                    Class<?> setup = ((Object)((Object)this)).getClass().getClassLoader().loadClass(language.getSetup());
                    ISetup languageSetup = (ISetup)setup.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Injector languageInjector = languageSetup.createInjectorAndDoEMFRegistration();
                    FileExtensionProvider fileExtensionProvider = (FileExtensionProvider)languageInjector.getInstance(FileExtensionProvider.class);
                    TraceFileNameProvider traceFileNameProvider = (TraceFileNameProvider)languageInjector.getInstance(TraceFileNameProvider.class);
                    for (OutputConfiguration config : outputConfigurations) {
                        ITraceToBytecodeInstaller traceInstaller = this.getTraceInstaller(config);
                        List<Trace> traces = this.createTraceInformation(this.getOutputDirectories(config), traceFileNameProvider);
                        this.installTraces(fileExtensionProvider.getFileExtensions(), traceInstaller, traces, traceFileNameProvider);
                    }
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to install traces for " + language.getSetup(), e);
                }
            }
        }
    }

    private Set<File> getOutputDirectories(OutputConfiguration config) {
        return config.getOutputDirectories().stream().map(this::resolveFilePath).collect(Collectors.toSet());
    }

    protected abstract File getOutputDirectory();

    private ITraceToBytecodeInstaller getTraceInstaller(OutputConfiguration config) {
        ITraceToBytecodeInstaller bytecodeInstaller;
        ITraceToBytecodeInstaller iTraceToBytecodeInstaller = bytecodeInstaller = config.isInstallDslAsPrimarySource() ? (ITraceToBytecodeInstaller)this.traceAsPrimarySourceInstallerProvider.get() : (ITraceToBytecodeInstaller)this.traceAsSmapInstaller.get();
        if (bytecodeInstaller instanceof TraceAsPrimarySourceInstaller) {
            boolean hideSyntheticLocalVariables = config.isHideSyntheticLocalVariables();
            ((TraceAsPrimarySourceInstaller)bytecodeInstaller).setHideSyntheticVariables(hideSyntheticLocalVariables);
        }
        return bytecodeInstaller;
    }

    protected void collectTraceInformationForClassFiles(File sourceFolder, List<Trace> traces, TraceFileNameProvider traceFileNameProvider) throws IOException {
        File root = this.getOutputDirectory();
        if (!root.exists()) {
            this.getLog().info((CharSequence)("Unable to attach trace files, output directory " + root + " does not exist"));
            return;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (Stream<Path> walker = Files.walk(root.toPath(), new FileVisitOption[0]);){
            walker.forEach(path -> {
                File file3 = path.toFile();
                boolean isClassFile = "class".equals(com.google.common.io.Files.getFileExtension((String)file3.getName()));
                if (isClassFile) {
                    try {
                        String javaSourceName = this.debugSourceExtractor.getDebugSourceFileName(file3);
                        Path relativeJavaFilePath = root.toPath().relativize((Path)path);
                        Path srcGenRelativeFolder = sourceFolder.toPath().resolve(relativeJavaFilePath).getParent();
                        Path javaFilePath = srcGenRelativeFolder.resolve(javaSourceName);
                        if (javaFilePath.toFile().exists()) {
                            String traceFileName = traceFileNameProvider.getTraceFromJava(javaFilePath.toFile().getName());
                            Path traceFilePath = srcGenRelativeFolder.resolve(traceFileName);
                            if (traceFilePath.toFile().exists()) {
                                Trace trace = new Trace();
                                trace.classFile = file3;
                                trace.traceFile = traceFilePath.toFile();
                                traces.add(trace);
                            } else {
                                this.getLog().debug((CharSequence)("Trace file for file " + file3 + "not found"));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("Failed to analyze file " + file3), (Throwable)e);
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<Trace> createTraceInformation(Set<File> sourceDirectories, TraceFileNameProvider traceFileNameProvider) throws IOException {
        ArrayList<Trace> traces = new ArrayList<Trace>();
        for (File sourceDirectory : sourceDirectories) {
            this.collectTraceInformationForClassFiles(sourceDirectory, traces, traceFileNameProvider);
        }
        return traces;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void installTrace(Set<String> fileExtensions, ITraceToBytecodeInstaller traceToBytecodeInstaller, Trace trace, TraceFileNameProvider traceFileNameProvider) throws IOException {
        File traceFile = trace.traceFile;
        File classFile = trace.classFile;
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            AbstractTraceRegion traceRegion;
            BufferedInputStream in;
            FileInputStream fis;
            block21: {
                block22: {
                    fis = new FileInputStream(traceFile);
                    in = new BufferedInputStream(fis);
                    traceRegion = this.traceRegionSerializer.readTraceRegionFrom((InputStream)in);
                    if (this.isRelevantFile(fileExtensions, traceRegion)) break block21;
                    if (in == null) break block22;
                    in.close();
                }
                if (fis == null) return;
                ((InputStream)fis).close();
                return;
            }
            try {
                block23: {
                    byte[] bytecodeWithTraces;
                    traceToBytecodeInstaller.setTrace(traceFileNameProvider.getJavaFromTrace(traceFile.getName()), traceRegion);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Installing trace " + traceFile + " into:"));
                    }
                    if ((bytecodeWithTraces = traceToBytecodeInstaller.installTrace(com.google.common.io.Files.toByteArray((File)classFile))) != null) {
                        com.google.common.io.Files.write((byte[])bytecodeWithTraces, (File)classFile);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("  " + classFile));
                        }
                    } else if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("  No trace installed for " + classFile));
                    }
                    break block23;
                    {
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                if (fis == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (fis == null) throw throwable;
                ((InputStream)fis).close();
                throw throwable;
            }
            ((InputStream)fis).close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            } else {
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected void installTraces(Set<String> fileExtensions, ITraceToBytecodeInstaller traceToBytecodeInstaller, List<Trace> traceToClassFileMap, TraceFileNameProvider traceFileNameProvider) {
        for (Trace trace : traceToClassFileMap) {
            try {
                this.installTrace(fileExtensions, traceToBytecodeInstaller, trace, traceFileNameProvider);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Error installing trace into " + trace.classFile), (Throwable)e);
            }
        }
    }

    protected boolean isRelevantFile(Set<String> fileExtensions, AbstractTraceRegion traceRegion) {
        String fileExtension = traceRegion.getAssociatedSrcRelativePath().getURI().fileExtension();
        return fileExtensions.contains(fileExtension);
    }

    private class Trace {
        File traceFile;
        File classFile;

        private Trace() {
        }
    }
}

