/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.maven.Language;

public abstract class AbstractXtextMojo
extends AbstractMojo {
    protected static final Object lock = new Object();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(required=true)
    private List<Language> languages;

    public MavenProject getProject() {
        return this.project;
    }

    public List<Language> getLanguages() {
        return this.languages;
    }

    protected File resolveFilePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.project.getBasedir(), path);
        }
        return file;
    }

    protected void addCompileSourceRoots(Language language) {
        if (language.getOutputConfigurations() == null) {
            return;
        }
        for (OutputConfiguration configuration : language.getOutputConfigurations()) {
            for (String output : configuration.getOutputDirectories()) {
                this.getLog().debug((CharSequence)("Adding output folder " + output + " to compile roots"));
                this.project.addCompileSourceRoot(output);
            }
        }
    }

    protected void addTestCompileSourceRoots(Language language) {
        if (language.getOutputConfigurations() == null) {
            return;
        }
        for (OutputConfiguration configuration : language.getOutputConfigurations()) {
            for (String output : configuration.getOutputDirectories()) {
                this.getLog().debug((CharSequence)("Adding output folder " + output + " to test compile roots"));
                this.project.addTestCompileSourceRoot(output);
            }
        }
    }
}

