/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat.debug;

import org.apache.log4j.Logger;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.parser.packrat.consumers.IConsumerUtility;
import org.eclipse.xtext.parser.packrat.consumers.INonTerminalConsumer;
import org.eclipse.xtext.parser.packrat.consumers.ITerminalConsumer;
import org.eclipse.xtext.parser.packrat.matching.ICharacterClass;
import org.eclipse.xtext.parser.packrat.matching.ISequenceMatcher;

public class DebugConsumerUtility
implements IConsumerUtility {
    private static final Logger log = Logger.getLogger(DebugConsumerUtility.class);
    private final IConsumerUtility delegate;

    public DebugConsumerUtility(IConsumerUtility delegate) {
        this.delegate = delegate;
    }

    @Override
    public void consumeAction(Action action, boolean isMany) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("consumeAction(type = " + action.getType().getClassifier().getName() + ", feature = " + action.getFeature() + ", isMany = " + isMany + ")"));
        }
        this.delegate.consumeAction(action, isMany);
    }

    @Override
    public int consumeKeyword(Keyword keyword, String feature, boolean isMany, boolean isBoolean, ICharacterClass notFollowedBy, boolean optional) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("consumeKeyword(keyword = '" + keyword.getValue() + "', " + "feature = " + feature + ", " + "isMany = " + isMany + ", " + "isBoolean = " + isBoolean + ", " + "notFollowedBy = " + notFollowedBy + ", " + "optional = " + optional + ")"));
        }
        int result = this.delegate.consumeKeyword(keyword, feature, isMany, isBoolean, notFollowedBy, optional);
        if (log.isDebugEnabled()) {
            log.debug((Object)("consumeKeyword('" + keyword.getValue() + "') = " + result));
        }
        return result;
    }

    @Override
    public int consumeNonTerminal(INonTerminalConsumer consumer, String feature, boolean isMany, boolean isDatatype, boolean isBoolean, AbstractElement grammarElement, boolean optional) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("consumeNonTerminal(consumer = '" + consumer + "', " + "feature = " + feature + ", " + "isMany = " + isMany + ", " + "isDatatype = " + isDatatype + ", " + "isBoolean = " + isBoolean + ", " + "grammarElement = " + grammarElement.eClass().getName() + ", " + "optional = " + optional + ")"));
        }
        int result = this.delegate.consumeNonTerminal(consumer, feature, isMany, isDatatype, isBoolean, grammarElement, optional);
        if (log.isDebugEnabled()) {
            log.debug((Object)("consumeNonTerminal(" + consumer + ") = " + result));
        }
        return result;
    }

    @Override
    public int consumeTerminal(ITerminalConsumer consumer, String feature, boolean isMany, boolean isBoolean, AbstractElement grammarElement, ISequenceMatcher notMatching, boolean optional) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("consumeTerminal(consumer = '" + consumer + "', " + "feature = " + feature + ", " + "isMany = " + isMany + ", " + "isBoolean = " + isBoolean + ", " + "grammarElement = " + grammarElement.eClass().getName() + ", " + "notMatching = " + notMatching + ", " + "optional = " + optional + ")"));
        }
        int result = this.delegate.consumeTerminal(consumer, feature, isMany, isBoolean, grammarElement, notMatching, optional);
        if (log.isDebugEnabled()) {
            log.debug((Object)("consumeTerminal(" + consumer + ") = " + result));
        }
        return result;
    }

    @Override
    public int consumeEnum(EnumLiteralDeclaration literal, ICharacterClass notFollowedBy) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("consumeEnum(enum = '" + literal.getEnumLiteral().getName() + "', " + "literal = " + literal.getLiteral() + ")"));
        }
        int result = this.delegate.consumeEnum(literal, notFollowedBy);
        if (log.isDebugEnabled()) {
            log.debug((Object)("consumeKeyword('" + literal.getLiteral() + "') = " + result));
        }
        return result;
    }
}

