/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.diagnostic;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.SerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.BacktrackingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaToProduction;
import org.eclipse.xtext.util.formallang.ProductionFactory;
import org.eclipse.xtext.util.formallang.ProductionStringFactory;

public class SequencerDiagnosticProvider
implements ISemanticSequencerDiagnosticProvider {
    @Inject
    protected Context2NameFunction context2Name;
    @Inject
    protected IGrammarAccess grammarAccess;
    @Inject
    protected IGrammarConstraintProvider grammarConstraints;
    @Inject
    protected IContextFinder contextFinder;

    @Override
    public ISerializationDiagnostic createFeatureValueMissing(EObject semanticObject, EStructuralFeature feature) {
        String msg = "A value for feature '" + feature.getName() + "' is missing but required.";
        return new SerializationDiagnostic("feature value missing", semanticObject, this.grammarAccess.getGrammar(), msg);
    }

    @Override
    public ISerializationDiagnostic createInvalidContextOrTypeDiagnostic(EObject semanticObject, EObject context) {
        HashSet contexts = Sets.newHashSet(this.contextFinder.findContextsByContentsAndContainer(semanticObject, null));
        List<EClass> validTypes = this.getValidTypes(context);
        ArrayList recommendedCtxs = Lists.newArrayList();
        ArrayList otherValidCtxs = Lists.newArrayList();
        for (EObject ctx : this.getValidContexts(semanticObject.eClass())) {
            if (contexts.contains(ctx)) {
                recommendedCtxs.add(ctx);
                continue;
            }
            otherValidCtxs.add(ctx);
        }
        String contextName = this.context2Name.getContextName(this.grammarAccess.getGrammar(), context);
        String semanticType = semanticObject.eClass().getName();
        String recommendCtxNames = Joiner.on((String)", ").join(Iterables.transform((Iterable)recommendedCtxs, this.context2Name.toFunction(this.grammarAccess.getGrammar())));
        String validTypeNames = Joiner.on((String)", ").join(Iterables.transform(validTypes, (Function)new NamedElement2Name()));
        StringBuilder msg = new StringBuilder();
        msg.append("The context '" + contextName + "' is not valid for type '" + semanticType + "'\n");
        msg.append("Recommended contexts for type '" + semanticType + "': " + recommendCtxNames + "\n");
        if (!otherValidCtxs.isEmpty()) {
            msg.append("Other valid contexts for type '" + semanticType + "': " + Joiner.on((String)", ").join(Iterables.transform((Iterable)otherValidCtxs, this.context2Name.toFunction(this.grammarAccess.getGrammar()))));
        }
        msg.append("The context '" + contextName + "' is valid for types: " + validTypeNames + "\n");
        return new SerializationDiagnostic("invalid context or type", semanticObject, this.grammarAccess.getGrammar(), msg.toString());
    }

    protected List<EObject> getValidContexts(EClass clazz) {
        ArrayList result = Lists.newArrayList();
        List<IGrammarConstraintProvider.IConstraintContext> constraints = this.grammarConstraints.getConstraints(this.grammarAccess.getGrammar());
        for (IGrammarConstraintProvider.IConstraintContext ctx : constraints) {
            for (IGrammarConstraintProvider.IConstraint c : ctx.getConstraints()) {
                if (c.getType() != clazz) continue;
                result.add(ctx.getContext());
            }
        }
        return result;
    }

    protected List<EClass> getValidTypes(EObject context) {
        List<IGrammarConstraintProvider.IConstraintContext> constraints = this.grammarConstraints.getConstraints(this.grammarAccess.getGrammar());
        for (IGrammarConstraintProvider.IConstraintContext ctx : constraints) {
            if (ctx.getContext() != context) continue;
            ArrayList result = Lists.newArrayList();
            for (IGrammarConstraintProvider.IConstraint c : ctx.getConstraints()) {
                result.add(c.getType());
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public ISerializationDiagnostic createBacktrackingFailedDiagnostic(BacktrackingSemanticSequencer.SerializableObject semanticObject, EObject context, Nfa<ISemanticSequencerNfaProvider.ISemState> nfa) {
        GrammarElementTitleSwitch ele2str = new GrammarElementTitleSwitch().showAssignments().setValueForNull(null);
        ProductionStringFactory grammarFactory = new ProductionStringFactory((Function)ele2str);
        String grammar = (String)new NfaToProduction().nfaToGrammar(nfa, (Function)new GetGrammarEle(), (ProductionFactory)grammarFactory);
        StringBuilder msg = new StringBuilder();
        msg.append("Could not serialize EObject via backtracking.\n");
        msg.append("Constraint: " + grammar + "\n");
        msg.append(semanticObject.getValuesString());
        return new SerializationDiagnostic("backtracking failed", semanticObject.getEObject(), context, this.grammarAccess.getGrammar(), msg.toString());
    }

    private final class GetGrammarEle
    implements Function<ISemanticSequencerNfaProvider.ISemState, AbstractElement> {
        private GetGrammarEle() {
        }

        public AbstractElement apply(ISemanticSequencerNfaProvider.ISemState from) {
            return from.getAssignedGrammarElement();
        }
    }

    public static class NamedElement2Name
    implements Function<ENamedElement, String> {
        public String apply(ENamedElement from) {
            return from == null ? "null" : from.getName();
        }
    }
}

