/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.diagnostic;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.util.EmfFormatter;

public interface ISerializationDiagnostic {
    public static final String EXCEPTION_DIAGNOSTIC = "exception diagnostic";
    public static final Acceptor EXCEPTION_THROWING_ACCEPTOR = new ExceptionThrowingAcceptor();
    public static final Acceptor STDERR_ACCEPTOR = new StdErrAcceptor();

    public boolean breaksSyntax();

    public Throwable getException();

    public String getMessage();

    public EObject getSemanticObject();

    public EObject getContext();

    public Grammar getGrammar();

    public String getId();

    public EStructuralFeature getEStructuralFeature();

    public static interface Acceptor {
        public void accept(ISerializationDiagnostic var1);
    }

    public static class ExceptionDiagnostic
    implements ISerializationDiagnostic {
        protected Throwable exception;
        protected Grammar grammar;

        public ExceptionDiagnostic(Grammar grammar, Throwable exception) {
            this.exception = exception;
            this.grammar = grammar;
        }

        @Override
        public boolean breaksSyntax() {
            return false;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }

        @Override
        public String getMessage() {
            return this.exception.getMessage();
        }

        @Override
        public EObject getSemanticObject() {
            return null;
        }

        @Override
        public EObject getContext() {
            return null;
        }

        @Override
        public Grammar getGrammar() {
            return this.grammar;
        }

        @Override
        public String getId() {
            return ISerializationDiagnostic.EXCEPTION_DIAGNOSTIC;
        }

        @Override
        public EStructuralFeature getEStructuralFeature() {
            return null;
        }
    }

    public static class ExceptionThrowingAcceptor
    implements Acceptor {
        @Override
        public void accept(ISerializationDiagnostic diagnostic) {
            if (diagnostic == null) {
                throw new RuntimeException("Something went wrong during serialization");
            }
            String msg = new ToString().toString(diagnostic);
            Throwable exception = diagnostic.getException();
            if (exception != null) {
                throw new RuntimeException(msg, exception);
            }
            throw new RuntimeException(msg);
        }
    }

    public static class StdErrAcceptor
    implements Acceptor {
        @Override
        public void accept(ISerializationDiagnostic diagnostic) {
            if (diagnostic == null || diagnostic.getMessage() == null) {
                System.err.println("error");
            } else {
                System.err.println("error " + diagnostic.getMessage());
            }
        }
    }

    public static class ToString {
        public String toString(ISerializationDiagnostic diagnostic) {
            ArrayList result = Lists.newArrayList();
            String msg = diagnostic.getMessage();
            EObject eObject = diagnostic.getSemanticObject();
            Throwable exception = diagnostic.getException();
            if (!Strings.isNullOrEmpty((String)msg)) {
                result.add(msg);
            }
            if (exception != null && exception.getMessage() != null && !exception.getMessage().equals(msg)) {
                result.add("Caused By: " + exception.getClass().getName() + ": " + exception.getMessage());
            }
            if (eObject != null) {
                result.add("Semantic Object: " + EmfFormatter.objPath((EObject)eObject));
                if (eObject.eResource() != null && eObject.eResource().getURI() != null) {
                    result.add("URI: " + eObject.eResource().getURI());
                }
            }
            if (diagnostic.getContext() != null) {
                result.add("Context: " + new Context2NameFunction().getContextName(diagnostic.getGrammar(), diagnostic.getContext()));
            }
            if (diagnostic.getEStructuralFeature() != null) {
                EStructuralFeature feature = diagnostic.getEStructuralFeature();
                EClass eClass = feature.getEContainingClass();
                String nsPrefix = eClass.getEPackage().getNsPrefix();
                result.add("EStructuralFeature: " + nsPrefix + "::" + eClass.getName() + "." + feature.getName());
            }
            return Joiner.on((String)"\n").join((Iterable)result);
        }
    }
}

