/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.IGenerator2;

public class GeneratorDelegate
implements IGenerator,
IGenerator2 {
    @Inject(optional=true)
    private IGenerator legacyGenerator;
    @Inject(optional=true)
    private IGenerator2 generator;

    public IGenerator getLegacyGenerator() {
        return this.legacyGenerator;
    }

    @Override
    public void doGenerate(Resource input, IFileSystemAccess2 fsa) {
        if (this.generator != null) {
            this.generator.doGenerate(input, fsa);
        } else if (this.getLegacyGenerator() != null) {
            this.getLegacyGenerator().doGenerate(input, fsa);
        }
    }

    @Override
    public void beforeGenerate(Resource input, IFileSystemAccess2 fsa) {
        if (this.generator != null) {
            this.generator.beforeGenerate(input, fsa);
        }
    }

    @Override
    public void afterGenerate(Resource input, IFileSystemAccess2 fsa) {
        if (this.generator != null) {
            this.generator.afterGenerate(input, fsa);
        }
    }

    public void generate(Resource input, IFileSystemAccess2 fsa) {
        try {
            this.beforeGenerate(input, fsa);
            this.doGenerate(input, fsa);
        }
        finally {
            this.afterGenerate(input, fsa);
        }
    }

    @Override
    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        IFileSystemAccess2 casted = (IFileSystemAccess2)fsa;
        try {
            this.beforeGenerate(input, casted);
            this.doGenerate(input, casted);
        }
        finally {
            this.afterGenerate(input, casted);
        }
    }
}

