/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.workspace;

import com.google.common.base.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.FileSourceFolder;
import org.eclipse.xtext.workspace.FileWorkspaceConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@FinalFieldsConstructor
public class FileProjectConfig
implements IProjectConfig {
    private final FileWorkspaceConfig parent;
    private final String name;
    private final Set<FileSourceFolder> sourceFolders = CollectionLiterals.newHashSet((Object[])new FileSourceFolder[0]);

    public FileSourceFolder addSourceFolder(String relativePath) {
        FileSourceFolder _xblockexpression = null;
        FileSourceFolder sourceFolder = new FileSourceFolder(this, relativePath);
        this.sourceFolders.add(sourceFolder);
        _xblockexpression = sourceFolder;
        return _xblockexpression;
    }

    @Override
    public FileSourceFolder findSourceFolderContaining(final URI member) {
        Functions.Function1<FileSourceFolder, Boolean> _function = new Functions.Function1<FileSourceFolder, Boolean>(){

            public Boolean apply(FileSourceFolder source) {
                URI _path = source.getPath();
                return UriUtil.isPrefixOf((URI)_path, (URI)member);
            }
        };
        return (FileSourceFolder)IterableExtensions.findFirst(this.sourceFolders, (Functions.Function1)_function);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getPath() {
        URI _createFileURI = URI.createFileURI((String)this.name);
        URI _path = this.parent.getPath();
        URI _resolve = _createFileURI.resolve(_path);
        return _resolve.appendSegment("");
    }

    public Set<FileSourceFolder> getSourceFolders() {
        return this.sourceFolders;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileProjectConfig) {
            URI _path = this.getPath();
            URI _path_1 = ((FileProjectConfig)obj).getPath();
            return Objects.equal((Object)_path, (Object)_path_1);
        }
        return false;
    }

    public int hashCode() {
        URI _path = this.getPath();
        return _path.hashCode();
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Project ");
        _builder.append((Object)this.name, "");
        _builder.append((Object)" (");
        URI _path = this.getPath();
        _builder.append((Object)_path, "");
        _builder.append((Object)")");
        return _builder.toString();
    }

    public FileProjectConfig(FileWorkspaceConfig parent, String name) {
        this.parent = parent;
        this.name = name;
    }
}

