/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.IContextProvider;
import org.eclipse.xtext.serializer.analysis.IContextTypePDAProvider;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.SerializerPDA;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaFactory;
import org.eclipse.xtext.util.formallang.PdaUtil;
import org.eclipse.xtext.util.formallang.Traverser;

@Singleton
public class ContextTypePDAProvider
implements IContextTypePDAProvider {
    protected Map<Pair<EObject, EClass>, Pda<ISerState, RuleCall>> cache = Maps.newHashMap();
    @Inject
    protected IContextProvider contextProvider;
    @Inject
    protected IContextPDAProvider pdaProvider;

    protected Pda<ISerState, RuleCall> createPDA(EObject context, EClass type) {
        Pda contextPda = this.pdaProvider.getContextPDA(context);
        Pda contextTypePda = null;
        if (this.contextProvider.getTypesForContext(context).size() > 1) {
            TypeFilter typeFilter = this.newTypeFilter(type);
            SerializerPDA.SerializerPDACloneFactory factory = new SerializerPDA.SerializerPDACloneFactory();
            contextTypePda = new PdaUtil().filterEdges(contextPda, (Traverser)typeFilter, (PdaFactory)factory);
        } else {
            contextTypePda = contextPda;
        }
        return contextTypePda;
    }

    @Override
    public Pda<ISerState, RuleCall> getContextTypePDA(EObject context, EClass type) {
        Pair key = Tuples.create((Object)context, (Object)type);
        Pda<ISerState, RuleCall> result = this.cache.get(key);
        if (result == null) {
            result = this.createPDA(context, type);
            this.cache.put((Pair<EObject, EClass>)key, result);
        }
        return result;
    }

    protected TypeFilter newTypeFilter(EClass type) {
        return new TypeFilter(type);
    }

    protected static class FilterState {
        protected final FilterState previous;
        protected final StackItem stack;
        protected final ISerState state;
        protected final EClass type;

        public FilterState(FilterState previous, EClass type, StackItem stack, ISerState state) {
            this.previous = previous;
            this.type = type;
            this.stack = stack;
            this.state = state;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FilterState other = (FilterState)obj;
            if (this.type != other.type || this.state != other.state) {
                return false;
            }
            if (this.stack == null) {
                return other.stack == null;
            }
            return this.stack.equals(other.stack);
        }

        public int hashCode() {
            int r = this.state.getType().hashCode();
            if (this.state.getGrammarElement() != null) {
                r *= this.state.getGrammarElement().hashCode();
            }
            if (this.type != null) {
                r *= this.type.hashCode() * 7;
            }
            if (this.stack != null) {
                r *= this.stack.rc.hashCode() * 13;
            }
            return r;
        }
    }

    protected static class StackItem {
        protected final StackItem parent;
        protected final RuleCall rc;

        public StackItem(StackItem parent, RuleCall rc) {
            this.parent = parent;
            this.rc = rc;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StackItem current1 = this;
            StackItem current2 = (StackItem)obj;
            int count = 0;
            while (current1 != null || current2 != null) {
                if (current1 == null || current2 == null) {
                    return false;
                }
                if (current1.rc != current2.rc) {
                    return false;
                }
                if (current1 != this && current1.rc == this.rc) {
                    ++count;
                }
                if (count > 0) {
                    return true;
                }
                current1 = current1.parent;
                current2 = current2.parent;
            }
            return true;
        }

        public int hashCode() {
            return this.rc.hashCode();
        }
    }

    protected static class TypeFilter
    implements Traverser<Pda<ISerState, RuleCall>, ISerState, FilterState> {
        protected final EClass type;

        public TypeFilter(EClass type) {
            this.type = type;
        }

        public FilterState enter(Pda<ISerState, RuleCall> pda, ISerState state, FilterState previous) {
            switch (state.getType()) {
                case ELEMENT: {
                    if (previous.type == null) {
                        Assignment ass = GrammarUtil.containingAssignment(state.getGrammarElement());
                        if (ass != null) {
                            EClassifier cls;
                            TypeRef returnType = GrammarUtil.containingRule(ass).getType();
                            EClassifier eClassifier = cls = returnType != null ? returnType.getClassifier() : null;
                            if (cls == this.type) {
                                return new FilterState(previous, this.type, previous.stack, state);
                            }
                            return null;
                        }
                        if (state.getGrammarElement() instanceof Action) {
                            EClassifier cls = ((Action)state.getGrammarElement()).getType().getClassifier();
                            if (cls == this.type) {
                                return new FilterState(previous, this.type, previous.stack, state);
                            }
                            return null;
                        }
                    } else if (state.getGrammarElement() instanceof Action) {
                        return null;
                    }
                    return new FilterState(previous, previous.type, previous.stack, state);
                }
                case POP: {
                    if (previous.stack != null && state.getGrammarElement() == previous.stack.rc) {
                        return new FilterState(previous, previous.type, previous.stack.parent, state);
                    }
                    return null;
                }
                case PUSH: {
                    RuleCall rc = (RuleCall)state.getGrammarElement();
                    return new FilterState(previous, previous.type, new StackItem(previous.stack, rc), state);
                }
                case START: {
                    return new FilterState(previous, null, null, state);
                }
                case STOP: {
                    if (previous.type == this.type && previous.stack == null) {
                        return previous;
                    }
                    return null;
                }
            }
            return null;
        }

        public boolean isSolution(FilterState result) {
            return true;
        }
    }
}

