/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfigProvider;

public class DefaultTraceURIConverter
implements ITraceURIConverter {
    @Inject(optional=true)
    private IWorkspaceConfigProvider configProvider;

    @Override
    public SourceRelativeURI getURIForTrace(IProjectConfig projectConfig, AbsoluteURI absoluteURI) {
        SourceRelativeURI result = absoluteURI.deresolve(projectConfig);
        if (result == null) {
            return this.getURIForTrace(absoluteURI.getURI());
        }
        return result;
    }

    @Override
    public SourceRelativeURI getURIForTrace(Resource resource) {
        IWorkspaceConfig workspaceConfig;
        IProjectConfig projectConfig;
        if (this.configProvider != null && (projectConfig = (workspaceConfig = this.configProvider.getWorkspaceConfig(resource.getResourceSet())).findProjectContaining(resource.getURI())) != null) {
            return this.getURIForTrace(projectConfig, new AbsoluteURI(resource.getURI()));
        }
        URI uri = resource.getURI();
        if (uri.isRelative()) {
            return new SourceRelativeURI(uri);
        }
        return this.getURIForTrace(uri);
    }

    private SourceRelativeURI getURIForTrace(URI qualifiedURI) {
        if (qualifiedURI.isPlatform()) {
            List segments = qualifiedURI.segmentsList().subList(2, qualifiedURI.segmentCount());
            return new SourceRelativeURI(URI.createHierarchicalURI((String[])segments.toArray(new String[segments.size()]), null, null));
        }
        return SourceRelativeURI.fromAbsolute(qualifiedURI);
    }
}

