/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationAdapter;

public class OutputConfigurationProvider
implements IOutputConfigurationProvider,
IContextualOutputConfigurationProvider {
    @Inject
    @Named(value="languageName")
    private String languageName;

    @Override
    public Set<OutputConfiguration> getOutputConfigurations() {
        OutputConfiguration defaultOutput = new OutputConfiguration("DEFAULT_OUTPUT");
        defaultOutput.setDescription("Output Folder");
        defaultOutput.setOutputDirectory("./src-gen");
        defaultOutput.setOverrideExistingResources(true);
        defaultOutput.setCreateOutputDirectory(true);
        defaultOutput.setCleanUpDerivedResources(true);
        defaultOutput.setSetDerivedProperty(true);
        defaultOutput.setKeepLocalHistory(true);
        return Sets.newHashSet((Object[])new OutputConfiguration[]{defaultOutput});
    }

    @Override
    public Set<OutputConfiguration> getOutputConfigurations(Resource context) {
        EList adapters = context.getResourceSet().eAdapters();
        OutputConfigurationAdapter adapter = (OutputConfigurationAdapter)EcoreUtil.getAdapter((List)adapters, OutputConfigurationAdapter.class);
        if (adapter == null) {
            return this.getOutputConfigurations();
        }
        Set<OutputConfiguration> outputConfigurations = adapter.getOutputConfigurationsPerLanguage().get(this.languageName);
        return outputConfigurations == null ? this.getOutputConfigurations() : outputConfigurations;
    }
}

