/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.workspace;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.FileProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@FinalFieldsConstructor
public class FileWorkspaceConfig
implements IWorkspaceConfig {
    private final File root;
    private final Map<String, FileProjectConfig> projects = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public FileProjectConfig addProject(String name) {
        FileProjectConfig _xblockexpression = null;
        FileProjectConfig project = new FileProjectConfig(this, name);
        String _name = project.getName();
        this.projects.put(_name, project);
        _xblockexpression = project;
        return _xblockexpression;
    }

    @Override
    public FileProjectConfig findProjectContaining(final URI member) {
        Collection<FileProjectConfig> _values = this.projects.values();
        Functions.Function1<FileProjectConfig, Boolean> _function = new Functions.Function1<FileProjectConfig, Boolean>(){

            public Boolean apply(FileProjectConfig project) {
                URI _path = project.getPath();
                return UriUtil.isPrefixOf((URI)_path, (URI)member);
            }
        };
        return (FileProjectConfig)IterableExtensions.findFirst(_values, (Functions.Function1)_function);
    }

    public URI getPath() {
        return UriUtil.createFolderURI((File)this.root);
    }

    public Set<FileProjectConfig> getProjects() {
        Collection<FileProjectConfig> _values = this.projects.values();
        return IterableExtensions.toSet(_values);
    }

    @Override
    public IProjectConfig findProjectByName(String name) {
        return this.projects.get(name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileWorkspaceConfig) {
            URI _path = this.getPath();
            URI _path_1 = ((FileWorkspaceConfig)obj).getPath();
            return Objects.equal((Object)_path, (Object)_path_1);
        }
        return false;
    }

    public int hashCode() {
        URI _path = this.getPath();
        return _path.hashCode();
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Workspace (");
        URI _path = this.getPath();
        _builder.append((Object)_path, "");
        _builder.append((Object)")");
        return _builder.toString();
    }

    public FileWorkspaceConfig(File root) {
        this.root = root;
    }
}

