/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfigProvider;

public class DefaultTraceURIConverter
implements ITraceURIConverter {
    @Inject(optional=true)
    private IWorkspaceConfigProvider configProvider;

    @Override
    public URI getURIForTrace(IProjectConfig projectConfig, URI qualifiedUri) {
        ISourceFolder sourceFolder = projectConfig.findSourceFolderContaining(qualifiedUri);
        if (sourceFolder != null) {
            return qualifiedUri.deresolve(sourceFolder.getPath());
        }
        return this.getUriForTrace(qualifiedUri);
    }

    @Override
    public URI getURIForTrace(Resource resource) {
        IWorkspaceConfig workspaceConfig;
        IProjectConfig projectConfig;
        if (this.configProvider != null && (projectConfig = (workspaceConfig = this.configProvider.getWorkspaceConfig(resource.getResourceSet())).findProjectContaining(resource.getURI())) != null) {
            return this.getURIForTrace(projectConfig, resource.getURI());
        }
        return this.getUriForTrace(resource.getURI());
    }

    private URI getUriForTrace(URI qualifiedUri) {
        if (qualifiedUri.isPlatform()) {
            List segments = qualifiedUri.segmentsList().subList(2, qualifiedUri.segmentCount());
            return URI.createHierarchicalURI((String[])segments.toArray(new String[segments.size()]), null, null);
        }
        return qualifiedUri.trimFragment().trimQuery();
    }
}

