/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.build.BuildContext;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Log
public class Indexer {
    @Inject
    private CompilerPhases compilerPhases;
    private static final Logger LOG = Logger.getLogger(Indexer.class);

    public IndexResult computeAndIndexAffected(BuildRequest request, final @Extension BuildContext context) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        IndexState _oldState = context.getOldState();
        final ResourceDescriptionsData previousIndex = _oldState.getResourceDescriptions();
        IndexState _state = request.getState();
        final ResourceDescriptionsData newIndex = _state.getResourceDescriptions();
        ArrayList deltas = CollectionLiterals.newArrayList((Object[])new IResourceDescription.Delta[0]);
        boolean _isInfoEnabled = LOG.isInfoEnabled();
        if (_isInfoEnabled) {
            List<URI> _deletedFiles = request.getDeletedFiles();
            Set _set = IterableExtensions.toSet(_deletedFiles);
            String _plus = "Creating Deltas for changes. Deleted : " + _set;
            String _plus_1 = String.valueOf(_plus) + ", Changed : ";
            List<URI> _dirtyFiles = request.getDirtyFiles();
            Set _set_1 = IterableExtensions.toSet((Iterable)_dirtyFiles);
            String _plus_2 = String.valueOf(_plus_1) + _set_1;
            String _plus_3 = String.valueOf(_plus_2) + ".";
            LOG.info((Object)_plus_3);
        }
        List<IResourceDescription.Delta> _deltasForDeletedResources = this.getDeltasForDeletedResources(request, previousIndex, context);
        deltas.addAll(_deltasForDeletedResources);
        List<URI> _dirtyFiles_1 = request.getDirtyFiles();
        List<IResourceDescription.Delta> _deltasForChangedResources = this.getDeltasForChangedResources(_dirtyFiles_1, previousIndex, context);
        deltas.addAll(_deltasForChangedResources);
        for (IResourceDescription.Delta delta : deltas) {
            newIndex.register(delta);
        }
        final HashSet<IResourceDescription.Delta> allDeltas = new HashSet<IResourceDescription.Delta>(deltas);
        List<IResourceDescription.Delta> _externalDeltas = request.getExternalDeltas();
        boolean _isEmpty = _externalDeltas.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            List<IResourceDescription.Delta> _externalDeltas_1 = request.getExternalDeltas();
            allDeltas.addAll(_externalDeltas_1);
        }
        Iterable<IResourceDescription> _allResourceDescriptions = previousIndex.getAllResourceDescriptions();
        Functions.Function1<IResourceDescription, URI> _function = new Functions.Function1<IResourceDescription, URI>(){

            public URI apply(IResourceDescription it) {
                return it.getURI();
            }
        };
        Iterable _map = IterableExtensions.map(_allResourceDescriptions, (Functions.Function1)_function);
        Set remainingURIs = IterableExtensions.toSet((Iterable)_map);
        Functions.Function1<IResourceDescription.Delta, URI> _function_1 = new Functions.Function1<IResourceDescription.Delta, URI>(){

            public URI apply(IResourceDescription.Delta it) {
                return it.getUri();
            }
        };
        List _map_1 = ListExtensions.map((List)deltas, (Functions.Function1)_function_1);
        remainingURIs.removeAll(_map_1);
        Functions.Function1<URI, Boolean> _function_2 = new Functions.Function1<URI, Boolean>(){

            public Boolean apply(URI it) {
                IResourceServiceProvider _resourceServiceProvider = context.getResourceServiceProvider(it);
                IResourceDescription.Manager manager = _resourceServiceProvider.getResourceDescriptionManager();
                IResourceDescription resourceDescription = previousIndex.getResourceDescription(it);
                boolean isAffected = Indexer.this.isAffected(resourceDescription, manager, allDeltas, allDeltas, newIndex);
                return isAffected;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)remainingURIs, (Functions.Function1)_function_2);
        List allAffected = IterableExtensions.toList((Iterable)_filter);
        boolean _and = false;
        boolean _isInfoEnabled_1 = LOG.isInfoEnabled();
        _and = !_isInfoEnabled_1 ? false : (_not_1 = !(_isEmpty_1 = allAffected.isEmpty()));
        if (_and) {
            Set _set_2 = IterableExtensions.toSet((Iterable)allAffected);
            String _plus_4 = "Creating Deltas for affected resources : " + _set_2;
            String _plus_5 = String.valueOf(_plus_4) + ".";
            LOG.info((Object)_plus_5);
        }
        List<IResourceDescription.Delta> _deltasForChangedResources_1 = this.getDeltasForChangedResources(allAffected, previousIndex, context);
        deltas.addAll(_deltasForChangedResources_1);
        return new IndexResult(deltas, newIndex);
    }

    protected List<IResourceDescription.Delta> getDeltasForDeletedResources(BuildRequest request, final ResourceDescriptionsData oldIndex, final @Extension BuildContext context) {
        final ArrayList deltas = CollectionLiterals.newArrayList((Object[])new IResourceDescription.Delta[0]);
        List<URI> _deletedFiles = request.getDeletedFiles();
        Functions.Function1<URI, Boolean> _function = new Functions.Function1<URI, Boolean>(){

            public Boolean apply(URI it) {
                IResourceServiceProvider _resourceServiceProvider = context.getResourceServiceProvider(it);
                return !Objects.equal((Object)_resourceServiceProvider, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(_deletedFiles, (Functions.Function1)_function);
        Procedures.Procedure1<URI> _function_1 = new Procedures.Procedure1<URI>(){

            public void apply(URI it) {
                IResourceDescription oldDescription;
                boolean _notEquals;
                IResourceDescription _resourceDescription = null;
                if (oldIndex != null) {
                    _resourceDescription = oldIndex.getResourceDescription(it);
                }
                boolean bl = _notEquals = !Objects.equal((Object)(oldDescription = _resourceDescription), null);
                if (_notEquals) {
                    DefaultResourceDescriptionDelta delta = new DefaultResourceDescriptionDelta(oldDescription, null);
                    deltas.add(delta);
                }
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
        return deltas;
    }

    protected List<IResourceDescription.Delta> getDeltasForChangedResources(Iterable<URI> affectedUris, final ResourceDescriptionsData oldIndex, final @Extension BuildContext context) {
        try {
            XtextResourceSet _resourceSet = context.getResourceSet();
            this.compilerPhases.setIndexing((Notifier)_resourceSet, true);
            Functions.Function1<Resource, IResourceDescription.Delta> _function = new Functions.Function1<Resource, IResourceDescription.Delta>(){

                public IResourceDescription.Delta apply(Resource it) {
                    return Indexer.this.addToIndex(it, true, oldIndex, context);
                }
            };
            Iterable<IResourceDescription.Delta> _executeClustered = context.executeClustered(affectedUris, _function);
            List list = IterableExtensions.toList(_executeClustered);
            return list;
        }
        finally {
            XtextResourceSet _resourceSet_1 = context.getResourceSet();
            this.compilerPhases.setIndexing((Notifier)_resourceSet_1, false);
        }
    }

    protected IResourceDescription.Delta addToIndex(Resource resource, boolean isPreIndexing, ResourceDescriptionsData oldIndex, BuildContext context) {
        URI uri = resource.getURI();
        IResourceServiceProvider serviceProvider = context.getResourceServiceProvider(uri);
        IResourceDescription.Manager manager = serviceProvider.getResourceDescriptionManager();
        IResourceDescription newDescription = manager.getResourceDescription(resource);
        ResolvedResourceDescription toBeAdded = new ResolvedResourceDescription(newDescription);
        IResourceDescription _resourceDescription = null;
        if (oldIndex != null) {
            _resourceDescription = oldIndex.getResourceDescription(uri);
        }
        IResourceDescription.Delta delta = manager.createDelta(_resourceDescription, toBeAdded);
        return delta;
    }

    protected boolean isAffected(IResourceDescription affectionCandidate, IResourceDescription.Manager manager, Collection<IResourceDescription.Delta> newDeltas, Collection<IResourceDescription.Delta> allDeltas, IResourceDescriptions resourceDescriptions) {
        if (manager instanceof IResourceDescription.Manager.AllChangeAware) {
            return ((IResourceDescription.Manager.AllChangeAware)manager).isAffectedByAny(allDeltas, affectionCandidate, resourceDescriptions);
        }
        boolean _isEmpty = newDeltas.isEmpty();
        if (_isEmpty) {
            return false;
        }
        return manager.isAffected(newDeltas, affectionCandidate, resourceDescriptions);
    }

    @Data
    public static class IndexResult {
        private final List<IResourceDescription.Delta> resourceDeltas;
        private final ResourceDescriptionsData newIndex;

        public IndexResult(List<IResourceDescription.Delta> resourceDeltas, ResourceDescriptionsData newIndex) {
            this.resourceDeltas = resourceDeltas;
            this.newIndex = newIndex;
        }

        @Pure
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.resourceDeltas == null ? 0 : this.resourceDeltas.hashCode());
            result = 31 * result + (this.newIndex == null ? 0 : this.newIndex.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexResult other = (IndexResult)obj;
            if (this.resourceDeltas == null ? other.resourceDeltas != null : !this.resourceDeltas.equals(other.resourceDeltas)) {
                return false;
            }
            return !(this.newIndex == null ? other.newIndex != null : !this.newIndex.equals(other.newIndex));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("resourceDeltas", this.resourceDeltas);
            b.add("newIndex", (Object)this.newIndex);
            return b.toString();
        }

        @Pure
        public List<IResourceDescription.Delta> getResourceDeltas() {
            return this.resourceDeltas;
        }

        @Pure
        public ResourceDescriptionsData getNewIndex() {
            return this.newIndex;
        }
    }

    @Log
    protected static class ResolvedResourceDescription
    extends AbstractResourceDescription {
        @Accessors(value={AccessorType.PUBLIC_GETTER})
        private URI URI;
        private ImmutableList<IEObjectDescription> exported;
        private static final Logger LOG = Logger.getLogger(ResolvedResourceDescription.class);

        public ResolvedResourceDescription(IResourceDescription original) {
            ImmutableList _copyOf;
            URI _uRI;
            this.URI = _uRI = original.getURI();
            Iterable<IEObjectDescription> _exportedObjects = original.getExportedObjects();
            Functions.Function1<IEObjectDescription, IEObjectDescription> _function = new Functions.Function1<IEObjectDescription, IEObjectDescription>(){

                public IEObjectDescription apply(IEObjectDescription from) {
                    String[] _userDataKeys;
                    EObject _eObjectOrProxy = from.getEObjectOrProxy();
                    boolean _eIsProxy = _eObjectOrProxy.eIsProxy();
                    if (_eIsProxy) {
                        return from;
                    }
                    EClass _eClass = from.getEClass();
                    EObject _create = EcoreUtil.create((EClass)_eClass);
                    InternalEObject result = (InternalEObject)_create;
                    URI _eObjectURI = from.getEObjectURI();
                    result.eSetProxyURI(_eObjectURI);
                    HashMap userData = null;
                    String[] stringArray = _userDataKeys = from.getUserDataKeys();
                    int n = _userDataKeys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        boolean _equals = Objects.equal(userData, null);
                        if (_equals) {
                            HashMap _newHashMapWithExpectedSize;
                            userData = _newHashMapWithExpectedSize = Maps.newHashMapWithExpectedSize((int)2);
                        }
                        String _userData = from.getUserData(key);
                        userData.put(key, _userData);
                        ++n2;
                    }
                    QualifiedName _name = from.getName();
                    return EObjectDescription.create(_name, (EObject)result, userData);
                }
            };
            Iterable _map = IterableExtensions.map(_exportedObjects, (Functions.Function1)_function);
            this.exported = _copyOf = ImmutableList.copyOf((Iterable)_map);
        }

        @Override
        protected List<IEObjectDescription> computeExportedObjects() {
            return this.exported;
        }

        @Override
        public Iterable<QualifiedName> getImportedNames() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"getImportedNames ");
            _builder.append((Object)this.URI, "");
            IllegalStateException exception = new IllegalStateException(_builder.toString());
            LOG.error((Object)exception, (Throwable)exception);
            return CollectionLiterals.emptyList();
        }

        @Override
        public Iterable<IReferenceDescription> getReferenceDescriptions() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"getReferenceDescriptions ");
            _builder.append((Object)this.URI, "");
            IllegalStateException exception = new IllegalStateException(_builder.toString());
            LOG.error((Object)exception, (Throwable)exception);
            return CollectionLiterals.emptyList();
        }

        @Override
        @Pure
        public URI getURI() {
            return this.URI;
        }
    }
}

