/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.base.Objects;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class BuildRequest {
    private URI baseDir;
    private List<URI> dirtyFiles = CollectionLiterals.newArrayList((Object[])new URI[0]);
    private List<URI> deletedFiles = CollectionLiterals.newArrayList((Object[])new URI[0]);
    private List<IResourceDescription.Delta> externalDeltas = CollectionLiterals.newArrayList((Object[])new IResourceDescription.Delta[0]);
    private IPostValidationCallback afterValidate = new DefaultValidationCallback();
    private Procedures.Procedure2<? super URI, ? super URI> afterGenerateFile = new Procedures.Procedure2<URI, URI>(){

        public void apply(URI $0, URI $1) {
        }
    };
    private Procedures.Procedure1<? super URI> afterDeleteFile = new Procedures.Procedure1<URI>(){

        public void apply(URI it) {
        }
    };
    private IndexState state = new IndexState();
    private boolean writeStorageResources = false;
    private boolean indexOnly = false;
    private XtextResourceSet resourceSet;

    public URI getBaseDir() {
        boolean _equals = Objects.equal((Object)this.baseDir, null);
        if (_equals) {
            URI _createFolderURI;
            String userDir = System.getProperty("user.dir");
            File _file = new File(userDir);
            this.baseDir = _createFolderURI = UriUtil.createFolderURI((File)_file);
        }
        return this.baseDir;
    }

    public void setBaseDir(URI baseDir) {
        this.baseDir = baseDir;
    }

    @Pure
    public List<URI> getDirtyFiles() {
        return this.dirtyFiles;
    }

    public void setDirtyFiles(List<URI> dirtyFiles) {
        this.dirtyFiles = dirtyFiles;
    }

    @Pure
    public List<URI> getDeletedFiles() {
        return this.deletedFiles;
    }

    public void setDeletedFiles(List<URI> deletedFiles) {
        this.deletedFiles = deletedFiles;
    }

    @Pure
    public List<IResourceDescription.Delta> getExternalDeltas() {
        return this.externalDeltas;
    }

    public void setExternalDeltas(List<IResourceDescription.Delta> externalDeltas) {
        this.externalDeltas = externalDeltas;
    }

    @Pure
    public IPostValidationCallback getAfterValidate() {
        return this.afterValidate;
    }

    public void setAfterValidate(IPostValidationCallback afterValidate) {
        this.afterValidate = afterValidate;
    }

    @Pure
    public Procedures.Procedure2<? super URI, ? super URI> getAfterGenerateFile() {
        return this.afterGenerateFile;
    }

    public void setAfterGenerateFile(Procedures.Procedure2<? super URI, ? super URI> afterGenerateFile) {
        this.afterGenerateFile = afterGenerateFile;
    }

    @Pure
    public Procedures.Procedure1<? super URI> getAfterDeleteFile() {
        return this.afterDeleteFile;
    }

    public void setAfterDeleteFile(Procedures.Procedure1<? super URI> afterDeleteFile) {
        this.afterDeleteFile = afterDeleteFile;
    }

    @Pure
    public IndexState getState() {
        return this.state;
    }

    public void setState(IndexState state) {
        this.state = state;
    }

    @Pure
    public boolean isWriteStorageResources() {
        return this.writeStorageResources;
    }

    public void setWriteStorageResources(boolean writeStorageResources) {
        this.writeStorageResources = writeStorageResources;
    }

    @Pure
    public boolean isIndexOnly() {
        return this.indexOnly;
    }

    public void setIndexOnly(boolean indexOnly) {
        this.indexOnly = indexOnly;
    }

    @Pure
    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setResourceSet(XtextResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    @Log
    private static class DefaultValidationCallback
    implements IPostValidationCallback {
        private static final Logger LOG = Logger.getLogger(DefaultValidationCallback.class);

        private DefaultValidationCallback() {
        }

        @Override
        public boolean afterValidate(URI validated, Iterable<Issue> issues) {
            boolean errorFree = true;
            for (Issue issue : issues) {
                Severity _severity = issue.getSeverity();
                if (_severity == null) continue;
                switch (_severity) {
                    case ERROR: {
                        String _string = issue.toString();
                        LOG.error((Object)_string);
                        errorFree = false;
                        break;
                    }
                    case WARNING: {
                        String _string_1 = issue.toString();
                        LOG.warn((Object)_string_1);
                        break;
                    }
                    case INFO: {
                        String _string_2 = issue.toString();
                        LOG.info((Object)_string_2);
                        break;
                    }
                    case IGNORE: {
                        String _string_3 = issue.toString();
                        LOG.debug((Object)_string_3);
                        break;
                    }
                }
            }
            return errorFree;
        }
    }

    public static interface IPostValidationCallback {
        public boolean afterValidate(URI var1, Iterable<Issue> var2);
    }
}

