/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.diagnostics;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.diagnostics.Diagnostic;
import org.eclipse.xtext.nodemodel.INode;

public abstract class AbstractDiagnostic
implements Diagnostic {
    protected abstract INode getNode();

    public abstract String getCode();

    public abstract String[] getData();

    @Override
    public int getLength() {
        INode node = this.getNode();
        if (node != null) {
            return node.getLength();
        }
        return 1;
    }

    @Override
    public int getOffset() {
        INode node = this.getNode();
        if (node != null) {
            return node.getOffset();
        }
        return 0;
    }

    public int getColumn() {
        return 0;
    }

    public int getLine() {
        INode node = this.getNode();
        if (node != null) {
            return node.getStartLine();
        }
        return -1;
    }

    public String getLocation() {
        return null;
    }

    public URI getUriToProblem() {
        INode node = this.getNode();
        if (node == null) {
            return null;
        }
        EObject eObject = node.getSemanticElement();
        if (eObject == null || eObject.eResource() == null) {
            return null;
        }
        return EcoreUtil.getURI((EObject)eObject);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getSimpleName());
        b.append(": ");
        b.append(this.getLocation());
        b.append(":");
        b.append(this.getLine());
        b.append(" ");
        b.append(this.getMessage());
        return b.toString();
    }
}

