/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.ClassloaderClasspathUriResolver;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;

public class EcoreUtil2
extends EcoreUtil {
    private static Logger log = Logger.getLogger(EcoreUtil2.class);
    private static final char delim = '\u00ab';
    private static Map<EReference, String> exernalFormCache = new MapMaker().weakKeys().makeMap();

    public static EObject getNextSibling(EObject eObject) {
        List siblings;
        int indexOf;
        EObject next = null;
        if (eObject.eContainingFeature() != null && eObject.eContainingFeature().isMany() && (indexOf = (siblings = (List)eObject.eContainer().eGet(eObject.eContainingFeature())).indexOf(eObject)) < siblings.size() - 1) {
            next = (EObject)siblings.get(indexOf + 1);
        }
        return next;
    }

    public static EObject getPreviousSibling(EObject eObject) {
        List siblings;
        int indexOf;
        EObject previous = null;
        if (eObject.eContainingFeature() != null && eObject.eContainingFeature().isMany() && (indexOf = (siblings = (List)eObject.eContainer().eGet(eObject.eContainingFeature())).indexOf(eObject)) > 0) {
            previous = (EObject)siblings.get(indexOf - 1);
        }
        return previous;
    }

    public static <T extends EObject> T getContainerOfType(EObject ele, Class<T> type) {
        EObject e = ele;
        while (e != null) {
            if (type.isInstance(e)) {
                return (T)((EObject)type.cast(e));
            }
            e = e.eContainer();
        }
        return null;
    }

    public static <T extends EObject> List<T> getSiblingsOfType(EObject ele, Class<T> type) {
        if (ele.eContainer() != null) {
            List<T> siblings = EcoreUtil2.typeSelect(ele.eContainer().eContents(), type);
            siblings.remove(ele);
            return siblings;
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static <T extends EObject> T clone(T eObject) {
        return (T)EcoreUtil.copy(eObject);
    }

    public static <T extends EObject> T cloneWithProxies(T original) {
        if (original == null) {
            return original;
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false);
        EObject copy = copier.copy(original);
        copier.copyReferences();
        return (T)copy;
    }

    public static <T extends EObject> T cloneIfContained(T eObject) {
        if (eObject != null && (eObject.eContainer() != null || eObject.eResource() != null)) {
            return EcoreUtil2.clone(eObject);
        }
        return eObject;
    }

    public static <T extends ResourceSet> T clone(T target, ResourceSet source) {
        EList resources = source.getResources();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        for (Resource resource : resources) {
            Resource resource2 = target.createResource(resource.getURI());
            resource2.getContents().addAll(copier.copyAll((Collection)resource.getContents()));
        }
        copier.copyReferences();
        return target;
    }

    public static <T extends EObject> List<T> getAllContentsOfType(EObject ele, Class<T> type) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator allContents = ele.eAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            if (!type.isAssignableFrom(object.getClass())) continue;
            result.add(object);
        }
        return result;
    }

    public static <T> List<T> typeSelect(List<?> elements, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object ele : elements) {
            if (ele == null || !clazz.isAssignableFrom(ele.getClass())) continue;
            result.add(clazz.cast(ele));
        }
        return result;
    }

    public static <T> List<T> collect(Collection<? extends EObject> instances, int featureId, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>(instances.size());
        for (EObject eObject : instances) {
            if (eObject == null) {
                throw new NullPointerException("obj may not be null");
            }
            EStructuralFeature feature = eObject.eClass().getEStructuralFeature(featureId);
            if (feature == null) {
                throw new NullPointerException("feature may not be null");
            }
            Object object = eObject.eGet(feature);
            if (object == null) continue;
            result.add(type.cast(object));
        }
        return result;
    }

    public static <T extends EObject> List<T> eAllOfType(EObject ele, Class<T> type) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (type.isAssignableFrom(ele.getClass())) {
            result.add(ele);
        }
        TreeIterator allContents = ele.eAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            if (!type.isAssignableFrom(object.getClass())) continue;
            result.add(object);
        }
        return result;
    }

    public static TreeIterator<EObject> eAll(final EObject obj) {
        return new TreeIterator<EObject>(){
            private TreeIterator<EObject> it = null;
            private int index = 0;

            public void prune() {
                switch (this.index) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.it = null;
                        break;
                    }
                    default: {
                        if (this.it == null) break;
                        this.it.prune();
                    }
                }
            }

            public boolean hasNext() {
                if (this.index == 0) {
                    return true;
                }
                if (this.it != null) {
                    return this.it.hasNext();
                }
                return false;
            }

            public EObject next() {
                if (this.index++ == 0) {
                    this.it = obj.eAllContents();
                    return obj;
                }
                if (this.it != null) {
                    return (EObject)this.it.next();
                }
                return null;
            }

            public void remove() {
                if (this.index == 0) {
                    EcoreUtil.remove((EObject)obj);
                }
                if (this.it != null) {
                    this.it.remove();
                }
            }
        };
    }

    public static Iterable<EObject> eAllContents(final EObject n) {
        return new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                return EcoreUtil2.eAll(n);
            }
        };
    }

    public static List<EObject> eAllContentsAsList(EObject ele) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator iterator = ele.eAllContents();
        while (iterator.hasNext()) {
            result.add((EObject)iterator.next());
        }
        return result;
    }

    public static List<EObject> eAllContentsAsList(Resource resource) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            result.add((EObject)iterator.next());
        }
        return result;
    }

    public static final EPackage loadEPackage(String uriAsString, ClassLoader classLoader) {
        if (EPackage.Registry.INSTANCE.containsKey((Object)uriAsString)) {
            return EPackage.Registry.INSTANCE.getEPackage(uriAsString);
        }
        URI uri = URI.createURI((String)uriAsString);
        uri = new ClassloaderClasspathUriResolver().resolve(classLoader, uri);
        Resource resource = new ResourceSetImpl().getResource(uri, true);
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!(next instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)next;
            return ePackage;
        }
        log.error((Object)("Could not load EPackage with nsURI" + uriAsString));
        return null;
    }

    public static String getURIFragment(EObject eObject) {
        Resource resource = eObject.eResource();
        String fragment = resource.getURIFragment(eObject);
        return fragment;
    }

    public static EClassifier getCompatibleType(EClassifier typeA, EClassifier typeB) {
        EClassifier result = EcoreUtil2.getCompatibleType(typeA, typeB, null);
        if (result != null) {
            return result;
        }
        if (typeA instanceof EClass && typeB instanceof EClass) {
            return EcorePackage.Literals.EOBJECT;
        }
        return null;
    }

    public static EClassifier getCompatibleType(EClassifier typeA, EClassifier typeB, EObject grammarContext) {
        if (typeA.equals(typeB)) {
            return typeA;
        }
        if (typeA instanceof EDataType && typeB instanceof EDataType) {
            Class instanceClassA = typeA.getInstanceClass();
            Class instanceClassB = typeB.getInstanceClass();
            if (instanceClassA != null && instanceClassB != null) {
                if (instanceClassA.isAssignableFrom(instanceClassB)) {
                    return typeA;
                }
                if (instanceClassB.isAssignableFrom(instanceClassA)) {
                    return typeB;
                }
            }
        }
        if (!(typeA instanceof EClass) || !(typeB instanceof EClass)) {
            return null;
        }
        List<EClass> sortedCandidates = EcoreUtil2.getSortedCommonCompatibleTypeCandidates((EClass)typeA, (EClass)typeB);
        for (EClass candidate : sortedCandidates) {
            if (!EcoreUtil2.isCommonCompatibleType(candidate, sortedCandidates)) continue;
            return candidate;
        }
        EClass result = GrammarUtil.findEObject(GrammarUtil.getGrammar(grammarContext));
        return result;
    }

    private static boolean isLooslyCompatibleWith(EClass classA, EClass classB) {
        return classA.equals(classB) || classA.getEAllSuperTypes().contains((Object)classB) || classB.getEAllSuperTypes().contains((Object)classA);
    }

    private static boolean isCommonCompatibleType(EClass candidate, List<EClass> candidates) {
        for (EClass otherCandidate : candidates) {
            if (EcoreUtil2.isLooslyCompatibleWith(candidate, otherCandidate)) continue;
            return false;
        }
        return true;
    }

    private static List<EClass> getSortedCommonCompatibleTypeCandidates(EClass classA, EClass classB) {
        List<EClass> result = EcoreUtil2.getCompatibleTypesOf(classA);
        List<EClass> compatibleTypesOfB = EcoreUtil2.getCompatibleTypesOf(classB);
        result.retainAll(compatibleTypesOfB);
        Collections.sort(result, new EClassTypeHierarchyComparator());
        return result;
    }

    public static List<EClass> getCompatibleTypesOf(EClass eClass) {
        ArrayList<EClass> ca = new ArrayList<EClass>((Collection<EClass>)eClass.getEAllSuperTypes());
        ca.add(eClass);
        return ca;
    }

    private static void collectAllSuperTypes(Set<EClass> collectedTypes, EClass eClass) {
        for (EClass superType : eClass.getESuperTypes()) {
            if (!collectedTypes.add(superType)) continue;
            EcoreUtil2.collectAllSuperTypes(collectedTypes, superType);
        }
    }

    public static Collection<EClass> getAllSuperTypes(EClass eClass) {
        HashSet<EClass> allSuperTypes = new HashSet<EClass>();
        EcoreUtil2.collectAllSuperTypes(allSuperTypes, eClass);
        return Collections.unmodifiableSet(allSuperTypes);
    }

    public static boolean isAssignableFrom(EClass superType, EClass candidate) {
        return candidate != null && (superType == EcorePackage.Literals.EOBJECT || superType.isSuperTypeOf(candidate));
    }

    public static List<EObject> getAllReferencedObjects(EObject referer, EReference reference) {
        if (reference.getUpperBound() == 1) {
            EObject eObject = (EObject)referer.eGet((EStructuralFeature)reference);
            if (eObject != null) {
                return Collections.singletonList(eObject);
            }
            return Collections.emptyList();
        }
        return (List)referer.eGet((EStructuralFeature)reference);
    }

    public static boolean isValidUri(Resource resource, URI uri) {
        URI normalized;
        URIConverter uriConverter;
        block6: {
            ResourceSet resourceSet;
            URI newURI;
            block5: {
                if (uri == null || uri.isEmpty()) {
                    return false;
                }
                newURI = EcoreUtil2.getResolvedImportUri(resource, uri);
                try {
                    resourceSet = resource.getResourceSet();
                    if (resourceSet.getResource(uri, false) == null) break block5;
                    return true;
                }
                catch (RuntimeException e) {
                    log.trace((Object)("Cannot load resource: " + newURI), (Throwable)e);
                    return false;
                }
            }
            uriConverter = resourceSet.getURIConverter();
            normalized = uriConverter.normalize(newURI);
            if (normalized == null || !"platform".equals(normalized.scheme()) || normalized.isPlatform()) break block6;
            return false;
        }
        return uriConverter.exists(normalized, Collections.emptyMap());
    }

    public static boolean isValidUri(EObject context, URI uri) {
        return EcoreUtil2.isValidUri(context.eResource(), uri);
    }

    private static URI getResolvedImportUri(Resource context, URI uri) {
        URI contextURI = context.getURI();
        if (contextURI.isHierarchical() && !contextURI.isRelative() && uri.isRelative() && !uri.isEmpty()) {
            uri = uri.resolve(contextURI);
        }
        return uri;
    }

    public static Resource getResource(Resource context, String uri) {
        URI newURI = EcoreUtil2.getResolvedImportUri(context, URI.createURI((String)uri));
        try {
            return context.getResourceSet().getResource(newURI, true);
        }
        catch (RuntimeException e) {
            log.trace((Object)("Cannot load resource: " + newURI), (Throwable)e);
            return null;
        }
    }

    public static ResourceSet getResourceSet(Notifier ctx) {
        if (ctx instanceof EObject) {
            Resource eResource = ((EObject)ctx).eResource();
            if (eResource != null) {
                return eResource.getResourceSet();
            }
        } else {
            if (ctx instanceof Resource) {
                return ((Resource)ctx).getResourceSet();
            }
            if (ctx instanceof ResourceSet) {
                return (ResourceSet)ctx;
            }
        }
        return null;
    }

    public static void resolveAll(Resource resource, CancelIndicator monitor) {
        TreeIterator i = resource.getAllContents();
        while (i.hasNext()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            EObject eObject = (EObject)i.next();
            EcoreUtil2.resolveCrossReferences(eObject, monitor);
        }
    }

    public static void resolveLazyCrossReferences(Resource resource, CancelIndicator monitor) {
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(monitor);
        } else {
            EcoreUtil2.resolveAll(resource, monitor);
        }
    }

    public static void resolveAll(EObject eObject, CancelIndicator monitor) {
        EcoreUtil2.resolveCrossReferences(eObject, monitor);
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            EObject childEObject = (EObject)i.next();
            EcoreUtil2.resolveCrossReferences(childEObject, monitor);
        }
    }

    private static void resolveCrossReferences(EObject eObject, CancelIndicator monitor) {
        Iterator i = eObject.eCrossReferences().iterator();
        while (i.hasNext()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            i.next();
        }
    }

    public static String toExternalForm(EReference ref) {
        if (ref == null) {
            return null;
        }
        String result = exernalFormCache.get(ref);
        if (result == null) {
            EClass class1 = ref.getEContainingClass();
            if (class1 == null) {
                result = EcoreUtil.getURI((EObject)ref).toString();
            } else {
                StringBuilder buff = new StringBuilder(class1.getEPackage().getNsURI());
                buff.append('\u00ab').append(class1.getName());
                buff.append('\u00ab').append(class1.getFeatureID((EStructuralFeature)ref));
                result = buff.toString();
            }
            exernalFormCache.put(ref, result);
        }
        return result;
    }

    public static EReference getEReferenceFromExternalForm(EPackage.Registry registry, String externalForm) {
        if (externalForm == null) {
            return null;
        }
        List split = Strings.split((String)externalForm, (char)'\u00ab');
        if (split.size() != 3) {
            URI uri = URI.createURI((String)externalForm);
            URI packURI = uri.trimFragment();
            EPackage ePackage = registry.getEPackage(packURI.toString());
            if (ePackage == null) {
                return null;
            }
            EReference result = (EReference)ePackage.eResource().getEObject(uri.fragment());
            return result;
        }
        EPackage ePackage = registry.getEPackage((String)split.get(0));
        if (ePackage == null) {
            return null;
        }
        EClass clazz = (EClass)ePackage.getEClassifier((String)split.get(1));
        if (clazz == null) {
            return null;
        }
        return (EReference)clazz.getEStructuralFeature(Integer.valueOf((String)split.get(2)).intValue());
    }

    public static boolean hasSameURI(EObject o0, EObject o1) {
        return EcoreUtil.getURI((EObject)o0).equals(EcoreUtil.getURI((EObject)o1));
    }

    public static URI getNormalizedResourceURI(EObject eObject) {
        if (eObject.eResource() != null) {
            return EcoreUtil2.getNormalizedURI(eObject.eResource());
        }
        return URIConverter.INSTANCE.normalize(EcoreUtil.getURI((EObject)eObject).trimFragment());
    }

    public static URI getNormalizedURI(EObject eObject) {
        URI rawURI = EcoreUtil.getURI((EObject)eObject);
        Resource resource = eObject.eResource();
        if (resource != null && resource.getResourceSet() != null) {
            return resource.getResourceSet().getURIConverter().normalize(rawURI);
        }
        return URIConverter.INSTANCE.normalize(rawURI);
    }

    public static URI getNormalizedURI(Resource resource) {
        if (resource.getResourceSet() != null) {
            return resource.getResourceSet().getURIConverter().normalize(resource.getURI());
        }
        return URIConverter.INSTANCE.normalize(resource.getURI());
    }

    public static URI getPlatformResourceOrNormalizedURI(EObject eObject) {
        URI rawURI = EcoreUtil.getURI((EObject)eObject);
        if (rawURI.isPlatformResource()) {
            return rawURI;
        }
        Resource resource = eObject.eResource();
        if (resource != null && resource.getResourceSet() != null) {
            return resource.getResourceSet().getURIConverter().normalize(rawURI);
        }
        return URIConverter.INSTANCE.normalize(rawURI);
    }

    public static URI getPlatformResourceOrNormalizedURI(Resource resource) {
        URI rawURI = resource.getURI();
        if (rawURI.isPlatformResource()) {
            return rawURI;
        }
        if (resource.getResourceSet() != null) {
            return resource.getResourceSet().getURIConverter().normalize(rawURI);
        }
        return URIConverter.INSTANCE.normalize(rawURI);
    }

    public static void findCrossReferences(EObject rootElement, Set<? extends EObject> targets, ElementReferenceAcceptor acceptor) {
        for (EReference ref : rootElement.eClass().getEAllReferences()) {
            int i;
            if (!rootElement.eIsSet((EStructuralFeature)ref)) continue;
            if (ref.isContainment()) {
                Object content = rootElement.eGet((EStructuralFeature)ref, false);
                if (ref.isMany()) {
                    InternalEList contentList = (InternalEList)content;
                    i = 0;
                    while (i < contentList.size()) {
                        EObject childElement = (EObject)contentList.basicGet(i);
                        if (!childElement.eIsProxy()) {
                            EcoreUtil2.findCrossReferences(childElement, targets, acceptor);
                        }
                        ++i;
                    }
                    continue;
                }
                EObject childElement = (EObject)content;
                if (childElement.eIsProxy()) continue;
                EcoreUtil2.findCrossReferences(childElement, targets, acceptor);
                continue;
            }
            if (ref.isContainer()) continue;
            Object value = rootElement.eGet((EStructuralFeature)ref, false);
            if (ref.isMany()) {
                InternalEList values = (InternalEList)value;
                i = 0;
                while (i < values.size()) {
                    EObject refElement = (EObject)values.get(i);
                    if (targets.contains(refElement)) {
                        acceptor.accept(rootElement, refElement, ref, i);
                    }
                    ++i;
                }
                continue;
            }
            EObject refElement = (EObject)value;
            if (!targets.contains(refElement)) continue;
            acceptor.accept(rootElement, refElement, ref, -1);
        }
    }

    public static TreeIterator<EObject> getAllNonDerivedContents(EObject root, boolean includeRoot) {
        return new AbstractTreeIterator<EObject>((Object)root, includeRoot){
            private static final long serialVersionUID = 1L;

            public Iterator<EObject> getChildren(Object object) {
                EObject eObject = (EObject)object;
                return EcoreUtil2.getNonDerivedContents(eObject);
            }
        };
    }

    public static TreeIterator<EObject> getAllNonDerivedContents(EObject root) {
        return EcoreUtil2.getAllNonDerivedContents(root, false);
    }

    public static Iterator<EObject> getNonDerivedContents(EObject eObject) {
        EClassImpl.FeatureSubsetSupplier featureSupplier = (EClassImpl.FeatureSubsetSupplier)eObject.eClass().getEAllStructuralFeatures();
        EStructuralFeature[] eStructuralFeatures = featureSupplier.containments();
        return (eStructuralFeatures == null ? EContentsEList.emptyContentsEList() : new EContentsEList<EObject>(eObject, eStructuralFeatures){

            protected ListIterator<EObject> newResolvingListIterator() {
                return new EContentsEList.ResolvingFeatureIteratorImpl<EObject>(this.eObject, this.eStructuralFeatures){

                    protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
                        return !eStructuralFeature.isDerived();
                    }
                };
            }
        }).iterator();
    }

    private static class EClassTypeHierarchyComparator
    implements Comparator<EClass> {
        private EClassTypeHierarchyComparator() {
        }

        @Override
        public int compare(EClass classA, EClass classB) {
            if (classA.getEAllSuperTypes().contains((Object)classB)) {
                return -1;
            }
            if (classB.getEAllSuperTypes().contains((Object)classA)) {
                return 1;
            }
            return 0;
        }
    }

    public static interface ElementReferenceAcceptor {
        public void accept(EObject var1, EObject var2, EReference var3, int var4);
    }
}

