/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.findReferences;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ReferenceFinder
implements IReferenceFinder {
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    protected static final int MONITOR_CHUNK_SIZE = 100;

    @Inject
    public ReferenceFinder() {
    }

    protected ReferenceFinder(IResourceServiceProvider.Registry serviceProviderRegistry) {
        this.serviceProviderRegistry = serviceProviderRegistry;
    }

    protected IResourceServiceProvider.Registry getServiceProviderRegistry() {
        return this.serviceProviderRegistry;
    }

    @Override
    public void findReferences(TargetURIs targetURIs, Set<URI> candidates, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions descriptions, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        if (!targetURIs.isEmpty() && !candidates.isEmpty()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(targetURIs.size() / 100 + 1));
            SubMonitor useMe = subMonitor.newChild(1);
            int i = 0;
            for (URI candidate : candidates) {
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IReferenceFinder languageSpecific = this.getLanguageSpecificReferenceFinder(candidate);
                this.doFindReferencesWith(languageSpecific, targetURIs, candidate, resourceAccess, descriptions, acceptor, (IProgressMonitor)useMe);
                if (++i % 100 != 0) continue;
                useMe = subMonitor.newChild(1);
            }
        }
    }

    protected IReferenceFinder getLanguageSpecificReferenceFinder(URI candidate) {
        IResourceServiceProvider serviceProvider = this.serviceProviderRegistry.getResourceServiceProvider(candidate);
        IReferenceFinder languageSpecific = serviceProvider != null ? serviceProvider.get(IReferenceFinder.class) : this;
        return languageSpecific;
    }

    protected void doFindReferencesWith(final IReferenceFinder referenceFinder, final TargetURIs targetURIs, final URI candidate, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions descriptions, final IReferenceFinder.Acceptor acceptor, final IProgressMonitor monitor) {
        IResourceDescription resourceDescription = null;
        if (!targetURIs.getTargetResourceURIs().contains(candidate) && (resourceDescription = descriptions.getResourceDescription(candidate)) != null) {
            referenceFinder.findReferences(targetURIs, resourceDescription, resourceAccess, acceptor, monitor);
        } else if (resourceAccess != null) {
            resourceAccess.readOnly(candidate, new IUnitOfWork.Void<ResourceSet>(){

                public void process(ResourceSet state) throws Exception {
                    Resource resource = state.getResource(candidate, false);
                    if (resource != null) {
                        referenceFinder.findReferences(targetURIs, resource, acceptor, monitor);
                    }
                }
            });
        }
    }

    @Override
    public void findReferences(TargetURIs targetURIs, Resource resource, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        for (EObject content : resource.getContents()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.findLocalReferencesFromElement(targetURIs, content, resource, acceptor);
        }
    }

    @Override
    public void findReferences(final TargetURIs targetURIs, IResourceDescription resourceDescription, IReferenceFinder.IResourceAccess resourceAccess, final IReferenceFinder.Acceptor acceptor, final IProgressMonitor monitor) {
        final URI resourceURI = resourceDescription.getURI();
        if (resourceAccess != null && targetURIs.containsResource(resourceURI)) {
            IUnitOfWork.Void<ResourceSet> finder = new IUnitOfWork.Void<ResourceSet>(){

                public void process(ResourceSet state) throws Exception {
                    Resource resource = state.getResource(resourceURI, true);
                    ReferenceFinder.this.findReferences(targetURIs, resource, acceptor, monitor);
                }
            };
            resourceAccess.readOnly(resourceURI, finder);
        } else {
            this.findReferencesInDescription(targetURIs, resourceDescription, resourceAccess, acceptor, monitor);
        }
    }

    protected void findReferencesInDescription(TargetURIs targetURIs, IResourceDescription resourceDescription, IReferenceFinder.IResourceAccess resourceAccess, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        for (IReferenceDescription referenceDescription : resourceDescription.getReferenceDescriptions()) {
            if (!targetURIs.contains(referenceDescription.getTargetEObjectUri())) continue;
            acceptor.accept(referenceDescription);
        }
    }

    @Override
    public void findAllReferences(TargetURIs targetURIs, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions indexData, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        if (!targetURIs.isEmpty()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(Iterables.size(indexData.getAllResourceDescriptions()) / 100 + 1));
            SubMonitor useMe = subMonitor.newChild(1);
            int i = 0;
            for (IResourceDescription resourceDescription : indexData.getAllResourceDescriptions()) {
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IReferenceFinder languageSpecific = this.getLanguageSpecificReferenceFinder(resourceDescription.getURI());
                languageSpecific.findReferences(targetURIs, resourceDescription, resourceAccess, acceptor, (IProgressMonitor)useMe);
                if (++i % 100 != 0) continue;
                useMe = subMonitor.newChild(1);
            }
        }
    }

    protected void findLocalReferencesFromElement(TargetURIs targetURIs, EObject sourceCandidate, Resource localResource, IReferenceFinder.Acceptor acceptor) {
        URI sourceURI = null;
        if (this.doProcess(sourceCandidate, targetURIs)) {
            for (EReference ref : sourceCandidate.eClass().getEAllReferences()) {
                URI refURI;
                if (!sourceCandidate.eIsSet((EStructuralFeature)ref)) continue;
                if (ref.isContainment()) {
                    Object content = sourceCandidate.eGet((EStructuralFeature)ref, false);
                    if (ref.isMany()) {
                        InternalEList contentList = (InternalEList)content;
                        int i = 0;
                        while (i < contentList.size()) {
                            EObject childElement = (EObject)contentList.basicGet(i);
                            if (!childElement.eIsProxy()) {
                                this.findLocalReferencesFromElement(targetURIs, childElement, localResource, acceptor);
                            }
                            ++i;
                        }
                        continue;
                    }
                    EObject childElement = (EObject)content;
                    if (childElement.eIsProxy()) continue;
                    this.findLocalReferencesFromElement(targetURIs, childElement, localResource, acceptor);
                    continue;
                }
                if (ref.isContainer() || !this.doProcess(ref, targetURIs)) continue;
                Object value = sourceCandidate.eGet((EStructuralFeature)ref, false);
                if (ref.isMany()) {
                    InternalEList values = (InternalEList)value;
                    int i = 0;
                    while (i < values.size()) {
                        URI refURI2;
                        EObject instanceOrProxy = this.toValidInstanceOrNull(localResource, targetURIs, (EObject)values.basicGet(i));
                        if (instanceOrProxy != null && targetURIs.contains(refURI2 = EcoreUtil2.getPlatformResourceOrNormalizedURI(instanceOrProxy))) {
                            sourceURI = sourceURI == null ? EcoreUtil2.getPlatformResourceOrNormalizedURI(sourceCandidate) : sourceURI;
                            acceptor.accept(sourceCandidate, sourceURI, ref, i, instanceOrProxy, refURI2);
                        }
                        ++i;
                    }
                    continue;
                }
                EObject instanceOrProxy = this.toValidInstanceOrNull(localResource, targetURIs, (EObject)value);
                if (instanceOrProxy == null || !targetURIs.contains(refURI = EcoreUtil2.getPlatformResourceOrNormalizedURI(instanceOrProxy))) continue;
                sourceURI = sourceURI == null ? EcoreUtil2.getPlatformResourceOrNormalizedURI(sourceCandidate) : sourceURI;
                acceptor.accept(sourceCandidate, sourceURI, ref, -1, instanceOrProxy, refURI);
            }
        }
    }

    protected EObject toValidInstanceOrNull(Resource resource, TargetURIs targetURIs, EObject value) {
        EObject result = this.resolveInternalProxy(value, resource);
        return result;
    }

    protected EObject resolveInternalProxy(EObject elementOrProxy, Resource resource) {
        if (elementOrProxy.eIsProxy() && ((InternalEObject)elementOrProxy).eProxyURI().trimFragment().equals(resource.getURI())) {
            return EcoreUtil.resolve((EObject)elementOrProxy, (Resource)resource);
        }
        return elementOrProxy;
    }

    protected boolean doProcess(EObject sourceCandidate, TargetURIs targetURISet) {
        return true;
    }

    protected boolean doProcess(EReference reference, TargetURIs targetURISet) {
        return true;
    }
}

