/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.smoketest;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.junit4.smoketest.ScenarioProcessor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.StringInputStream;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public enum Scenario {
    SkipLastCharacters{

        public void processInput(String input, ScenarioProcessor tester) throws Exception {
            int i = 0;
            while (i < input.length()) {
                tester.processFile(input.substring(0, i));
                ++i;
            }
        }
    }
    ,
    SkipFirstCharacters{

        public void processInput(String input, ScenarioProcessor tester) throws Exception {
            int i = 0;
            while (i < input.length()) {
                tester.processFile(input.substring(i));
                ++i;
            }
        }
    }
    ,
    SkipCharacterInBetween{

        public void processInput(String input, ScenarioProcessor tester) throws Exception {
            if (input.length() > 1) {
                int i = 0;
                while (i < input.length() - 1) {
                    tester.processFile(String.valueOf(input.substring(0, i)) + input.substring(i + 1));
                    ++i;
                }
            }
        }
    }
    ,
    SkipTokensInBetween{

        public void processInput(String input, ScenarioProcessor tester) throws Exception {
            XtextResource resource = tester.get(XtextResource.class);
            resource.setURI(URI.createURI((String)"dummy.uri"));
            try {
                resource.load((InputStream)new StringInputStream(input, "UTF-8"), Collections.singletonMap(XtextResource.OPTION_ENCODING, "UTF-8"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            ICompositeNode rootNode = resource.getParseResult().getRootNode();
            for (ILeafNode token : rootNode.getLeafNodes()) {
                int start = token.getTotalOffset();
                int length = token.getTotalLength();
                if (length <= 1 || length == 3) continue;
                tester.processFile(String.valueOf(input.substring(0, start)) + input.substring(start + length));
            }
        }
    }
    ,
    SkipNodesInBetween{

        public void processInput(String input, ScenarioProcessor tester) throws Exception {
            XtextResource resource = tester.get(XtextResource.class);
            resource.setURI(URI.createURI((String)"dummy.uri"));
            try {
                resource.load((InputStream)new StringInputStream(input, "UTF-8"), Collections.singletonMap(XtextResource.OPTION_ENCODING, "UTF-8"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            ICompositeNode rootNode = resource.getParseResult().getRootNode();
            ReplaceRegion region = null;
            for (INode node : rootNode.getAsTreeIterable()) {
                int offset = node.getTotalOffset();
                int length = node.getTotalLength();
                if (length == 0 || region != null && region.getOffset() == offset && region.getLength() == length) continue;
                region = new ReplaceRegion(offset, length, "");
                if (Iterables.size(node.getLeafNodes()) <= 1 || length <= 1 || length == 3) continue;
                StringBuilder builder = new StringBuilder(rootNode.getText());
                region.applyTo(builder);
                tester.processFile(builder.toString());
            }
        }
    }
    ,
    SkipThreeCharactersInBetween{

        public void processInput(String input, ScenarioProcessor tester) throws Exception {
            if (input.length() > 1) {
                int i = 0;
                while (i < input.length() - 3) {
                    tester.processFile(String.valueOf(input.substring(0, i)) + input.substring(i + 3));
                    ++i;
                }
            }
        }
    };


    private Scenario() {
    }

    public abstract void processInput(String var1, ScenarioProcessor var2) throws Exception;

    /* synthetic */ Scenario(String string, int n, Scenario scenario) {
        this();
    }
}

