/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.smoketest;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.util.ReplaceRegion;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSmokeTest {
    @Inject
    Provider<Lexer> lexerProvider;

    protected abstract Iterable<String> getSmokeTestModels();

    protected abstract void processModel(String var1) throws Exception;

    protected abstract void processModelWithoutResourceSet(String var1) throws Exception;

    protected abstract LazyLinkingResource createResource(String var1);

    @Test
    public void testSkipLastCharacters() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            int i = 0;
            while (i < string.length()) {
                this.logProgress(i);
                this.processModel(string.substring(0, i));
                ++i;
            }
        }
    }

    @Test
    public void testSkipFirstCharacters() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            int i = 0;
            while (i < string.length()) {
                this.logProgress(i);
                this.processModel(string.substring(i));
                ++i;
            }
        }
    }

    @Test
    public void testSkipCharacterInBetween() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            int i = 0;
            while (i < string.length() - 1) {
                this.logProgress(i);
                this.processModel(String.valueOf(string.substring(0, i)) + string.substring(i + 1));
                ++i;
            }
        }
    }

    @Test
    public void testSkipTokensInBetween() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            ArrayList tokenList = Lists.newArrayList();
            Lexer lexer = (Lexer)((Object)this.lexerProvider.get());
            lexer.setCharStream((CharStream)new ANTLRStringStream(string));
            Token token = lexer.nextToken();
            while (token != Token.EOF_TOKEN) {
                tokenList.add((CommonToken)token);
                token = lexer.nextToken();
            }
            for (CommonToken token2 : tokenList) {
                int start = token2.getStartIndex();
                int length = token2.getText().length();
                this.logProgress(token2);
                this.processModel(String.valueOf(string.substring(0, start)) + string.substring(start + length));
            }
        }
    }

    @Test
    public void testSkipNodesInBetween() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            LazyLinkingResource resource = this.createResource(string);
            if (resource == null) continue;
            ICompositeNode rootNode = resource.getParseResult().getRootNode();
            ReplaceRegion replaceRegion = null;
            for (INode node : rootNode.getAsTreeIterable()) {
                int offset = node.getTotalOffset();
                int length = node.getTotalLength();
                if (replaceRegion != null && replaceRegion.getOffset() == offset && replaceRegion.getLength() == length) continue;
                replaceRegion = new ReplaceRegion(offset, length, "");
                StringBuilder builder = new StringBuilder(string);
                replaceRegion.applyTo(builder);
                this.processModel(builder.toString());
            }
        }
    }

    @Test
    public void testSkipLastCharactersWithoutResourceSet() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            int i = 0;
            while (i < string.length()) {
                this.logProgress(i);
                this.processModelWithoutResourceSet(string.substring(0, i));
                ++i;
            }
        }
    }

    @Test
    public void testSkipFirstCharactersWithoutResourceSet() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            int i = 0;
            while (i < string.length()) {
                this.logProgress(i);
                this.processModelWithoutResourceSet(string.substring(i));
                ++i;
            }
        }
    }

    @Test
    public void testSkipCharacterInBetweenWithoutResourceSet() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            int i = 0;
            while (i < string.length() - 1) {
                this.logProgress(i);
                this.processModelWithoutResourceSet(String.valueOf(string.substring(0, i)) + string.substring(i + 1));
                ++i;
            }
        }
    }

    @Test
    public void testSkipTokensInBetweenWithoutResourceSet() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            ArrayList tokenList = Lists.newArrayList();
            Lexer lexer = (Lexer)((Object)this.lexerProvider.get());
            lexer.setCharStream((CharStream)new ANTLRStringStream(string));
            Token token = lexer.nextToken();
            while (token != Token.EOF_TOKEN) {
                tokenList.add((CommonToken)token);
                token = lexer.nextToken();
            }
            for (CommonToken token2 : tokenList) {
                int start = token2.getStartIndex();
                int length = token2.getText().length();
                this.logProgress(token2);
                this.processModelWithoutResourceSet(String.valueOf(string.substring(0, start)) + string.substring(start + length));
            }
        }
    }

    @Test
    public void testSkipNodesInBetweenWithoutResourceSet() throws Exception {
        for (String string : this.getSmokeTestModels()) {
            LazyLinkingResource resource = this.createResource(string);
            if (resource == null) continue;
            ICompositeNode rootNode = resource.getParseResult().getRootNode();
            ReplaceRegion replaceRegion = null;
            for (INode node : rootNode.getAsTreeIterable()) {
                int offset = node.getTotalOffset();
                int length = node.getTotalLength();
                if (replaceRegion != null && replaceRegion.getOffset() == offset && replaceRegion.getLength() == length) continue;
                replaceRegion = new ReplaceRegion(offset, length, "");
                StringBuilder builder = new StringBuilder(string);
                replaceRegion.applyTo(builder);
                this.processModelWithoutResourceSet(builder.toString());
            }
        }
    }

    protected void logProgress(Object info) {
    }
}

