/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.IHiddenTokenSequencer;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;
import org.eclipse.xtext.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenTokenSequencer
implements IHiddenTokenSequencer,
ISyntacticSequenceAcceptor {
    protected ISequenceAcceptor delegate;
    @Inject
    protected IHiddenTokenHelper hiddenTokenHelper;
    protected INode lastNode;
    protected INode lastEmittedNode;
    protected INode rootNode;
    protected ISyntacticSequencer sequencer;
    @Inject
    protected TokenUtil tokenUtil;

    @Override
    public void acceptAssignedCrossRefDatatype(RuleCall rc, String tkn, EObject val, int index, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptAssignedCrossRefDatatype(rc, tkn, val, index, node);
    }

    @Override
    public void acceptAssignedCrossRefEnum(RuleCall rc, String token, EObject value, int index, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptAssignedCrossRefEnum(rc, token, value, index, node);
    }

    @Override
    public void acceptAssignedCrossRefKeyword(Keyword kw, String token, EObject value, int index, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptAssignedCrossRefKeyword(kw, token, value, index, node);
    }

    @Override
    public void acceptAssignedCrossRefTerminal(RuleCall rc, String token, EObject value, int index, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptAssignedCrossRefTerminal(rc, token, value, index, node);
    }

    @Override
    public void acceptAssignedDatatype(RuleCall rc, String token, Object value, int index, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptAssignedDatatype(rc, token, value, index, node);
    }

    @Override
    public void acceptAssignedEnum(RuleCall enumRC, String token, Object value, int index, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptAssignedEnum(enumRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedKeyword(Keyword keyword, String token, Object value, int index, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptAssignedKeyword(keyword, token, value, index, node);
    }

    @Override
    public void acceptAssignedTerminal(RuleCall terminalRC, String token, Object value, int index, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptAssignedTerminal(terminalRC, token, value, index, node);
    }

    @Override
    public void acceptUnassignedAction(Action action) {
        this.delegate.acceptUnassignedAction(action);
    }

    @Override
    public void acceptUnassignedDatatype(RuleCall datatypeRC, String token, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptUnassignedDatatype(datatypeRC, token, node);
    }

    @Override
    public void acceptUnassignedEnum(RuleCall enumRC, String token, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptUnassignedEnum(enumRC, token, node);
    }

    @Override
    public void acceptUnassignedKeyword(Keyword keyword, String token, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptUnassignedKeyword(keyword, token, node);
    }

    @Override
    public void acceptUnassignedTerminal(RuleCall terminalRC, String token, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptUnassignedTerminal(terminalRC, token, node);
    }

    protected void emitHiddenTokens(List<INode> hiddens) {
        if (hiddens == null) {
            return;
        }
        boolean lastNonWhitespace = true;
        for (INode node : hiddens) {
            if (this.tokenUtil.isCommentNode(node)) {
                if (lastNonWhitespace) {
                    this.delegate.acceptWhitespace(this.hiddenTokenHelper.getWhitespaceRuleFor(null, ""), "", null);
                }
                lastNonWhitespace = true;
                this.delegate.acceptComment((AbstractRule)node.getGrammarElement(), node.getText(), (ILeafNode)node);
            } else {
                this.delegate.acceptWhitespace((AbstractRule)node.getGrammarElement(), node.getText(), (ILeafNode)node);
                lastNonWhitespace = false;
            }
            this.lastEmittedNode = node;
        }
        if (lastNonWhitespace) {
            this.delegate.acceptWhitespace(this.hiddenTokenHelper.getWhitespaceRuleFor(null, ""), "", null);
        }
    }

    @Override
    public boolean enterAssignedAction(Action action, EObject semanticChild, ICompositeNode node) {
        return this.delegate.enterAssignedAction(action, semanticChild, node);
    }

    @Override
    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject semanticChild, ICompositeNode node) {
        return this.delegate.enterAssignedParserRuleCall(rc, semanticChild, node);
    }

    @Override
    public void enterUnassignedParserRuleCall(RuleCall rc) {
        this.delegate.enterUnassignedParserRuleCall(rc);
    }

    @Override
    public void finish() {
        List<INode> hidden;
        if (this.rootNode != null && this.rootNode == this.rootNode.getRootNode() && !(hidden = this.getRemainingHiddenNodesInContainer(this.lastNode, this.rootNode)).isEmpty()) {
            this.emitHiddenTokens(hidden);
            this.lastNode = this.rootNode;
        }
        this.delegate.finish();
    }

    /*
     * Unable to fully structure code
     */
    protected List<INode> getHiddenNodesBetween(INode from, INode to) {
        if (from == null && to == null) {
            return null;
        }
        out = Lists.newArrayList();
        deletedSemanticElements = Sets.newHashSet();
        if (to == null) {
            ni = new NodeIterator(from);
            while (ni.hasNext()) {
                next = ni.next();
                if (!Iterables.contains(this.rootNode.getAsTreeIterable(), (Object)next) || next == this.lastEmittedNode) break;
                if (this.tokenUtil.isWhitespaceOrCommentNode(next)) {
                    out.add(next);
                    continue;
                }
                if (this.belongsToDeletedElement(next)) {
                    this.handleDeletedElement(out, deletedSemanticElements, next);
                    ni.prune();
                    continue;
                }
                break;
            }
        } else if (from == null) {
            ni = new NodeIterator(to);
            while (ni.hasPrevious()) {
                prev = ni.previous();
                if (!Iterables.contains(this.rootNode.getAsTreeIterable(), (Object)prev) || prev == this.lastEmittedNode) break;
                if (this.tokenUtil.isWhitespaceOrCommentNode(prev)) {
                    out.add(0, prev);
                    continue;
                }
                if (this.belongsToDeletedElement(prev)) {
                    this.handleDeletedElement(out, deletedSemanticElements, prev);
                    ni.prune();
                    continue;
                }
                break;
            }
        } else {
            ni = new NodeIterator(from);
            while (ni.hasNext()) {
                next = ni.next();
                if (this.tokenUtil.isWhitespaceOrCommentNode(next)) {
                    out.add(next);
                    continue;
                }
                if (next.equals(to)) {
                    if (next instanceof ICompositeNode && (GrammarUtil.isDatatypeRuleCall(next.getGrammarElement()) || GrammarUtil.isEnumRuleCall(next.getGrammarElement()) || next.getGrammarElement() instanceof CrossReference)) {
                        while (ni.hasNext()) {
                            next2 = ni.next();
                            if (this.tokenUtil.isWhitespaceOrCommentNode(next2)) {
                                out.add(next2);
                                continue;
                            }
                            if (!(next2 instanceof ILeafNode)) {
                                continue;
                            }
                            ** GOTO lbl60
                        }
                    }
                } else {
                    if (this.belongsToDeletedElement(next)) {
                        this.handleDeletedElement(out, deletedSemanticElements, next);
                        ni.prune();
                        continue;
                    }
                    if (!this.tokenUtil.isToken(next)) {
                        continue;
                    }
                }
                break;
            }
        }
        if ((from == null || to == null) && out.isEmpty()) {
            return null;
        }
        return this.filterNodesOfDeletedElements(out, deletedSemanticElements);
    }

    protected boolean belongsToDeletedElement(INode node) {
        return node instanceof ICompositeNode && node.getSemanticElement() != null && node.getSemanticElement().eResource() == null;
    }

    protected void handleDeletedElement(List<INode> out, Set<EObject> deletedSemanticElements, INode nodeOfDeletedElement) {
        deletedSemanticElements.add(nodeOfDeletedElement.getSemanticElement());
        Pair<List<ILeafNode>, List<ILeafNode>> surroundingHiddenTokens = this.tokenUtil.getLeadingAndTrailingHiddenTokens(nodeOfDeletedElement);
        out.addAll((Collection<INode>)surroundingHiddenTokens.getFirst());
        out.addAll((Collection<INode>)surroundingHiddenTokens.getSecond());
    }

    protected List<INode> filterNodesOfDeletedElements(List<INode> allNodes, Set<EObject> deletedElements) {
        ArrayList filtered = Lists.newArrayList();
        filtered.addAll(allNodes);
        for (EObject deletedElement : deletedElements) {
            filtered.removeAll(this.getHiddenNodesBelongingTo(deletedElement));
        }
        return filtered;
    }

    protected Set<INode> getHiddenNodesBelongingTo(EObject semanticElement) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor(semanticElement);
        if (node == null) {
            return Sets.newHashSet();
        }
        HashSet associatedNodes = Sets.newHashSet();
        associatedNodes.addAll(this.getLeadingCommentsIncludingWhitespace(node));
        associatedNodes.addAll(this.getTrailingCommentsIncludingWhitespace(node));
        return associatedNodes;
    }

    protected Set<INode> getLeadingCommentsIncludingWhitespace(ICompositeNode node) {
        for (INode child : node.getAsTreeIterable()) {
            if (!(child instanceof ILeafNode) || ((ILeafNode)child).isHidden()) continue;
            return this.getLeadingCommentsIncludingWhitespace((ILeafNode)child);
        }
        return Sets.newHashSet();
    }

    protected Set<INode> getTrailingCommentsIncludingWhitespace(ICompositeNode node) {
        for (INode child : node.getAsTreeIterable().reverse()) {
            if (!(child instanceof ILeafNode) || ((ILeafNode)child).isHidden()) continue;
            return this.getTrailingCommentsIncludingWhitespace((ILeafNode)child);
        }
        return Sets.newHashSet();
    }

    protected Set<INode> getLeadingCommentsIncludingWhitespace(ILeafNode node) {
        HashSet associatedNodes = Sets.newHashSet();
        HashSet pendingWhitespace = Sets.newHashSet();
        INode lastLink = node;
        NodeIterator ni = new NodeIterator(lastLink);
        while (ni.hasPrevious()) {
            INode prev = ni.previous();
            if (this.tokenUtil.isCommentNode(prev)) {
                if (!this.isLeadingCommentFor(prev, lastLink)) break;
                lastLink = prev;
                associatedNodes.addAll(pendingWhitespace);
                associatedNodes.add(prev);
                continue;
            }
            if (this.tokenUtil.isWhitespaceNode(prev)) {
                pendingWhitespace.add(prev);
                continue;
            }
            if (!(prev instanceof ICompositeNode)) continue;
            associatedNodes.removeAll(this.getTrailingCommentsIncludingWhitespace((ICompositeNode)prev));
        }
        return associatedNodes;
    }

    protected Set<INode> getTrailingCommentsIncludingWhitespace(ILeafNode node) {
        HashSet associatedNodes = Sets.newHashSet();
        HashSet pendingWhitespace = Sets.newHashSet();
        INode lastLink = node;
        NodeIterator ni = new NodeIterator(lastLink);
        while (ni.hasNext()) {
            INode next = ni.next();
            if (this.tokenUtil.isCommentNode(next)) {
                if (!this.isTrailingCommentFor(next, lastLink)) break;
                lastLink = next;
                associatedNodes.addAll(pendingWhitespace);
                associatedNodes.add(next);
                continue;
            }
            if (!this.tokenUtil.isWhitespaceNode(next)) continue;
            pendingWhitespace.add(next);
        }
        return associatedNodes;
    }

    protected boolean isLeadingCommentFor(INode comment, INode node) {
        if (!this.tokenUtil.isCommentNode(comment)) {
            return false;
        }
        if (comment.getText().endsWith("\n")) {
            return node.getStartLine() == comment.getEndLine();
        }
        return node.getStartLine() - comment.getEndLine() <= 1;
    }

    protected boolean isTrailingCommentFor(INode comment, INode node) {
        if (!this.tokenUtil.isCommentNode(comment)) {
            return false;
        }
        return comment.getStartLine() == node.getEndLine();
    }

    protected INode getLastLeaf(INode node) {
        while (node instanceof ICompositeNode) {
            node = ((ICompositeNode)node).getLastChild();
        }
        return node;
    }

    protected List<INode> getRemainingHiddenNodesInContainer(INode from, INode root) {
        if (from == null || root == null) {
            return Collections.emptyList();
        }
        ArrayList out = Lists.newArrayList();
        NodeIterator ni = new NodeIterator(from);
        while (ni.hasNext()) {
            INode next = ni.next();
            if (next.getTotalOffset() > root.getTotalEndOffset()) {
                return out;
            }
            if (this.tokenUtil.isWhitespaceOrCommentNode(next)) {
                out.add(next);
                continue;
            }
            if (!this.tokenUtil.isToken(next)) continue;
            return Collections.emptyList();
        }
        return out;
    }

    @Override
    public void init(EObject context, EObject semanticObject, ISequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
        this.delegate = sequenceAcceptor;
        this.rootNode = this.lastNode = NodeModelUtils.findActualNodeFor(semanticObject);
    }

    @Override
    public void leaveAssignedAction(Action action, EObject semanticChild) {
        this.delegate.leaveAssignedAction(action, semanticChild);
    }

    @Override
    public void leaveAssignedParserRuleCall(RuleCall rc, EObject semanticChild) {
        this.delegate.leaveAssignedParserRuleCall(rc, semanticChild);
    }

    @Override
    public void leaveUnssignedParserRuleCall(RuleCall rc) {
        this.delegate.leaveUnssignedParserRuleCall(rc);
    }
}

