/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.xtext.junit4.internal.Timed;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopwatchRule
implements TestRule {
    private boolean watchAll = false;
    public static Date DATE = new Date();

    public StopwatchRule() {
    }

    public StopwatchRule(boolean watchAll) {
        this.watchAll = watchAll;
    }

    public void printStopwatchData(Description description, Map<String, Stopwatches.NumbersForTask> data, long timeSpend) {
        String property = System.getProperty("stopwatch.file");
        String isJson = System.getProperty("stopwatch.json");
        PrintStream out = System.out;
        FileOutputStream outputStream = null;
        if (property != null) {
            try {
                outputStream = new FileOutputStream(new File(property), true);
                out = new PrintStream(outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (isJson == null) {
                out.println("-------------------------------------------------------------------------------------------------------------------------\n");
                out.println("Test '" + description.getDisplayName() + "' :");
                out.println(this.getStopwatchDataAsReadableString(data));
            } else {
                out.println(",{");
                out.println("  \"name\" : \"" + description.getDisplayName() + "\",");
                out.println("  \"date\" : \"" + DATE + "\",");
                out.println("  \"time\" : \"" + timeSpend + "\",");
                out.println("  \"tasks\" : [");
                Iterator<Map.Entry<String, Stopwatches.NumbersForTask>> iter = data.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, Stopwatches.NumbersForTask> task = iter.next();
                    out.print("    {\"name\" : \"" + task.getKey() + "\",\"time\" : " + task.getValue().getMilliseconds() + ",\"measurements\" : " + task.getValue().getNumberOfMeasurements());
                    if (iter.hasNext()) {
                        out.println("},");
                        continue;
                    }
                    out.println("}");
                }
                out.println("  ]");
                out.println("}");
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getStopwatchDataAsReadableString(Map<String, Stopwatches.NumbersForTask> data) {
        StringBuilder sb = new StringBuilder();
        sb.append("-------------------------------------------------------------------------------------------------------------------------\n");
        for (Map.Entry<String, Stopwatches.NumbersForTask> task : data.entrySet()) {
            sb.append("Task '" + task.getKey() + "' took " + task.getValue().getMilliseconds() + "ms (" + task.getValue().getNumberOfMeasurements() + " measurements).\n");
        }
        sb.append("-------------------------------------------------------------------------------------------------------------------------\n");
        return sb.toString();
    }

    public Statement apply(final Statement base, final Description description) {
        if (!this.watchAll && description.getAnnotation(Timed.class) == null) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                long timeSpend = -1L;
                try {
                    Stopwatches.setEnabled(true);
                    Stopwatches.resetAll();
                    long before = System.currentTimeMillis();
                    base.evaluate();
                    timeSpend = System.currentTimeMillis() - before;
                }
                finally {
                    StopwatchRule.this.printStopwatchData(description, Stopwatches.allNumbers(), timeSpend);
                    Stopwatches.resetAll();
                    Stopwatches.setEnabled(false);
                }
            }
        };
    }
}

