/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.xtext.mwe.ISlotEntry;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlotEntry
implements ISlotEntry {
    private String slot = "model";
    private String name;
    private String namespaceDelimiter = ".";
    private String nsURI;
    private String type;
    private boolean firstOnly = false;
    private static final Logger log = Logger.getLogger(SlotEntry.class);

    public void setType(String typeName) {
        this.type = typeName;
    }

    public void setNsURI(String nsURI) {
        this.nsURI = nsURI;
    }

    public String getName() {
        return this.name;
    }

    public String getSlot() {
        return this.slot;
    }

    public String getNamespaceDelimiter() {
        return this.namespaceDelimiter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public void setNamespaceDelimiter(String namespaceDelimiter) {
        this.namespaceDelimiter = namespaceDelimiter;
    }

    public void setFirstOnly(boolean firstOnly) {
        this.firstOnly = firstOnly;
    }

    public boolean isFirstOnly() {
        return this.firstOnly;
    }

    @Override
    public void put(WorkflowContext ctx, IResourceDescriptions resourceDescriptions, ResourceSet resourceSet) {
        Set<EClass> eClasses = this.findEClasses(resourceSet, this.nsURI, this.type);
        List<EObject> elements = this.findEObjectsOfType(eClasses, resourceDescriptions, resourceSet);
        if (elements.isEmpty()) {
            log.warn((Object)("Could not find any exported element of type '" + this.type + "' -> Slot '" + this.slot + "' is empty."));
            ctx.set(this.slot, Collections.emptyList());
        } else if (this.firstOnly) {
            ctx.set(this.slot, (Object)elements.get(0));
        } else {
            ctx.set(this.slot, elements);
        }
    }

    protected List<EObject> findEObjectsOfType(Set<EClass> eClasses, IResourceDescriptions resourceDescriptions, ResourceSet resourceSet) {
        ArrayList elements = Lists.newArrayList();
        Iterable<IResourceDescription> descriptions = resourceDescriptions.getAllResourceDescriptions();
        for (IResourceDescription resDesc : descriptions) {
            Iterable<IEObjectDescription> objects = resDesc.getExportedObjects();
            for (IEObjectDescription description : objects) {
                if (!this.matches(eClasses, description)) continue;
                elements.add(resourceSet.getEObject(description.getEObjectURI(), true));
            }
        }
        return elements;
    }

    protected Set<EClass> findEClasses(ResourceSet resourceSet, String nsURI2, String typeName2) {
        if (typeName2 == null) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        Set<String> keySet = this.getNsUris();
        for (String string : keySet) {
            try {
                EClassifier classifier;
                EPackage ePackage = resourceSet.getPackageRegistry().getEPackage(string);
                if (ePackage == null || !((classifier = ePackage.getEClassifier(typeName2)) instanceof EClass)) continue;
                result.add((EClass)classifier);
            }
            catch (NoClassDefFoundError e) {
                throw new NoClassDefFoundError("NoClassDefFoundError while loading ePackage: " + string + " - " + e.getMessage());
            }
        }
        if (result.isEmpty()) {
            throw new WorkflowInterruptedException("Couldn't find EClass for name '" + typeName2 + "'.");
        }
        return result;
    }

    protected Set<String> getNsUris() {
        if (this.nsURI != null) {
            return Collections.singleton(this.nsURI);
        }
        return Sets.newHashSet((Iterable)EPackage.Registry.INSTANCE.keySet());
    }

    protected boolean matches(Set<EClass> eclasses, IEObjectDescription desc) {
        boolean valid = eclasses.isEmpty();
        Iterator<EClass> iterator = eclasses.iterator();
        while (!valid && iterator.hasNext()) {
            EClass eClass = iterator.next();
            boolean bl = valid = valid || EcorePackage.Literals.EOBJECT == eClass || eClass.isSuperTypeOf(desc.getEClass());
        }
        if (this.name != null) {
            if (Strings.isEmpty(this.namespaceDelimiter)) {
                return valid && this.name.equals(desc.getName().toString());
            }
            QualifiedName qualifiedName = QualifiedName.create(this.name.split(Pattern.quote(this.getNamespaceDelimiter())));
            return valid && (qualifiedName == null || qualifiedName.equals(desc.getName()));
        }
        return valid;
    }

    protected EObject getEObject(IEObjectDescription description, ResourceSet resourceSet) {
        return resourceSet.getEObject(description.getEObjectURI(), true);
    }

    @Override
    public void preInvoke() {
    }
}

