/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.validation.IAssignmentQuantityAllocator;
import org.eclipse.xtext.validation.IConcreteSyntaxConstraintProvider;
import org.eclipse.xtext.validation.IConcreteSyntaxDiagnosticProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcreteSyntaxDiagnosticProvider
implements IConcreteSyntaxDiagnosticProvider {
    @Inject
    protected IAssignmentQuantityAllocator quantityAllocator;

    @Override
    public IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic createAssignmentMissingDiagnostic(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, EObject source, EStructuralFeature feature, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
        return new ConcreteSyntaxAssignmentMissingDiagnostic(rule, source, feature, involved);
    }

    @Override
    public IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic createFeatureMissingDiagnostic(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, EObject source, IConcreteSyntaxConstraintProvider.ISyntaxConstraint element, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
        return new ConcreteSyntaxFeatureMissingDiagnostic(rule, source, element, involved);
    }

    @Override
    public IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic createFeatureQuantityDiagnostic(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, IAssignmentQuantityAllocator.IQuantities source, EStructuralFeature feature, int actual, int min, int max, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
        return new ConcreteSyntaxFeatureDiagnostic(rule, source, feature, actual, min, max, involved);
    }

    @Override
    public IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic createUnexpectedTypeDiagnostic(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, EObject source, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
        return new ConcreteSyntaxObjectDiagnostic(rule, source, involved);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractConcreteSyntaxDiagnostic
    implements IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic {
        protected Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved;
        protected IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule;
        protected EObject source;

        public AbstractConcreteSyntaxDiagnostic(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, EObject source, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
            this.rule = rule;
            this.source = source;
            this.involved = involved;
        }

        protected void appendConstraint(StringBuffer msg) {
            if (this.involved.size() > 1) {
                msg.append(" Constraint: ");
                msg.append(this.getConstraint());
                msg.append(" Quantities: ");
                msg.append(this.getValue());
            }
        }

        public List<Diagnostic> getChildren() {
            return Collections.emptyList();
        }

        protected List<String> getChildren(IConcreteSyntaxConstraintProvider.ISyntaxConstraint obj, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> included) {
            ArrayList<String> r = new ArrayList<String>();
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint o : obj.getContents()) {
                if (!included.contains(o)) continue;
                r.add(this.getConstraint(o, included));
            }
            return r;
        }

        protected IConcreteSyntaxConstraintProvider.ISyntaxConstraint getCommonContainer() {
            Iterator<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> i = this.involved.iterator();
            if (!i.hasNext()) {
                return null;
            }
            IConcreteSyntaxConstraintProvider.ISyntaxConstraint root = i.next();
            while (i.hasNext()) {
                root = root.findCommonContainer(i.next());
            }
            return root;
        }

        public String getConstraint() {
            if (this.involved.size() > 1) {
                IConcreteSyntaxConstraintProvider.ISyntaxConstraint commonContainer = this.getCommonContainer();
                return this.getConstraint(commonContainer, this.getInvolvedIncludingContainers(commonContainer));
            }
            return "";
        }

        protected String getConstraint(IConcreteSyntaxConstraintProvider.ISyntaxConstraint element, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> all) {
            switch (element.getType()) {
                case ASSIGNMENT: {
                    return String.valueOf(((Assignment)element.getGrammarElement()).getFeature()) + element.getCardinality();
                }
                case GROUP: {
                    List<String> children1 = this.getChildren(element, all);
                    if (children1.size() == 1) {
                        return String.valueOf(children1.get(0)) + element.getCardinality();
                    }
                    return "(" + Joiner.on((String)" ").join(children1) + ")" + element.getCardinality();
                }
                case ALTERNATIVE: {
                    List<String> children2 = this.getChildren(element, all);
                    return "(" + Joiner.on((String)"|").join(children2) + ")" + element.getCardinality();
                }
                case ACTION: {
                    return "{" + ((Action)element.getGrammarElement()).getType().getClassifier().getName() + "}";
                }
            }
            return "";
        }

        public List<?> getData() {
            return Arrays.asList(this.source);
        }

        public Throwable getException() {
            return null;
        }

        protected Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> getInvolvedIncludingContainers(IConcreteSyntaxConstraintProvider.ISyntaxConstraint commonRoot) {
            HashSet<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> all = new HashSet<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>(this.involved);
            all.add(commonRoot);
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : this.involved) {
                IConcreteSyntaxConstraintProvider.ISyntaxConstraint cnt = a.getContainer();
                while (all.add(cnt)) {
                    cnt = cnt.getContainer();
                }
            }
            return all;
        }

        public ParserRule getRule() {
            return GrammarUtil.containingParserRule(this.rule.getGrammarElement());
        }

        public int getSeverity() {
            return 4;
        }

        public String getSource() {
            return EmfFormatter.objPath(this.source);
        }

        public String getValue() {
            HashSet<EStructuralFeature> feats = new HashSet<EStructuralFeature>();
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : this.involved) {
                if (a.getType() != IConcreteSyntaxConstraintProvider.ConstraintType.ASSIGNMENT) continue;
                feats.add(a.getAssignmentFeature(this.source.eClass()));
            }
            return Joiner.on((String)", ").join(Iterables.transform(feats, (Function)new Function<EStructuralFeature, String>(){

                public String apply(EStructuralFeature from) {
                    return String.valueOf(from.getName()) + ":" + ((AbstractConcreteSyntaxDiagnostic)AbstractConcreteSyntaxDiagnostic.this).ConcreteSyntaxDiagnosticProvider.this.quantityAllocator.getFeatureQuantity(AbstractConcreteSyntaxDiagnostic.this.source, from);
                }
            }));
        }

        public String toString() {
            return String.valueOf(this.getMessage()) + " Source: " + this.getSource();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConcreteSyntaxAssignmentMissingDiagnostic
    extends AbstractConcreteSyntaxDiagnostic {
        protected EStructuralFeature feature;
        protected Set<EClass> requiredTypes;

        public ConcreteSyntaxAssignmentMissingDiagnostic(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, EObject source, EStructuralFeature feature, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
            super(rule, source, involved);
            this.feature = feature;
            this.requiredTypes = Sets.newHashSet();
            this.collectAssignments(this.rule, this.feature, this.requiredTypes);
        }

        protected void collectAssignments(IConcreteSyntaxConstraintProvider.ISyntaxConstraint ele, EStructuralFeature matcher, Set<EClass> types) {
            if (ele.getType() == IConcreteSyntaxConstraintProvider.ConstraintType.ASSIGNMENT && ele.getAssignmentName().equals(matcher.getName())) {
                types.addAll(ele.getSemanticTypes());
            }
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint e : ele.getContents()) {
                this.collectAssignments(e, matcher, types);
            }
        }

        public int getCode() {
            if (this.requiredTypes.isEmpty()) {
                return 1;
            }
            return 2;
        }

        public String getMessage() {
            StringBuffer msg = new StringBuffer();
            msg.append("The feature ");
            msg.append(this.feature.getEContainingClass().getName());
            if (this.feature.getEContainingClass() != this.source.eClass()) {
                msg.append("(");
                msg.append(this.source.eClass().getName());
                msg.append(")");
            }
            msg.append(".");
            msg.append(this.feature.getName());
            switch (this.getCode()) {
                case 1: {
                    msg.append(" contains non-transient values but has no corresponding assignment in rule ");
                    msg.append(this.getRule().getName());
                    break;
                }
                case 2: {
                    msg.append(" is not allowed to contain non-transient values. ");
                    msg.append("The object needs to be of type ");
                    msg.append(Joiner.on((String)" or ").join(Iterables.transform(this.requiredTypes, (Function)new Function<EClass, String>(){

                        public String apply(EClass from) {
                            return from.getName();
                        }
                    })));
                }
            }
            msg.append(".");
            this.appendConstraint(msg);
            return msg.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConcreteSyntaxFeatureDiagnostic
    extends AbstractConcreteSyntaxDiagnostic {
        protected EStructuralFeature feature;
        protected int min;
        protected int max;
        protected int actual;

        public ConcreteSyntaxFeatureDiagnostic(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, IAssignmentQuantityAllocator.IQuantities source, EStructuralFeature feature, int actual, int min, int max, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
            super(rule, source.getEObject(), involved);
            this.feature = feature;
            this.actual = actual;
            this.min = min;
            this.max = max;
        }

        public int getActual() {
            return this.actual;
        }

        public int getCode() {
            if (this.feature == null) {
                return 3;
            }
            if (this.feature.isMany()) {
                if (this.actual < this.min && this.actual > this.max) {
                    return 6;
                }
                if (this.actual < this.min) {
                    return 4;
                }
                if (this.actual > this.max) {
                    return 5;
                }
            } else {
                if (this.actual < this.min) {
                    return 8;
                }
                if (this.actual > this.max) {
                    return 7;
                }
            }
            return 0;
        }

        @Override
        public List<?> getData() {
            return Arrays.asList(this.source, this.feature);
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public int getMax() {
            return this.max;
        }

        public String getMessage() {
            StringBuffer msg = new StringBuffer();
            msg.append("Feature ");
            msg.append(this.source.eClass().getName());
            msg.append(".");
            msg.append(this.feature.getName());
            switch (this.getCode()) {
                case 6: {
                    msg.append(" holds " + this.actual + " non-transient value(s), but at least " + this.min + " and at most " + this.max + " are expected. ");
                    msg.append("Since this is impossible, please resolve other constraint-violations first. ");
                    msg.append("If that doesn't help, ask Chuck Norris for help or file a bug report.");
                    break;
                }
                case 4: {
                    msg.append(" holds " + this.actual + " non-transient value(s), ");
                    if (this.min == this.max) {
                        msg.append("but exactly " + this.min + " are required.");
                        break;
                    }
                    msg.append("but at least " + this.min + " are required.");
                    break;
                }
                case 5: {
                    msg.append(" holds " + this.actual + " non-transient value(s), ");
                    if (this.min == this.max) {
                        msg.append("but exactly " + this.max + " are required.");
                        break;
                    }
                    msg.append("but at most " + this.max + " are allowed.");
                    break;
                }
                case 8: {
                    msg.append(" must be set.");
                    break;
                }
                case 7: {
                    msg.append(" must not be set.");
                }
            }
            this.appendConstraint(msg);
            return msg.toString();
        }

        public int getMin() {
            return this.min;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConcreteSyntaxFeatureMissingDiagnostic
    extends AbstractConcreteSyntaxDiagnostic {
        protected IConcreteSyntaxConstraintProvider.ISyntaxConstraint element;

        public ConcreteSyntaxFeatureMissingDiagnostic(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, EObject source, IConcreteSyntaxConstraintProvider.ISyntaxConstraint element, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
            super(rule, source, involved);
            this.element = element;
        }

        public int getCode() {
            return 3;
        }

        public String getMessage() {
            StringBuffer msg = new StringBuffer();
            msg.append("A feature named '");
            msg.append(this.element.getAssignmentName());
            msg.append("' in ");
            msg.append(this.source.eClass().getName());
            msg.append(" is needed for serialization with rule ");
            msg.append(this.getRule().getName());
            msg.append(".");
            this.appendConstraint(msg);
            return msg.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConcreteSyntaxObjectDiagnostic
    extends AbstractConcreteSyntaxDiagnostic {
        public ConcreteSyntaxObjectDiagnostic(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, EObject source, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
            super(rule, source, involved);
        }

        public int getCode() {
            return 9;
        }

        public String getMessage() {
            StringBuffer msg = new StringBuffer();
            msg.append("An object of type ");
            msg.append(Joiner.on((String)" or ").join(Iterables.transform(this.getSemanticTypes(), (Function)new Function<EClass, String>(){

                public String apply(EClass from) {
                    return from.getName();
                }
            })));
            msg.append(" is needed instead of ");
            msg.append(this.source.eClass().getName());
            msg.append(" for serialization with rule ");
            msg.append(this.getRule().getName());
            msg.append(".");
            this.appendConstraint(msg);
            return msg.toString();
        }

        protected Set<EClass> getSemanticTypes() {
            HashSet types = Sets.newHashSet();
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint c : this.involved) {
                if (c.getSemanticTypesToCheck() == null) continue;
                types.addAll(c.getSemanticTypesToCheck());
            }
            return types;
        }
    }
}

