/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.Cfg;
import org.eclipse.xtext.util.formallang.CfgUtil;
import org.eclipse.xtext.util.formallang.FollowerFunction;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaFactory;
import org.eclipse.xtext.util.formallang.ProductionUtil;
import org.eclipse.xtext.util.formallang.Traverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdaUtil {
    @Inject
    protected NfaUtil nfaUtil = new NfaUtil();
    public final long UNREACHABLE = Long.MAX_VALUE;

    public <S, P> boolean canReach(Pda<S, P> pda, S state, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        return this.distanceTo(pda, Collections.singleton(state), stack, matches, canPass) != Long.MAX_VALUE;
    }

    public <S, P, T, D extends Pda<S, P>> D expand(Pda<S, P> pda, Function<S, Pda<S, P>> expand, Function<S, T> tokens, PdaFactory<D, S, P, T> fact) {
        Pda result = (Pda)fact.create(tokens.apply(pda.getStart()), tokens.apply(pda.getStop()));
        Identity<S> identity = new Identity<S>();
        IdentityHashMap idstates = Maps.newIdentityHashMap();
        HashMultimap followers = HashMultimap.create();
        for (Object s : this.nfaUtil.collect(pda)) {
            Object s_new = idstates.get(s);
            if (s_new != null) continue;
            Pda sub = (Pda)expand.apply(s);
            if (sub != null) {
                Object s_start = identity.get(fact.createPush(result, tokens.apply(s)));
                Object s_stop = identity.get(fact.createPop(result, tokens.apply(s)));
                idstates.put(s, s_start);
                idstates.put(sub.getStart(), s_start);
                idstates.put(sub.getStop(), s_stop);
                followers.putAll(s_start, sub.getFollowers(sub.getStart()));
                followers.putAll(s_stop, pda.getFollowers(s));
                for (Object f_old : this.nfaUtil.collect(sub)) {
                    Object f_new;
                    if (f_old == sub.getStart() || f_old == sub.getStop() || (f_new = idstates.get(f_old)) != null) continue;
                    f_new = this.clone(f_old, sub, result, tokens, fact, identity);
                    idstates.put(f_old, f_new);
                    followers.putAll(f_new, pda.getFollowers(f_old));
                }
                continue;
            }
            s_new = this.clone(s, pda, result, tokens, fact, identity);
            idstates.put(s, s_new);
            followers.putAll(s_new, pda.getFollowers(s));
        }
        for (Map.Entry entry : followers.asMap().entrySet()) {
            HashSet f = Sets.newHashSet();
            for (Object s : (Collection)entry.getValue()) {
                f.add(idstates.get(s));
            }
            fact.setFollowers(result, entry.getKey(), f);
        }
        return (D)result;
    }

    protected <S, P, T, D extends Pda<S, P>> S clone(S state, Pda<S, P> src, D target, Function<S, T> tokens, PdaFactory<D, S, P, T> fact, Identity<S> identity) {
        if (state == src.getStart()) {
            return (S)target.getStart();
        }
        if (state == src.getStop()) {
            return (S)target.getStop();
        }
        P push = src.getPush(state);
        if (push != null) {
            return identity.get(fact.createPush(target, tokens.apply(state)));
        }
        P pop = src.getPop(state);
        if (pop != null) {
            return identity.get(fact.createPop(target, tokens.apply(state)));
        }
        return identity.get(fact.createState(target, tokens.apply(state)));
    }

    public <S, P, E, T, D extends Pda<S, P>> D create(Cfg<E, T> cfg, FollowerFunction<E> ff, PdaFactory<D, S, P, ? super E> fact) {
        return this.create(cfg, ff, Functions.identity(), fact);
    }

    protected <S, P, E, T1, T2, D extends Pda<S, P>> void create(Cfg<E, T1> cfg, D pda, S state, E ele, Iterable<E> followerElements, boolean canEnter, FollowerFunction<E> ff, Function<E, T2> tokens, PdaFactory<D, S, P, ? super T2> fact, Map<E, S> states, Map<E, S> stops, Multimap<E, E> callers) {
        ArrayList followerStates = Lists.newArrayList();
        for (E fol : followerElements) {
            Object s;
            E e;
            if (fol == null) {
                E root = new ProductionUtil().getRoot(cfg, ele);
                if (root == cfg.getRoot()) {
                    followerStates.add(pda.getStop());
                }
                for (Object c : callers.get(root)) {
                    S s2 = stops.get(c);
                    if (s2 == null) {
                        s2 = fact.createPop(pda, tokens.apply(c));
                        stops.put(c, s2);
                        this.create(cfg, pda, s2, c, ff.getFollowers(c), false, ff, tokens, fact, states, stops, callers);
                    }
                    followerStates.add(s2);
                }
                continue;
            }
            if (canEnter && (e = cfg.getCall(fol)) != null) {
                s = states.get(fol);
                if (s == null) {
                    s = fact.createPush(pda, tokens.apply(fol));
                    states.put(fol, s);
                    this.create(cfg, pda, s, e, ff.getStarts(e), true, ff, tokens, fact, states, stops, callers);
                }
                followerStates.add(s);
                continue;
            }
            s = states.get(fol);
            if (s == null) {
                s = fact.createState(pda, tokens.apply(fol));
                states.put(fol, s);
                this.create(cfg, pda, s, fol, ff.getFollowers(fol), true, ff, tokens, fact, states, stops, callers);
            }
            followerStates.add(s);
        }
        fact.setFollowers(pda, state, followerStates);
    }

    public <S, P, E, T1, T2, D extends Pda<S, P>> D create(Cfg<E, T1> cfg, FollowerFunction<E> ff, Function<E, T2> element2token, PdaFactory<D, S, P, ? super T2> fact) {
        Pda pda = (Pda)fact.create(null, null);
        HashMap states = Maps.newHashMap();
        HashMap stops = Maps.newHashMap();
        Multimap<E, E> callers = new CfgUtil().getCallers(cfg);
        this.create(cfg, pda, pda.getStart(), cfg.getRoot(), ff.getStarts(cfg.getRoot()), true, ff, element2token, fact, states, stops, callers);
        return (D)pda;
    }

    protected <T> StackItem<T> createStack(Iterator<T> stack) {
        if (stack.hasNext()) {
            return new StackItem<T>(stack, stack.next());
        }
        return new StackItem<Object>(null, null);
    }

    public <S, P> long distanceTo(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.trace(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.size();
        }
        return Long.MAX_VALUE;
    }

    public <S, P, R, D extends Pda<S, P>> D filterEdges(Pda<S, P> pda, Traverser<? super Pda<S, P>, S, R> traverser, PdaFactory<D, S, P, S> factory) {
        HashStack<TraversalItem<S, Object>> trace = new HashStack<TraversalItem<S, Object>>();
        R previous = traverser.enter(pda, pda.getStart(), null);
        if (previous == null) {
            return (D)((Pda)factory.create(pda.getStart(), pda.getStop()));
        }
        Map distances = new NfaUtil().distanceToFinalStateMap(pda);
        NfaUtil.MappedComparator distanceComp = new NfaUtil.MappedComparator(distances);
        trace.push(this.newItem(pda, distanceComp, distances, pda.getStart(), previous));
        LinkedHashMultimap edges = LinkedHashMultimap.create();
        HashSet states = Sets.newHashSet();
        HashSet success = Sets.newHashSet();
        states.add(pda.getStart());
        states.add(pda.getStop());
        block0: while (!trace.isEmpty()) {
            TraversalItem current = (TraversalItem)trace.peek();
            while (current.followers.hasNext()) {
                Object next = current.followers.next();
                Object item = traverser.enter(pda, next, current.data);
                if (item == null) continue;
                if (next == pda.getStop() && traverser.isSolution(item) || success.contains(Tuples.create(next, item))) {
                    Object s = null;
                    for (TraversalItem traversalItem : trace) {
                        if (s != null) {
                            edges.put(s, traversalItem.state);
                        }
                        states.add(traversalItem.state);
                        success.add(Tuples.create(traversalItem.state, traversalItem.data));
                        s = traversalItem.state;
                    }
                    edges.put(s, next);
                    continue;
                }
                if (trace.push(this.newItem(pda, distanceComp, distances, next, item))) continue block0;
            }
            trace.pop();
        }
        Pda result = (Pda)factory.create(pda.getStart(), pda.getStop());
        HashMap old2new = Maps.newHashMap();
        old2new.put(pda.getStart(), result.getStart());
        old2new.put(pda.getStop(), result.getStop());
        for (Object old : states) {
            if (old == pda.getStart() || old == pda.getStop()) continue;
            if (pda.getPop(old) != null) {
                old2new.put(old, factory.createPop(result, old));
                continue;
            }
            if (pda.getPush(old) != null) {
                old2new.put(old, factory.createPush(result, old));
                continue;
            }
            old2new.put(old, factory.createState(result, old));
        }
        for (Object old : states) {
            ArrayList arrayList = Lists.newArrayList();
            for (Object f : edges.get(old)) {
                arrayList.add(old2new.get(f));
            }
            factory.setFollowers(result, old2new.get(old), arrayList);
        }
        return (D)result;
    }

    public <S, P> Nfa<S> filterUnambiguousPaths(Pda<S, P> pda) {
        HashMap followers = Maps.newHashMap();
        Map distanceMap = this.nfaUtil.distanceToFinalStateMap(pda);
        this.filterUnambiguousPaths(pda, pda.getStart(), distanceMap, followers);
        return new NfaUtil.NFAImpl(pda.getStart(), pda.getStop(), followers);
    }

    protected <S, P> void filterUnambiguousPaths(Pda<S, P> pda, S state, Map<S, Integer> dist, Map<S, List<S>> followers) {
        if (followers.containsKey(state)) {
            return;
        }
        ArrayList f = Lists.newArrayList(pda.getFollowers(state));
        if (f.size() <= 1) {
            followers.put(state, f);
            if (f.size() == 1) {
                this.filterUnambiguousPaths(pda, f.get(0), dist, followers);
            }
            return;
        }
        int closestDist = dist.get(f.get(0));
        Object closest = f.get(0);
        int i = 1;
        while (i < f.size()) {
            int d = dist.get(f.get(i));
            if (d < closestDist) {
                closestDist = d;
                closest = f.get(i);
            }
            ++i;
        }
        IsPop isPop = new IsPop(pda);
        Set closestPops = this.nfaUtil.findFirst(pda, Collections.singleton(closest), isPop);
        Iterator it = f.iterator();
        while (it.hasNext()) {
            Set nextPops;
            Object next = it.next();
            if (next == closest || closestPops.equals(nextPops = this.nfaUtil.findFirst(pda, Collections.singleton(next), isPop))) continue;
            it.remove();
        }
        followers.put(state, f);
        for (Object follower : f) {
            this.filterUnambiguousPaths(pda, follower, dist, followers);
        }
    }

    protected <S, R, P> TraversalItem<S, R> newItem(Pda<S, P> pda, NfaUtil.MappedComparator<S, Integer> comp, Map<S, Integer> distances, S next, R item) {
        ArrayList followers = Lists.newArrayList();
        for (S f : pda.getFollowers(next)) {
            if (!distances.containsKey(f)) continue;
            followers.add(f);
        }
        Collections.sort(followers, comp);
        return new TraversalItem<S, R>(next, followers, item);
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.trace(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterator<P> stack, Predicate<S> matches) {
        return this.shortestPathTo(pda, pda.getStart(), stack, matches, Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        return this.shortestPathTo(pda, pda.getStart(), stack, matches, canPass);
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterator<P> stack, S match) {
        return this.shortestPathTo(pda, pda.getStart(), stack, Predicates.equalTo(match), Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, S start, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.trace(pda, Collections.singleton(start), stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P> List<S> shortestPathToFinalState(Pda<S, P> pda, Iterator<P> stack) {
        return this.shortestPathTo(pda, pda.getStart(), stack, Predicates.equalTo(pda.getStop()), Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.traceToWithPruningStack(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, Iterator<P> stack, Predicate<S> matches) {
        return this.shortestStackpruningPathTo(pda, pda.getStart(), stack, matches, Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, Iterator<P> stack, S matches) {
        return this.shortestStackpruningPathTo(pda, pda.getStart(), stack, Predicates.equalTo(matches), Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, S start, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.traceToWithPruningStack(pda, Collections.singleton(start), stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    protected <S, P> TraceItem<S, P> trace(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        StackItem<P> stackItem = this.createStack(stack);
        ArrayList current = Lists.newArrayList();
        HashSet visited = Sets.newHashSet(starts);
        for (S start : starts) {
            current.add(new TraceItem<S, P>(null, start, stackItem));
        }
        int counter = stackItem.size() * -1;
        while (current.size() > 0 && counter < visited.size()) {
            ArrayList newCurrent = Lists.newArrayList();
            for (TraceItem trace : current) {
                for (Object follower : pda.getFollowers(trace.state)) {
                    if (matches.apply(follower)) {
                        return new TraceItem(trace, follower, trace.stackitem);
                    }
                    if (!canPass.apply(follower)) continue;
                    P push = pda.getPush(follower);
                    visited.add(follower);
                    if (push != null) {
                        StackItem pushed = trace.stackitem.push(push);
                        newCurrent.add(new TraceItem(trace, follower, pushed));
                        continue;
                    }
                    P pop = pda.getPop(follower);
                    if (pop != null) {
                        if (trace.stackitem == null || pop != trace.stackitem.peek()) continue;
                        StackItem popped = trace.stackitem.pop();
                        newCurrent.add(new TraceItem(trace, follower, popped));
                        continue;
                    }
                    newCurrent.add(new TraceItem(trace, follower, trace.stackitem));
                }
            }
            current = newCurrent;
            ++counter;
        }
        return null;
    }

    protected <S, P> TraceItem<S, P> traceToWithPruningStack(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        StackItem<P> stackItem = this.createStack(stack);
        ArrayList current = Lists.newArrayList();
        HashSet visited = Sets.newHashSet(starts);
        TraceItem result = null;
        for (S start : starts) {
            TraceItem<S, P> item = new TraceItem<S, P>(null, start, stackItem);
            current.add(item);
        }
        int counter = stackItem.size() * -1;
        while (current.size() > 0 && counter < visited.size()) {
            ArrayList newCurrent = Lists.newArrayList();
            for (TraceItem trace : current) {
                for (Object follower : pda.getFollowers(trace.state)) {
                    if (matches.apply(follower)) {
                        TraceItem found = new TraceItem(trace, follower, trace.stackitem);
                        if (found.stackitem == null) {
                            return found;
                        }
                        if (result == null || result.stackitem.size() > found.stackitem.size()) {
                            result = found;
                            counter = result.stackitem.size() * -1;
                        } else if (result.stackitem.size() == found.stackitem.size() && result.size() > found.size()) {
                            result = found;
                            counter = result.stackitem.size() * -1;
                        }
                    }
                    if (!canPass.apply(follower)) continue;
                    P push = pda.getPush(follower);
                    visited.add(follower);
                    if (push != null) {
                        StackItem pushed = trace.stackitem.push(push);
                        newCurrent.add(new TraceItem(trace, follower, pushed));
                        continue;
                    }
                    P pop = pda.getPop(follower);
                    if (pop != null) {
                        if (trace.stackitem == null || pop != trace.stackitem.peek()) continue;
                        StackItem popped = trace.stackitem.pop();
                        newCurrent.add(new TraceItem(trace, follower, popped));
                        continue;
                    }
                    newCurrent.add(new TraceItem(trace, follower, trace.stackitem));
                }
            }
            current = newCurrent;
            ++counter;
        }
        return result;
    }

    public <S, P, D extends Pda<S, P>> D filterOrphans(Pda<S, P> pda, PdaFactory<D, S, P, S> factory) {
        CyclicStackTraverser traverser = new CyclicStackTraverser();
        return this.filterEdges(pda, traverser, factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CyclicStackItem<T> {
        protected CyclicStackItem<T> parent;
        protected T item;

        public CyclicStackItem() {
            this.parent = null;
        }

        public CyclicStackItem(CyclicStackItem<T> parent, T item) {
            this.parent = parent;
            this.item = item;
        }

        public CyclicStackItem<T> push(T item) {
            int count = 0;
            CyclicStackItem<T> current = this;
            while (current != null) {
                if (current.item == item) {
                    ++count;
                }
                current = current.parent;
            }
            if (count >= 2) {
                return null;
            }
            return new CyclicStackItem<T>(this, item);
        }

        public CyclicStackItem<T> pop(T item) {
            if (this.parent == null || this.item != item) {
                return null;
            }
            return this.parent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CyclicStackTraverser<S, P>
    implements Traverser<Pda<S, P>, S, CyclicStackItem<P>> {
        @Override
        public CyclicStackItem<P> enter(Pda<S, P> pda, S state, CyclicStackItem<P> previous) {
            P item = pda.getPush(state);
            if (item != null) {
                return previous.push(item);
            }
            item = pda.getPop(state);
            if (item != null) {
                return previous.pop(item);
            }
            if (previous == null) {
                return new CyclicStackItem();
            }
            return previous;
        }

        @Override
        public boolean isSolution(CyclicStackItem<P> result) {
            return result.parent == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashStack<T>
    implements Iterable<T> {
        protected LinkedList<T> list = Lists.newLinkedList();
        protected Set<T> set = Sets.newLinkedHashSet();

        public boolean contains(Object value) {
            return this.set.contains(value);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        public T peek() {
            return this.list.getLast();
        }

        public T pop() {
            T result = this.list.getLast();
            this.list.removeLast();
            this.set.remove(result);
            return result;
        }

        public boolean push(T value) {
            boolean result = this.set.add(value);
            if (result) {
                this.list.addLast(value);
            }
            return result;
        }

        public String toString() {
            return this.list.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Identity<T> {
        protected Map<T, T> cache = Maps.newHashMap();

        protected Identity() {
        }

        public T get(T t) {
            T r = this.cache.get(t);
            if (r != null) {
                return r;
            }
            this.cache.put(t, t);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IsPop<S, P>
    implements Predicate<S> {
        private final Pda<S, P> pda;

        private IsPop(Pda<S, P> pda) {
            this.pda = pda;
        }

        public boolean apply(S input) {
            return this.pda.getPop(input) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StackItem<T> {
        protected StackItem<T> parent;
        protected Iterator<T> parentIt;
        protected T value;

        public StackItem(Iterator<T> parentIt, T value) {
            this.parentIt = parentIt;
            this.value = value;
        }

        public StackItem(StackItem<T> parent, T value) {
            this.parent = parent;
            this.value = value;
        }

        public T peek() {
            return this.value;
        }

        public StackItem<T> pop() {
            if (this.parent != null) {
                return this.parent;
            }
            if (this.parentIt != null && this.parentIt.hasNext()) {
                this.parent = new StackItem<T>(this.parentIt, this.parentIt.next());
                return this.parent;
            }
            return null;
        }

        public StackItem<T> push(T value) {
            return new StackItem<T>(this, value);
        }

        public int size() {
            int result = 0;
            StackItem<T> current = this;
            while (current != null) {
                ++result;
                current = current.pop();
            }
            return result;
        }

        public String toString() {
            ArrayList result = Lists.newArrayList();
            StackItem<T> current = this;
            while (current != null) {
                if (current.value != null) {
                    result.add(current.value.toString());
                }
                current = current.pop();
            }
            return Joiner.on((String)", ").join((Iterable)result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TraceItem<S, P> {
        protected TraceItem<S, P> parent;
        protected StackItem<P> stackitem;
        protected S state;

        public TraceItem(TraceItem<S, P> parent, S state, StackItem<P> stackitem) {
            this.parent = parent;
            this.state = state;
            this.stackitem = stackitem;
        }

        public List<S> asList() {
            ArrayList result = Lists.newArrayList();
            TraceItem<S, P> current = this;
            while (current != null) {
                result.add(current.state);
                current = current.parent;
            }
            Collections.reverse(result);
            return result;
        }

        public int size() {
            int result = 0;
            TraceItem<S, P> current = this;
            while (current != null) {
                ++result;
                current = current.parent;
            }
            return result;
        }

        public String toString() {
            return "States: " + this.asList() + " Stack: " + this.stackitem;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TraversalItem<S, R> {
        protected R data;
        protected Iterator<S> followers;
        protected S state;

        public TraversalItem(S state, Iterable<S> followers, R previous) {
            this.state = state;
            this.followers = followers.iterator();
            this.data = previous;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TraversalItem other = (TraversalItem)obj;
            return this.data.equals(other.data) && this.state.equals(other.state);
        }

        public int hashCode() {
            return this.data.hashCode() + this.state.hashCode() * 7;
        }

        public String toString() {
            return this.state.toString();
        }
    }
}

