/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.validation;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationTestHelper {
    public List<Issue> validate(EObject model) {
        IResourceValidator validator = ((XtextResource)model.eResource()).getResourceServiceProvider().getResourceValidator();
        return validator.validate(model.eResource(), CheckMode.ALL, CancelIndicator.NullImpl);
    }

    public void assertNoIssues(EObject model) {
        List<Issue> validate = this.validate(model);
        if (!Iterables.isEmpty(validate)) {
            Assert.fail((String)("Expected no issues, but got :" + this.getIssuesAsString(model, validate, new StringBuilder())));
        }
    }

    public void assertNoErrors(EObject model) {
        List<Issue> validate = this.validate(model);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                return Severity.ERROR == input.getSeverity();
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no errors, but got :" + this.getIssuesAsString(model, issues, new StringBuilder())));
        }
    }

    public void assertNoError(EObject model, final String issuecode) {
        List<Issue> validate = this.validate(model);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                return issuecode.equals(input.getCode());
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no error '" + issuecode + "' but got " + this.getIssuesAsString(model, issues, new StringBuilder())));
        }
    }

    public void assertNoErrors(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertNoIssues(model, objectType, code, Severity.ERROR, messageParts);
    }

    public void assertNoIssues(final EObject root, final EClass objectType) {
        List<Issue> validate = this.validate(root);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                EObject object = root.eResource().getEObject(input.getUriToProblem().fragment());
                return objectType.isInstance((Object)object);
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no error on instances of  '" + objectType.getName() + "' but got " + this.getIssuesAsString(root, issues, new StringBuilder())));
        }
    }

    public void assertNoIssue(final EObject root, final EClass objectType, final String issuecode) {
        List<Issue> validate = this.validate(root);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                EObject object;
                return issuecode.equals(input.getCode()) && objectType.isInstance((Object)(object = root.eResource().getEObject(input.getUriToProblem().fragment())));
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no error '" + issuecode + "' but got " + this.getIssuesAsString(root, issues, new StringBuilder())));
        }
    }

    public void assertError(EObject model, EClass objectType, String code, int offset, int length, String ... messageParts) {
        this.assertIssue(model, objectType, code, offset, length, Severity.ERROR, messageParts);
    }

    public void assertError(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertIssue(model, objectType, code, Severity.ERROR, messageParts);
    }

    public void assertIssue(EObject model, EClass objectType, String code, Severity severity, String ... messageParts) {
        this.assertIssue(model, objectType, code, -1, -1, severity, messageParts);
    }

    public void assertIssue(EObject model, EClass objectType, String code, int offset, int length, Severity severity, String ... messageParts) {
        List<Issue> allIssues = this.validate(model);
        Iterable<Issue> validate = this.matchIssues(model, objectType, code, offset, length, severity, allIssues, messageParts);
        if (Iterables.isEmpty(validate)) {
            StringBuilder message = new StringBuilder("Expected ").append((Object)severity).append(" '").append(code).append("' on ").append(objectType.getName()).append(" but got\n");
            this.getIssuesAsString(model, allIssues, message);
            Assert.assertEquals((Object)Joiner.on((char)'\n').join((Object[])messageParts), (Object)message.toString());
            Assert.fail((String)message.toString());
        }
    }

    public void assertNoIssues(EObject model, EClass objectType, String code, Severity severity, String ... messageParts) {
        this.assertNoIssues(model, objectType, code, -1, -1, severity, messageParts);
    }

    public void assertNoIssues(EObject model, EClass objectType, String code, int offset, int length, Severity severity, String ... messageParts) {
        List<Issue> allIssues = this.validate(model);
        Iterable<Issue> validate = this.matchIssues(model, objectType, code, offset, length, severity, allIssues, messageParts);
        if (!Iterables.isEmpty(validate)) {
            StringBuilder message = new StringBuilder("Expected no ").append((Object)severity).append(" '").append(code).append("' on ").append(objectType.getName()).append(" but got\n");
            this.getIssuesAsString(model, allIssues, message);
            Assert.assertEquals((Object)Joiner.on((char)'\n').join((Object[])messageParts), (Object)message.toString());
            Assert.fail((String)message.toString());
        }
    }

    protected Iterable<Issue> matchIssues(final EObject model, final EClass objectType, final String code, final int offset, final int length, final Severity severity, List<Issue> validate, final String ... messageParts) {
        return Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                EObject object;
                if (Strings.equal(input.getCode(), code) && input.getSeverity() == severity && (offset < 0 || offset == input.getOffset()) && (length < 0 || length == input.getLength()) && objectType.isInstance((Object)(object = model.eResource().getResourceSet().getEObject(input.getUriToProblem(), true)))) {
                    String[] stringArray = messageParts;
                    int n = messageParts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String messagePart = stringArray[n2];
                        if (!input.getMessage().toLowerCase().contains(messagePart.toLowerCase())) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    protected StringBuilder getIssuesAsString(EObject model, Iterable<Issue> issues, StringBuilder result) {
        for (Issue issue : issues) {
            EObject eObject = model.eResource().getResourceSet().getEObject(issue.getUriToProblem(), true);
            result.append((Object)issue.getSeverity()).append(" (").append(issue.getCode()).append(") '").append(issue.getMessage()).append("' on ").append(eObject.eClass().getName()).append("\n");
        }
        return result;
    }

    public void assertWarning(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertIssue(model, objectType, code, Severity.WARNING, messageParts);
    }

    public void assertNoWarnings(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertNoIssues(model, objectType, code, Severity.WARNING, messageParts);
    }

    public void assertWarning(EObject model, EClass objectType, String code, int offset, int length, String ... messageParts) {
        this.assertIssue(model, objectType, code, offset, length, Severity.WARNING, messageParts);
    }
}

