/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.services;

import com.google.inject.Singleton;
import java.util.regex.Pattern;
import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.nodemodel.INode;

@Singleton
public class Ecore2XtextTerminalConverters
extends DefaultTerminalConverters {
    private static final Pattern ID_PATTERN = Pattern.compile("\\p{Alpha}\\w*");

    @ValueConverter(rule="EString")
    public IValueConverter<String> EString() {
        return new AbstractNullSafeConverter<String>(){

            @Override
            protected String internalToValue(String string, INode node) {
                if (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) {
                    return Ecore2XtextTerminalConverters.this.STRING().toValue(string, node);
                }
                return Ecore2XtextTerminalConverters.this.ID().toValue(string, node);
            }

            @Override
            protected String internalToString(String value) {
                if (ID_PATTERN.matcher(value).matches()) {
                    return Ecore2XtextTerminalConverters.this.ID().toString(value);
                }
                return Ecore2XtextTerminalConverters.this.STRING().toString(value);
            }
        };
    }
}

