/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.debug.TextRegionAccessToString;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.SequentialRegionDiff;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedTextRegionAccessDiff;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedTextRegionAccessDiffAppender;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextRegionAccessBuildingSequencer;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.util.ITextRegion;

public class StringBasedTextRegionAccessDiffBuilder
implements ITextRegionDiffBuilder {
    private final ITextRegionAccess original;
    private List<RewriteAction> rewrites = Lists.newArrayList();

    public StringBasedTextRegionAccessDiffBuilder(ITextRegionAccess base) {
        this.original = base;
    }

    protected void addInsert(RewriteAction action) {
        int i = this.getActionAt(action.originalFirst, action.originalLast);
        if (i >= 0) {
            RewriteAction existing = this.rewrites.get(i);
            MultiInsertionRewriteAction comp = null;
            if (existing instanceof MultiInsertionRewriteAction) {
                comp = (MultiInsertionRewriteAction)existing;
            } else {
                comp = new MultiInsertionRewriteAction(action.originalFirst, action.originalFirst);
                comp.delegates.add(existing);
                this.rewrites.set(i, comp);
            }
            comp.delegates.add(action);
        } else {
            this.rewrites.add(action);
        }
    }

    protected void addRemoveAction(IHiddenRegion first, IHiddenRegion last, boolean del) {
        for (RewriteAction rw : this.rewrites) {
            if (rw.originalFirst == last) {
                rw.originalFirst = first;
                return;
            }
            if (rw.originalLast != first) continue;
            rw.originalLast = last;
            return;
        }
        this.rewrites.add(new RemoveRewriteAction(first, last, del));
    }

    protected void checkOriginal(ITextSegment segment) {
        Preconditions.checkNotNull((Object)segment);
        Preconditions.checkArgument((this.original == segment.getTextRegionAccess() ? 1 : 0) != 0);
    }

    @Override
    public StringBasedTextRegionAccessDiff create() {
        Collections.sort(this.rewrites);
        IEObjectRegion root = this.original.regionForRootEObject();
        ISequentialRegion last = root.getPreviousHiddenRegion();
        StringBasedTextRegionAccessDiff result = new StringBasedTextRegionAccessDiff(this.original);
        StringBasedTextRegionAccessDiffAppender appender = new StringBasedTextRegionAccessDiffAppender(result);
        for (RewriteAction next : this.rewrites) {
            if (!next.originalFirst.equals(last) && !next.originalFirst.equals(last.getPreviousSequentialRegion())) {
                appender.copyAndAppend(last, next.originalFirst.getPreviousSequentialRegion());
            }
            SequentialRegionDiff rewrite = next.apply(appender);
            result.append(rewrite);
            last = next.originalLast.getNextSequentialRegion();
        }
        if (last != null) {
            appender.copyAndAppend(last, root.getNextSequentialRegion());
        }
        appender.updateEObjectRegions();
        AbstractEObjectRegion newRoot = result.regionForEObject(root.getSemanticElement());
        result.setRootEObject(newRoot);
        return result;
    }

    protected int getActionAt(ISequentialRegion first, ISequentialRegion last) {
        for (int i = 0; i < this.rewrites.size(); ++i) {
            RewriteAction a = this.rewrites.get(i);
            if (a.originalFirst != first || a.originalLast != last) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ITextRegionAccess getOriginalTextRegionAccess() {
        return this.original;
    }

    @Override
    public boolean isModified(ITextRegion region) {
        int offset = region.getOffset();
        int endOffset = offset + region.getLength();
        for (RewriteAction action : this.rewrites) {
            int rwOffset = action.originalFirst.getOffset();
            int rwEndOffset = action.originalLast.getEndOffset();
            if (rwOffset <= offset && offset < rwEndOffset) {
                return true;
            }
            if (rwOffset >= endOffset || endOffset > rwEndOffset) continue;
            return true;
        }
        return false;
    }

    @Override
    public void move(IHiddenRegion insertAt, IHiddenRegion substituteFirst, IHiddenRegion substituteLast) {
        this.addRemoveAction(substituteFirst, substituteLast, false);
        this.replace(insertAt, insertAt, substituteFirst, substituteLast);
    }

    @Override
    public void remove(IHiddenRegion first, IHiddenRegion last) {
        this.checkOriginal(first);
        this.checkOriginal(last);
        this.addRemoveAction(first, last, true);
    }

    @Override
    public void remove(ISemanticRegion region) {
        this.remove(region.getPreviousHiddenRegion(), region.getNextHiddenRegion());
    }

    @Override
    public void replace(IHiddenRegion originalFirst, IHiddenRegion originalLast, IHiddenRegion modifiedFirst, IHiddenRegion modifiedLast) {
        this.checkOriginal(originalFirst);
        this.checkOriginal(originalLast);
        this.addInsert(new ReplaceRewriteAction(originalFirst, originalLast, modifiedFirst, modifiedLast));
    }

    @Override
    public void replace(IHiddenRegion originalFirst, IHiddenRegion originalLast, ITextRegionAccess acc) {
        this.checkOriginal(originalFirst);
        this.checkOriginal(originalLast);
        IEObjectRegion substituteRoot = acc.regionForRootEObject();
        IHiddenRegion substituteFirst = substituteRoot.getPreviousHiddenRegion();
        IHiddenRegion substituteLast = substituteRoot.getNextHiddenRegion();
        this.replace(originalFirst, originalLast, substituteFirst, substituteLast);
    }

    @Override
    public void replace(ISemanticRegion region, String newText) {
        RewriteAction existing;
        Preconditions.checkNotNull((Object)newText);
        this.checkOriginal(region);
        int i = this.getActionAt(region, region);
        if (i >= 0 && (existing = this.rewrites.get(i)) instanceof TextRewriteAction) {
            ((TextRewriteAction)existing).text = newText;
            return;
        }
        this.rewrites.add(new TextRewriteAction(region, newText));
    }

    @Override
    public ISequenceAcceptor replaceSequence(IHiddenRegion originalFirst, IHiddenRegion originalLast, ISerializationContext ctx, EObject root) {
        this.checkOriginal(originalFirst);
        this.checkOriginal(originalLast);
        TextRegionAccessBuildingSequencer sequenceAcceptor = new TextRegionAccessBuildingSequencer();
        this.addInsert(new SequenceRewriteAction(originalFirst, originalLast, sequenceAcceptor));
        return sequenceAcceptor.withRoot(ctx, root);
    }

    public String toString() {
        try {
            StringBasedTextRegionAccessDiff regions = this.create();
            return new TextRegionAccessToString().withRegionAccess(regions).toString();
        }
        catch (Throwable t) {
            return t.getMessage() + "\n" + Throwables.getStackTraceAsString((Throwable)t);
        }
    }

    protected static class TextRewriteAction
    extends RewriteAction {
        private String text;

        public TextRewriteAction(ISemanticRegion region, String text) {
            super(region, region);
            this.text = text;
        }

        @Override
        public SequentialRegionDiff apply(StringBasedTextRegionAccessDiffAppender appender) {
            ISemanticRegion region = appender.copyAndAppend((ISemanticRegion)this.originalFirst, this.text);
            return new SequentialRegionDiff(this.originalFirst, this.originalLast, region, region);
        }
    }

    protected static class SequenceRewriteAction
    extends RewriteAction {
        private final TextRegionAccessBuildingSequencer sequencer;

        public SequenceRewriteAction(IHiddenRegion originalFirst, IHiddenRegion originalLast, TextRegionAccessBuildingSequencer sequencer) {
            super(originalFirst, originalLast);
            this.sequencer = sequencer;
        }

        @Override
        public SequentialRegionDiff apply(StringBasedTextRegionAccessDiffAppender appender) {
            StringBasedRegionAccess textRegionAccess = this.sequencer.getRegionAccess();
            IEObjectRegion substituteRoot = textRegionAccess.regionForRootEObject();
            IHiddenRegion substituteFirst = substituteRoot.getPreviousHiddenRegion();
            IHiddenRegion substituteLast = substituteRoot.getNextHiddenRegion();
            SequentialRegionDiff result = appender.copyAndAppend((IHiddenRegion)this.originalFirst, (IHiddenRegion)this.originalLast, substituteFirst, substituteLast);
            return result;
        }
    }

    public static abstract class RewriteAction
    implements Comparable<RewriteAction> {
        protected ISequentialRegion originalFirst;
        protected ISequentialRegion originalLast;

        public RewriteAction(ISequentialRegion originalFirst, ISequentialRegion originalLast) {
            this.originalFirst = originalFirst;
            this.originalLast = originalLast;
        }

        public abstract SequentialRegionDiff apply(StringBasedTextRegionAccessDiffAppender var1);

        @Override
        public int compareTo(RewriteAction o) {
            return this.originalFirst.compareTo(o.originalFirst);
        }
    }

    protected static class ReplaceRewriteAction
    extends RewriteAction {
        private final IHiddenRegion modifiedFirst;
        private final IHiddenRegion modifiedLast;

        public ReplaceRewriteAction(IHiddenRegion originalFirst, IHiddenRegion originalLast, IHiddenRegion modifiedFirst, IHiddenRegion modifiedLast) {
            super(originalFirst, originalLast);
            this.modifiedFirst = modifiedFirst;
            this.modifiedLast = modifiedLast;
        }

        @Override
        public SequentialRegionDiff apply(StringBasedTextRegionAccessDiffAppender appender) {
            SequentialRegionDiff result = appender.copyAndAppend((IHiddenRegion)this.originalFirst, (IHiddenRegion)this.originalLast, this.modifiedFirst, this.modifiedLast);
            return result;
        }
    }

    protected static class RemoveRewriteAction
    extends RewriteAction {
        private boolean delete;

        public RemoveRewriteAction(IHiddenRegion originalFirst, IHiddenRegion originalLast, boolean delete) {
            super(originalFirst, originalLast);
            this.delete = delete;
        }

        @Override
        public SequentialRegionDiff apply(StringBasedTextRegionAccessDiffAppender appender) {
            return appender.copySurroundingHidden((IHiddenRegion)this.originalFirst, (IHiddenRegion)this.originalLast, this.delete);
        }
    }

    protected static class MultiInsertionRewriteAction
    extends RewriteAction {
        private final List<RewriteAction> delegates = Lists.newArrayList();

        public MultiInsertionRewriteAction(ISequentialRegion originalFirst, ISequentialRegion originalLast) {
            super(originalFirst, originalLast);
        }

        @Override
        public SequentialRegionDiff apply(StringBasedTextRegionAccessDiffAppender appender) {
            ISequentialRegion substituteFirst = null;
            ISequentialRegion substituteLast = null;
            for (int i = 0; i < this.delegates.size(); ++i) {
                SequentialRegionDiff rewrite = this.delegates.get(i).apply(appender);
                if (i == 0) {
                    substituteFirst = rewrite.getModifiedFirstRegion();
                }
                if (i != this.delegates.size() - 1) continue;
                substituteLast = rewrite.getModifiedLastRegion();
            }
            return new SequentialRegionDiff(this.originalFirst, this.originalLast, substituteFirst, substituteLast);
        }
    }
}

