/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPartMerger;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.SequentialRegionDiff;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedTextRegionAccessDiff;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringComment;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringSemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringWhitespace;

public class StringBasedTextRegionAccessDiffAppender {
    private StringBasedTextRegionAccessDiff access;
    private IHiddenRegionPartMerger hiddenRegionMerger;
    private ISequentialRegion last;

    public StringBasedTextRegionAccessDiffAppender(StringBasedTextRegionAccessDiff access) {
        this.access = access;
        this.hiddenRegionMerger = access.getResource().getResourceServiceProvider().get(IHiddenRegionPartMerger.class);
    }

    protected StringHiddenRegion appendHiddenRegion(boolean undefined) {
        if (this.last instanceof StringHiddenRegion) {
            StringHiddenRegion result;
            result.setUndefined((result = (StringHiddenRegion)this.last).isUndefined() || undefined);
            return result;
        }
        StringSemanticRegion previous = (StringSemanticRegion)this.last;
        StringHiddenRegion region = new StringHiddenRegion(this.access);
        if (previous != null) {
            previous.setTrailingHiddenRegion(region);
            region.setPrevious(previous);
        }
        region.setUndefined(undefined);
        this.last = region;
        return region;
    }

    protected IHiddenRegion copyAndAppend(IHiddenRegion source) {
        ISequentialRegion last2 = this.last;
        StringHiddenRegion region = this.appendHiddenRegion(source.isUndefined());
        List<IHiddenRegionPart> parts = region == last2 ? this.hiddenRegionMerger.merge(this.access.getOriginalTextRegionAccess(), region, source, false) : source.getParts();
        this.copyHiddenRegionParts(region, parts);
        return region;
    }

    protected IHiddenRegion copyAndAppend(IHiddenRegion region1, IHiddenRegion region2) {
        StringHiddenRegion region = this.appendHiddenRegion(region1.isUndefined() || region2.isUndefined());
        ITextRegionAccess original = this.access.getOriginalTextRegionAccess();
        List<IHiddenRegionPart> merged = this.hiddenRegionMerger.merge(original, region1, region2, false);
        this.copyHiddenRegionParts(region, merged);
        return region;
    }

    public SequentialRegionDiff copyAndAppend(IHiddenRegion originalFirst, IHiddenRegion originalLast, IHiddenRegion substituteFirst, IHiddenRegion substituteLast) {
        if (substituteFirst == substituteLast) {
            return this.copySurroundingHidden(originalFirst, originalLast, true);
        }
        IHiddenRegion first = this.copyAndAppend(originalFirst, substituteFirst);
        ISemanticRegion firstSem = substituteFirst.getNextSemanticRegion();
        ISemanticRegion lastSem = substituteLast.getPreviousSemanticRegion();
        this.copyAndAppend((ISequentialRegion)firstSem, lastSem);
        IHiddenRegion last = this.copyAndAppend(substituteLast, originalLast);
        return new SequentialRegionDiff(originalFirst, originalLast, first, last);
    }

    public ISemanticRegion copyAndAppend(ISemanticRegion source, String text) {
        if (this.last instanceof StringSemanticRegion) {
            this.appendHiddenRegion(true);
        }
        EObject semanticElement = source.getSemanticElement();
        AbstractEObjectRegion region = this.getOrCreateEObjectRegion(semanticElement, source.getEObjectRegion());
        int offset = this.access.append(text);
        AbstractElement grammar = (AbstractElement)source.getGrammarElement();
        StringHiddenRegion previous = (StringHiddenRegion)this.last;
        StringSemanticRegion result = new StringSemanticRegion(this.access, region, grammar, offset, text.length());
        region.addChild(result);
        previous.setNext(result);
        result.setLeadingHiddenRegion(previous);
        this.last = result;
        return result;
    }

    protected ISequentialRegion copyAndAppend(ISequentialRegion first, ISequentialRegion last) {
        ISequentialRegion result;
        block5: {
            ISequentialRegion current = first;
            result = null;
            do {
                if (current instanceof IHiddenRegion) {
                    this.copyAndAppend((IHiddenRegion)current);
                } else if (current instanceof ISemanticRegion) {
                    this.copyAndAppend((ISemanticRegion)current, current.getText());
                }
                if (result == null) {
                    result = this.last;
                }
                if (current == last) break block5;
            } while ((current = current.getNextSequentialRegion()) != null);
            throw new IllegalStateException("last didn't match");
        }
        return result;
    }

    protected void copyHiddenRegionParts(StringHiddenRegion region, Iterable<IHiddenRegionPart> parts) {
        for (IHiddenRegionPart part : parts) {
            AbstractRule grammarElement;
            String text = part.getText();
            int offset = this.access.append(text);
            if (part instanceof IComment) {
                IComment comment = (IComment)part;
                grammarElement = (AbstractRule)comment.getGrammarElement();
                StringComment newComment = new StringComment(region, grammarElement, offset, text.length());
                region.addPart(newComment);
                continue;
            }
            if (!(part instanceof IWhitespace)) continue;
            IWhitespace ws = (IWhitespace)part;
            grammarElement = (AbstractRule)ws.getGrammarElement();
            StringWhitespace newWs = new StringWhitespace(region, grammarElement, offset, text.length());
            region.addPart(newWs);
        }
    }

    public SequentialRegionDiff copySurroundingHidden(IHiddenRegion originalFirst, IHiddenRegion originalLast, boolean delete) {
        boolean firstHidden = originalFirst instanceof IHiddenRegion;
        boolean lastHidden = originalLast instanceof IHiddenRegion;
        if (firstHidden && lastHidden) {
            IHiddenRegion hiddenFirst = originalFirst;
            IHiddenRegion hiddenLast = originalLast;
            StringHiddenRegion merged = this.appendHiddenRegion(hiddenFirst.isUndefined() || hiddenLast.isUndefined());
            ITextRegionAccess original = this.access.getOriginalTextRegionAccess();
            List<IHiddenRegionPart> parts = this.hiddenRegionMerger.merge(original, hiddenFirst, hiddenLast, delete);
            this.copyHiddenRegionParts(merged, parts);
            return new SequentialRegionDiff(originalFirst, originalLast, merged, merged);
        }
        StringHiddenRegion inserted = null;
        if (originalFirst == null) {
            if (!lastHidden) {
                inserted = this.appendHiddenRegion(true);
            }
        } else if (originalLast == null) {
            if (!firstHidden) {
                inserted = this.appendHiddenRegion(true);
            }
        } else if (!firstHidden && !lastHidden) {
            inserted = this.appendHiddenRegion(true);
        }
        return new SequentialRegionDiff(originalFirst, originalLast, inserted, inserted);
    }

    public IHiddenRegionPartMerger getHiddenRegionMerger() {
        return this.hiddenRegionMerger;
    }

    public StringBasedTextRegionAccessDiff getRectionAccessDiff() {
        return this.access;
    }

    protected void updateEObjectRegions() {
        AbstractEObjectRegion eobjRegion;
        EObject eobj;
        ISemanticRegion sem;
        ISemanticRegion current = this.last.getPreviousSemanticRegion();
        while (true) {
            sem = current;
            IHiddenRegion nextHiddenRegion = sem.getNextHiddenRegion();
            for (eobj = sem.getSemanticElement(); eobj != null && (eobjRegion = this.getOrCreateEObjectRegion(eobj, null)).getNextHiddenRegion() == null; eobj = eobj.eContainer()) {
                eobjRegion.setTrailingHiddenRegion(nextHiddenRegion);
            }
            ISemanticRegion prev = sem.getPreviousSemanticRegion();
            if (prev == null) break;
            current = prev;
        }
        while (true) {
            sem = current;
            IHiddenRegion previousHiddenRegion = sem.getPreviousHiddenRegion();
            for (eobj = sem.getSemanticElement(); eobj != null && (eobjRegion = this.access.regionForEObject(eobj)).getPreviousHiddenRegion() == null; eobj = eobj.eContainer()) {
                eobjRegion.setLeadingHiddenRegion(previousHiddenRegion);
            }
            ISemanticRegion next = sem.getNextSemanticRegion();
            if (next == null) break;
            current = next;
        }
    }

    protected AbstractEObjectRegion getOrCreateEObjectRegion(EObject eobj, IEObjectRegion original) {
        AbstractEObjectRegion eobjRegion = this.access.regionForEObject(eobj);
        if (eobjRegion == null) {
            if (original == null) {
                original = this.access.getOriginalTextRegionAccess().regionForEObject(eobj);
            }
            if (original != null) {
                eobjRegion = new StringEObjectRegion(this.access, original.getGrammarElement(), eobj);
                this.access.add(eobjRegion);
                AbstractEObjectRegion parent = this.getOrCreateEObjectRegion(eobj.eContainer(), null);
                if (parent != null) {
                    parent.addChild(eobjRegion);
                }
            }
        }
        return eobjRegion;
    }
}

