/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.formatting2.IMerger;
import org.eclipse.xtext.formatting2.internal.ConflictingRegionsException;
import org.eclipse.xtext.formatting2.internal.RegionComparator;
import org.eclipse.xtext.formatting2.internal.RegionTraceMissingException;
import org.eclipse.xtext.formatting2.internal.TextSegmentSet;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;

public class ArrayListTextSegmentSet<T>
extends TextSegmentSet<T> {
    private final List<T> contents = Lists.newArrayList();

    public ArrayListTextSegmentSet(Function<? super T, ? extends ITextSegment> region, Function<? super T, String> title) {
        super(region, title);
    }

    public ArrayListTextSegmentSet(Function<? super T, ? extends ITextSegment> region, Function<? super T, String> title, boolean trace) {
        super(region, title, trace);
    }

    @Override
    public void add(T segment, IMerger<T> merger) throws ConflictingRegionsException, RegionTraceMissingException {
        Preconditions.checkNotNull(segment);
        this.trace(segment);
        if (this.contents.isEmpty()) {
            this.contents.add(segment);
        } else {
            int searchResult = Collections.binarySearch(this.contents, segment, new RegionComparator(this.getRegionAccess()));
            if (searchResult >= 0) {
                this.replaceExistingEntry(segment, searchResult, merger);
            } else {
                this.insertAtIndex(segment, -searchResult - 1, merger);
            }
        }
    }

    @Override
    public T get(T segment) {
        int searchResult = Collections.binarySearch(this.contents, segment, new RegionComparator(this.getRegionAccess()));
        return searchResult >= 0 ? (T)this.contents.get(searchResult) : null;
    }

    protected void insertAtIndex(T segment, int newIndex, IMerger<T> merger) throws ConflictingRegionsException, RegionTraceMissingException {
        T item;
        T item2;
        ArrayList conflicting = null;
        int low = newIndex;
        while (--low >= 0 && this.isConflict(item2 = this.contents.get(low), segment)) {
            if (conflicting == null) {
                conflicting = Lists.newArrayList();
            }
            conflicting.add(item2);
        }
        int high = newIndex - 1;
        while (++high < this.contents.size() && this.isConflict(item = this.contents.get(high), segment)) {
            if (conflicting == null) {
                conflicting = Lists.newArrayList();
            }
            conflicting.add(item);
        }
        if (conflicting == null) {
            this.trace(segment);
            this.contents.add(newIndex, segment);
        } else {
            conflicting.add(0, segment);
            try {
                Object merged;
                Object e = merged = merger != null ? (Object)merger.merge(conflicting) : null;
                if (merged != null) {
                    for (int i = high - 1; i > low; --i) {
                        this.contents.remove(i);
                    }
                    this.trace(merged);
                    this.contents.add(low + 1, merged);
                } else {
                    int i;
                    int segmentLengh = this.getRegion(segment).getLength();
                    int totalLength = 0;
                    for (i = 1; i < conflicting.size(); ++i) {
                        totalLength += this.getRegion(conflicting.get(i)).getLength();
                    }
                    if (segmentLengh >= totalLength) {
                        for (i = high - 1; i > low; --i) {
                            this.contents.remove(i);
                        }
                    }
                    if (segmentLengh > totalLength) {
                        this.trace(segment);
                        this.contents.add(low + 1, segment);
                    }
                    this.handleConflict(conflicting, null);
                }
            }
            catch (ConflictingRegionsException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleConflict(conflicting, e);
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        return Iterables.unmodifiableIterable(this.contents).iterator();
    }

    @Override
    public Iterator<T> iteratorAfter(T segment) {
        final int searchResult = 1 + Collections.binarySearch(this.contents, segment, new RegionComparator(this.getRegionAccess()));
        if (searchResult < 1) {
            return Collections.emptyIterator();
        }
        return new AbstractIterator<T>(){
            private int index;
            {
                this.index = searchResult;
            }

            protected T computeNext() {
                if (this.index >= ArrayListTextSegmentSet.this.contents.size()) {
                    return this.endOfData();
                }
                return ArrayListTextSegmentSet.this.contents.get(this.index++);
            }
        };
    }

    protected void replaceExistingEntry(T segment, int index, IMerger<T> merger) throws ConflictingRegionsException, RegionTraceMissingException {
        T existing = this.contents.get(index);
        ImmutableList conflicting = ImmutableList.of(segment, existing);
        try {
            Object merged;
            Object e = merged = merger != null ? (Object)merger.merge((List<T>)conflicting) : null;
            if (merged != null) {
                this.trace(merged);
                this.contents.set(index, merged);
            } else {
                this.contents.remove(index);
                this.handleConflict(conflicting, (Exception)null);
            }
        }
        catch (ConflictingRegionsException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleConflict(conflicting, e);
        }
    }
}

