/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.workspace;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.FileSourceFolder;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.workspace.SingleProjectWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FileProjectConfig
implements IProjectConfig {
    private final URI path;
    private final String name;
    private final Set<FileSourceFolder> sourceFolders = CollectionLiterals.newHashSet((Object[])new FileSourceFolder[0]);

    public FileProjectConfig(URI path) {
        this(path, path.lastSegment());
    }

    public FileProjectConfig(URI path, String name) {
        this.path = path;
        this.name = name;
    }

    public FileProjectConfig(File root, String name) {
        this(UriUtil.createFolderURI((File)root), name);
    }

    public FileProjectConfig(File root) {
        this(UriUtil.createFolderURI((File)root), root.getName());
    }

    public FileSourceFolder addSourceFolder(String relativePath) {
        FileSourceFolder _xblockexpression = null;
        FileSourceFolder sourceFolder = new FileSourceFolder(this, relativePath);
        this.sourceFolders.add(sourceFolder);
        _xblockexpression = sourceFolder;
        return _xblockexpression;
    }

    @Override
    public FileSourceFolder findSourceFolderContaining(URI member) {
        Functions.Function1 _function = source -> {
            URI _path = source.getPath();
            return UriUtil.isPrefixOf((URI)_path, (URI)member);
        };
        return (FileSourceFolder)IterableExtensions.findFirst(this.sourceFolders, (Functions.Function1)_function);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getPath() {
        return this.path;
    }

    public Set<FileSourceFolder> getSourceFolders() {
        return this.sourceFolders;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileProjectConfig) {
            return Objects.equal((Object)this.path, (Object)((FileProjectConfig)obj).path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Project ");
        _builder.append(this.name, "");
        _builder.append(" (");
        _builder.append((Object)this.path, "");
        _builder.append(")");
        return _builder.toString();
    }

    @Override
    public IWorkspaceConfig getWorkspaceConfig() {
        return new SingleProjectWorkspaceConfig(this);
    }
}

