/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.tasks.ITaskParser;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.tasks.TaskTags;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DefaultTaskParser
implements ITaskParser {
    @Override
    public List<Task> parseTasks(String source, TaskTags taskTags) {
        ArrayList _xblockexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)taskTags);
        if (_isEmpty) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Task[0]));
        }
        Function _function = it -> {
            String _name = it.getName();
            return _name.toLowerCase();
        };
        ImmutableMap taskTagsByName = Maps.uniqueIndex((Iterable)taskTags, (Function)_function);
        Pattern _pattern = this.toPattern(taskTags);
        Matcher matcher = _pattern.matcher(source);
        ArrayList tasks = CollectionLiterals.newArrayList((Object[])new Task[0]);
        int prevLine = 1;
        int prevOffset = 0;
        while (matcher.find()) {
            int _offset_1;
            int _lineNumber;
            Task task = new Task();
            String _group = matcher.group(2);
            String _lowerCase = _group.toLowerCase();
            TaskTag _get = (TaskTag)taskTagsByName.get((Object)_lowerCase);
            task.setTag(_get);
            String _group_1 = matcher.group(3);
            task.setDescription(_group_1);
            int _start = matcher.start(2);
            task.setOffset(_start);
            int _offset = task.getOffset();
            int _countLineBreaks = Strings.countLineBreaks((CharSequence)source, (int)prevOffset, (int)_offset);
            int _plus = _countLineBreaks + prevLine;
            task.setLineNumber(_plus);
            prevLine = _lineNumber = task.getLineNumber();
            prevOffset = _offset_1 = task.getOffset();
            tasks.add(task);
        }
        _xblockexpression = tasks;
        return _xblockexpression;
    }

    protected Pattern toPattern(TaskTags taskTags) {
        boolean _not;
        Pattern _xblockexpression = null;
        int flags = 8;
        boolean _isCaseSensitive = taskTags.isCaseSensitive();
        boolean bl = _not = !_isCaseSensitive;
        if (_not) {
            flags = flags | 2 | 0x40;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("^.*((");
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Pattern.quote(_name);
        };
        Iterable _map = IterableExtensions.map((Iterable)taskTags, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"|");
        _builder.append(_join, "");
        _builder.append(")(.*)?)$");
        _xblockexpression = Pattern.compile(_builder.toString(), flags);
        return _xblockexpression;
    }
}

