/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescriptionProvider;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializationExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class SerializableResourceDescription
extends AbstractResourceDescription
implements Externalizable {
    private List<SerializableEObjectDescription> descriptions = CollectionLiterals.emptyList();
    private List<SerializableReferenceDescription> references = CollectionLiterals.emptyList();
    private List<QualifiedName> importedNames = CollectionLiterals.emptyList();
    private URI uRI;

    public static SerializableResourceDescription createCopy(IResourceDescription desc) {
        SerializableResourceDescription _serializableResourceDescription = new SerializableResourceDescription();
        Procedures.Procedure1 _function = it -> {
            ArrayList _newArrayList;
            List _list_1;
            List _list;
            URI _uRI = desc.getURI();
            it.setURI(_uRI);
            Iterable<IEObjectDescription> _exportedObjects = desc.getExportedObjects();
            Functions.Function1 _function_1 = it_1 -> SerializableResourceDescription.createCopy(it_1);
            Iterable _map = IterableExtensions.map(_exportedObjects, (Functions.Function1)_function_1);
            it.descriptions = _list = IterableExtensions.toList((Iterable)_map);
            Iterable<IReferenceDescription> _referenceDescriptions = desc.getReferenceDescriptions();
            Functions.Function1 _function_2 = it_1 -> SerializableResourceDescription.createCopy(it_1);
            Iterable _map_1 = IterableExtensions.map(_referenceDescriptions, (Functions.Function1)_function_2);
            it.references = _list_1 = IterableExtensions.toList((Iterable)_map_1);
            Iterable<QualifiedName> _importedNames = desc.getImportedNames();
            it.importedNames = _newArrayList = CollectionLiterals.newArrayList((Object[])((QualifiedName[])Conversions.unwrapArray(_importedNames, QualifiedName.class)));
        };
        return (SerializableResourceDescription)ObjectExtensions.operator_doubleArrow((Object)_serializableResourceDescription, (Procedures.Procedure1)_function);
    }

    private static SerializableEObjectDescription createCopy(IEObjectDescription desc) {
        if (desc instanceof SerializableEObjectDescriptionProvider) {
            return ((SerializableEObjectDescriptionProvider)((Object)desc)).toSerializableEObjectDescription();
        }
        SerializableEObjectDescription _serializableEObjectDescription = new SerializableEObjectDescription();
        Procedures.Procedure1 _function = it -> {
            String[] _userDataKeys_1;
            QualifiedName _qualifiedName;
            EClass _eClass = desc.getEClass();
            it.setEClass(_eClass);
            URI _eObjectURI = desc.getEObjectURI();
            it.setEObjectURI(_eObjectURI);
            it.qualifiedName = _qualifiedName = desc.getQualifiedName();
            String[] _userDataKeys = desc.getUserDataKeys();
            int _size = ((List)Conversions.doWrapArray((Object)_userDataKeys)).size();
            HashMap _hashMap = new HashMap(_size);
            it.userData = _hashMap;
            for (String key : _userDataKeys_1 = desc.getUserDataKeys()) {
                String _userData = desc.getUserData(key);
                it.userData.put(key, _userData);
            }
        };
        return (SerializableEObjectDescription)ObjectExtensions.operator_doubleArrow((Object)_serializableEObjectDescription, (Procedures.Procedure1)_function);
    }

    private static SerializableReferenceDescription createCopy(IReferenceDescription desc) {
        SerializableReferenceDescription _serializableReferenceDescription = new SerializableReferenceDescription();
        Procedures.Procedure1 _function = it -> {
            URI _sourceEObjectUri = desc.getSourceEObjectUri();
            it.setSourceEObjectUri(_sourceEObjectUri);
            URI _targetEObjectUri = desc.getTargetEObjectUri();
            it.setTargetEObjectUri(_targetEObjectUri);
            EReference _eReference = desc.getEReference();
            it.setEReference(_eReference);
            int _indexInList = desc.getIndexInList();
            it.setIndexInList(_indexInList);
            URI _containerEObjectURI = desc.getContainerEObjectURI();
            it.setContainerEObjectURI(_containerEObjectURI);
        };
        return (SerializableReferenceDescription)ObjectExtensions.operator_doubleArrow((Object)_serializableReferenceDescription, (Procedures.Procedure1)_function);
    }

    public void updateResourceURI(URI uri) {
        for (SerializableReferenceDescription ref : this.references) {
            ref.updateResourceURI(uri, this.uRI);
        }
        for (SerializableEObjectDescription desc : this.descriptions) {
            desc.updateResourceURI(uri);
        }
        this.uRI = uri;
    }

    @Override
    protected List<IEObjectDescription> computeExportedObjects() {
        return this.descriptions;
    }

    @Override
    public Iterable<QualifiedName> getImportedNames() {
        return this.importedNames;
    }

    @Override
    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return this.references;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        URI _readURI = SerializationExtensions.readURI(in);
        this.setURI(_readURI);
        int descriptionsSize = in.readInt();
        ArrayList<SerializableEObjectDescription> _arrayList = new ArrayList<SerializableEObjectDescription>(descriptionsSize);
        this.descriptions = _arrayList;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, descriptionsSize, true);
        for (Integer i : _doubleDotLessThan) {
            SerializableEObjectDescription _readCastedObject = (SerializableEObjectDescription)SerializationExtensions.readCastedObject(in);
            this.descriptions.add(_readCastedObject);
        }
        int referencesSize = in.readInt();
        ArrayList<SerializableReferenceDescription> _arrayList_1 = new ArrayList<SerializableReferenceDescription>(referencesSize);
        this.references = _arrayList_1;
        ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, referencesSize, true);
        for (Integer i_1 : _doubleDotLessThan_1) {
            SerializableReferenceDescription _readCastedObject_1 = (SerializableReferenceDescription)SerializationExtensions.readCastedObject(in);
            this.references.add(_readCastedObject_1);
        }
        int importedNamesSize = in.readInt();
        ArrayList<QualifiedName> _arrayList_2 = new ArrayList<QualifiedName>(importedNamesSize);
        this.importedNames = _arrayList_2;
        ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, importedNamesSize, true);
        for (Integer i_2 : _doubleDotLessThan_2) {
            QualifiedName _readQualifiedName = SerializationExtensions.readQualifiedName(in);
            this.importedNames.add(_readQualifiedName);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializationExtensions.writeURI(out, this.uRI);
        int _size = this.descriptions.size();
        out.writeInt(_size);
        for (SerializableEObjectDescription serializableEObjectDescription : this.descriptions) {
            out.writeObject(serializableEObjectDescription);
        }
        int _size_1 = this.references.size();
        out.writeInt(_size_1);
        for (SerializableReferenceDescription ref : this.references) {
            out.writeObject(ref);
        }
        int n = this.importedNames.size();
        out.writeInt(n);
        for (QualifiedName name : this.importedNames) {
            SerializationExtensions.writeQualifiedName(out, name);
        }
    }

    @Pure
    public List<SerializableEObjectDescription> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<SerializableEObjectDescription> descriptions) {
        this.descriptions = descriptions;
    }

    @Pure
    public List<SerializableReferenceDescription> getReferences() {
        return this.references;
    }

    public void setReferences(List<SerializableReferenceDescription> references) {
        this.references = references;
    }

    public void setImportedNames(List<QualifiedName> importedNames) {
        this.importedNames = importedNames;
    }

    @Override
    @Pure
    public URI getURI() {
        return this.uRI;
    }

    public void setURI(URI uRI) {
        this.uRI = uRI;
    }
}

