/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.common.base.Objects;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.ResourceServiceProviderRegistryImpl;

@Singleton
public class ResourceServiceProviderServiceLoader
implements Provider<IResourceServiceProvider.Registry> {
    private ServiceLoader<ISetup> setupLoader = ServiceLoader.load(ISetup.class);
    private IResourceServiceProvider.Registry registry = this.loadRegistry();

    private IResourceServiceProvider.Registry loadRegistry() {
        ResourceServiceProviderRegistryImpl registry = new ResourceServiceProviderRegistryImpl();
        for (ISetup cp : this.setupLoader) {
            Injector injector = cp.createInjectorAndDoEMFRegistration();
            IResourceServiceProvider resourceServiceProvider = (IResourceServiceProvider)injector.getInstance(IResourceServiceProvider.class);
            FileExtensionProvider extensionProvider = (FileExtensionProvider)injector.getInstance(FileExtensionProvider.class);
            Set<String> _fileExtensions = extensionProvider.getFileExtensions();
            for (String ext : _fileExtensions) {
                Map<String, Object> _extensionToFactoryMap = registry.getExtensionToFactoryMap();
                boolean _containsKey = _extensionToFactoryMap.containsKey(ext);
                if (_containsKey) {
                    String _primaryFileExtension = extensionProvider.getPrimaryFileExtension();
                    boolean _equals = Objects.equal((Object)_primaryFileExtension, (Object)ext);
                    if (!_equals) continue;
                    Map<String, Object> _extensionToFactoryMap_1 = registry.getExtensionToFactoryMap();
                    _extensionToFactoryMap_1.put(ext, resourceServiceProvider);
                    continue;
                }
                Map<String, Object> _extensionToFactoryMap_2 = registry.getExtensionToFactoryMap();
                _extensionToFactoryMap_2.put(ext, resourceServiceProvider);
            }
        }
        return registry;
    }

    public IResourceServiceProvider.Registry get() {
        return this.registry;
    }
}

