/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.build.BuildContext;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.build.Indexer;
import org.eclipse.xtext.build.Source2GeneratedMapping;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider2;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.generator.IShouldGenerate;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.URIBasedFileSystemAccess;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Log
public class IncrementalBuilder {
    @Inject
    private Provider<InternalStatefulIncrementalBuilder> provider;
    @Inject
    @Extension
    private OperationCanceledManager _operationCanceledManager;
    private static final Logger LOG = Logger.getLogger(IncrementalBuilder.class);

    public Result build(BuildRequest request, Functions.Function1<? super URI, ? extends IResourceServiceProvider> languages) {
        DisabledClusteringPolicy _disabledClusteringPolicy = new DisabledClusteringPolicy();
        return this.build(request, languages, _disabledClusteringPolicy);
    }

    public Result build(BuildRequest request, Functions.Function1<? super URI, ? extends IResourceServiceProvider> languages, IResourceClusteringPolicy clusteringPolicy) {
        try {
            XtextResourceSet resourceSet = request.getResourceSet();
            IndexState _state = request.getState();
            ResourceDescriptionsData _resourceDescriptions = _state.getResourceDescriptions();
            ResourceDescriptionsData _copy = _resourceDescriptions.copy();
            IndexState _state_1 = request.getState();
            Source2GeneratedMapping _fileMappings = _state_1.getFileMappings();
            Source2GeneratedMapping _copy_1 = _fileMappings.copy();
            IndexState oldState = new IndexState(_copy, _copy_1);
            CancelIndicator _cancelIndicator = request.getCancelIndicator();
            BuildContext context = new BuildContext(languages, resourceSet, oldState, clusteringPolicy, _cancelIndicator);
            InternalStatefulIncrementalBuilder builder = (InternalStatefulIncrementalBuilder)this.provider.get();
            builder.context = context;
            builder.request = request;
            try {
                return builder.launch();
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable t = _t;
                    this._operationCanceledManager.propagateIfCancelException(t);
                    throw t;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Log
    protected static class InternalStatefulIncrementalBuilder {
        @Extension
        @Accessors(value={AccessorType.PROTECTED_SETTER})
        private BuildContext context;
        @Accessors(value={AccessorType.PROTECTED_SETTER})
        private BuildRequest request;
        @Inject
        private Indexer indexer;
        @Inject
        @Extension
        private OperationCanceledManager _operationCanceledManager;
        private static final Logger LOG = Logger.getLogger(InternalStatefulIncrementalBuilder.class);

        protected InternalStatefulIncrementalBuilder() {
        }

        public Result launch() {
            IndexState _state = this.request.getState();
            Source2GeneratedMapping newSource2GeneratedMapping = _state.getFileMappings();
            List<URI> _deletedFiles = this.request.getDeletedFiles();
            Consumer<URI> _function = source -> {
                Set<URI> _deleteSource = newSource2GeneratedMapping.deleteSource((URI)source);
                Consumer<URI> _function_1 = generated -> {
                    try {
                        String configName;
                        Functions.Function1 _function_2;
                        XtextResourceSet _resourceSet;
                        IResourceServiceProvider serviceProvider;
                        IContextualOutputConfigurationProvider2 _get;
                        Set<OutputConfiguration> configs;
                        OutputConfiguration config;
                        boolean _isInfoEnabled = LOG.isInfoEnabled();
                        if (_isInfoEnabled) {
                            LOG.info((Object)("Deleting " + generated));
                        }
                        if ((config = (OutputConfiguration)IterableExtensions.findFirst(configs = (_get = (serviceProvider = this.context.getResourceServiceProvider((URI)source)).get(IContextualOutputConfigurationProvider2.class)).getOutputConfigurations((ResourceSet)(_resourceSet = this.request.getResourceSet())), (Functions.Function1)(_function_2 = arg_0 -> InternalStatefulIncrementalBuilder.lambda$null$0(configName = newSource2GeneratedMapping.getOutputConfigName((URI)generated), arg_0)))) != null && config.isCleanUpDerivedResources()) {
                            XtextResourceSet _resourceSet_1 = this.context.getResourceSet();
                            URIConverter _uRIConverter = _resourceSet_1.getURIConverter();
                            Map _emptyMap = CollectionLiterals.emptyMap();
                            _uRIConverter.delete(generated, _emptyMap);
                            Procedures.Procedure1<? super URI> _afterDeleteFile = this.request.getAfterDeleteFile();
                            _afterDeleteFile.apply(generated);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                _deleteSource.forEach(_function_1);
            };
            _deletedFiles.forEach(_function);
            Indexer.IndexResult result = this.indexer.computeAndIndexAffected(this.request, this.context);
            CancelIndicator _cancelIndicator = this.request.getCancelIndicator();
            this._operationCanceledManager.checkCanceled(_cancelIndicator);
            ArrayList resolvedDeltas = CollectionLiterals.newArrayList((Object[])new IResourceDescription.Delta[0]);
            List<IResourceDescription.Delta> _resourceDeltas = result.getResourceDeltas();
            Functions.Function1 _function_1 = it -> {
                IResourceDescription _new = it.getNew();
                return _new == null;
            };
            Iterable _filter = IterableExtensions.filter(_resourceDeltas, (Functions.Function1)_function_1);
            Iterables.addAll((Collection)resolvedDeltas, (Iterable)_filter);
            List<IResourceDescription.Delta> _resourceDeltas_1 = result.getResourceDeltas();
            Functions.Function1 _function_2 = it -> {
                IResourceDescription _new = it.getNew();
                return _new != null;
            };
            Iterable _filter_1 = IterableExtensions.filter(_resourceDeltas_1, (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = it -> it.getUri();
            Iterable _map = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function_3);
            Functions.Function1 _function_4 = resource -> {
                CancelIndicator _cancelIndicator_1 = this.request.getCancelIndicator();
                this._operationCanceledManager.checkCanceled(_cancelIndicator_1);
                resource.getContents();
                EcoreUtil2.resolveLazyCrossReferences(resource, CancelIndicator.NullImpl);
                CancelIndicator _cancelIndicator_2 = this.request.getCancelIndicator();
                this._operationCanceledManager.checkCanceled(_cancelIndicator_2);
                URI _uRI = resource.getURI();
                IResourceServiceProvider serviceProvider = this.context.getResourceServiceProvider(_uRI);
                IResourceDescription.Manager manager = serviceProvider.getResourceDescriptionManager();
                IResourceDescription description = manager.getResourceDescription((Resource)resource);
                SerializableResourceDescription copiedDescription = SerializableResourceDescription.createCopy(description);
                ResourceDescriptionsData _newIndex = result.getNewIndex();
                URI _uRI_1 = resource.getURI();
                _newIndex.addDescription(_uRI_1, copiedDescription);
                CancelIndicator _cancelIndicator_3 = this.request.getCancelIndicator();
                this._operationCanceledManager.checkCanceled(_cancelIndicator_3);
                if (!this.request.isIndexOnly() && this.validate((Resource)resource) && serviceProvider.get(IShouldGenerate.class).shouldGenerate((Resource)resource, CancelIndicator.NullImpl)) {
                    CancelIndicator _cancelIndicator_4 = this.request.getCancelIndicator();
                    this._operationCanceledManager.checkCanceled(_cancelIndicator_4);
                    this.generate((Resource)resource, this.request, newSource2GeneratedMapping);
                }
                IndexState _oldState = this.context.getOldState();
                ResourceDescriptionsData _resourceDescriptions = _oldState.getResourceDescriptions();
                URI _uRI_2 = resource.getURI();
                IResourceDescription old = _resourceDescriptions.getResourceDescription(_uRI_2);
                return manager.createDelta(old, copiedDescription);
            };
            Iterable _executeClustered = this.context.executeClustered(_map, _function_4);
            Iterables.addAll((Collection)resolvedDeltas, _executeClustered);
            IndexState _state_1 = this.request.getState();
            return new Result(_state_1, resolvedDeltas);
        }

        protected boolean validate(Resource resource) {
            URI _uRI = resource.getURI();
            IResourceServiceProvider _resourceServiceProvider = this.context.getResourceServiceProvider(_uRI);
            IResourceValidator resourceValidator = _resourceServiceProvider.getResourceValidator();
            if (resourceValidator == null) {
                return true;
            }
            URI _uRI_1 = resource.getURI();
            String _lastSegment = _uRI_1.lastSegment();
            String _plus = "Starting validation for input: '" + _lastSegment;
            String _plus_1 = _plus + "'";
            LOG.info((Object)_plus_1);
            List<Issue> validationResult = resourceValidator.validate(resource, CheckMode.ALL, null);
            BuildRequest.IPostValidationCallback _afterValidate = this.request.getAfterValidate();
            URI _uRI_2 = resource.getURI();
            return _afterValidate.afterValidate(_uRI_2, validationResult);
        }

        protected void generate(Resource resource, BuildRequest request, Source2GeneratedMapping newMappings) {
            URI _uRI = resource.getURI();
            IResourceServiceProvider serviceProvider = this.context.getResourceServiceProvider(_uRI);
            GeneratorDelegate generator = serviceProvider.get(GeneratorDelegate.class);
            if (generator == null) {
                return;
            }
            URI _uRI_1 = resource.getURI();
            Set<URI> previous = newMappings.deleteSource(_uRI_1);
            URIBasedFileSystemAccess _createFileSystemAccess = this.createFileSystemAccess(serviceProvider, resource);
            Procedures.Procedure1 _function = it -> {
                URIBasedFileSystemAccess.BeforeWrite _function_1 = (uri, outputCfgName, contents) -> {
                    URI _uRI_2 = resource.getURI();
                    newMappings.addSource2Generated(_uRI_2, uri, outputCfgName);
                    previous.remove(uri);
                    Procedures.Procedure2<? super URI, ? super URI> _afterGenerateFile = request.getAfterGenerateFile();
                    URI _uRI_3 = resource.getURI();
                    _afterGenerateFile.apply((Object)_uRI_3, (Object)uri);
                    return contents;
                };
                it.setBeforeWrite(_function_1);
                URIBasedFileSystemAccess.BeforeDelete _function_2 = uri -> {
                    newMappings.deleteGenerated(uri);
                    Procedures.Procedure1<? super URI> _afterDeleteFile = request.getAfterDeleteFile();
                    _afterDeleteFile.apply((Object)uri);
                    return true;
                };
                it.setBeforeDelete(_function_2);
            };
            URIBasedFileSystemAccess fileSystemAccess = (URIBasedFileSystemAccess)ObjectExtensions.operator_doubleArrow((Object)_createFileSystemAccess, (Procedures.Procedure1)_function);
            fileSystemAccess.setContext(resource);
            boolean _isWriteStorageResources = request.isWriteStorageResources();
            if (_isWriteStorageResources) {
                boolean _matched = false;
                if (resource instanceof StorageAwareResource) {
                    boolean _tripleNotEquals;
                    IResourceStorageFacade _resourceStorageFacade = ((StorageAwareResource)resource).getResourceStorageFacade();
                    boolean bl = _tripleNotEquals = _resourceStorageFacade != null;
                    if (_tripleNotEquals) {
                        _matched = true;
                        IResourceStorageFacade _resourceStorageFacade_1 = ((StorageAwareResource)resource).getResourceStorageFacade();
                        _resourceStorageFacade_1.saveResource((StorageAwareResource)resource, fileSystemAccess);
                    }
                }
            }
            GeneratorContext generatorContext = new GeneratorContext();
            CancelIndicator _cancelIndicator = request.getCancelIndicator();
            generatorContext.setCancelIndicator(_cancelIndicator);
            generator.generate(resource, fileSystemAccess, generatorContext);
            Consumer<URI> _function_1 = it -> {
                try {
                    LOG.info((Object)("Deleting stale generated file " + it));
                    XtextResourceSet _resourceSet = this.context.getResourceSet();
                    URIConverter _uRIConverter = _resourceSet.getURIConverter();
                    Map _emptyMap = CollectionLiterals.emptyMap();
                    _uRIConverter.delete(it, _emptyMap);
                    Procedures.Procedure1<? super URI> _afterDeleteFile = request.getAfterDeleteFile();
                    _afterDeleteFile.apply(it);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            previous.forEach(_function_1);
        }

        protected URIBasedFileSystemAccess createFileSystemAccess(IResourceServiceProvider serviceProvider, Resource resource) {
            URIBasedFileSystemAccess _xblockexpression = null;
            IProjectConfigProvider projectConfigProvider = serviceProvider.get(IProjectConfigProvider.class);
            IProjectConfig _projectConfig = null;
            if (projectConfigProvider != null) {
                ResourceSet _resourceSet = resource.getResourceSet();
                _projectConfig = projectConfigProvider.getProjectConfig(_resourceSet);
            }
            IProjectConfig projectConfig = _projectConfig;
            ISourceFolder _findSourceFolderContaining = null;
            if (projectConfig != null) {
                URI _uRI = resource.getURI();
                _findSourceFolderContaining = projectConfig.findSourceFolderContaining(_uRI);
            }
            ISourceFolder sourceFolder = _findSourceFolderContaining;
            URIBasedFileSystemAccess _uRIBasedFileSystemAccess = new URIBasedFileSystemAccess();
            Procedures.Procedure1 _function = it -> {
                IContextualOutputConfigurationProvider outputConfigProvider = serviceProvider.get(IContextualOutputConfigurationProvider.class);
                Set<OutputConfiguration> _outputConfigurations = outputConfigProvider.getOutputConfigurations(resource);
                Functions.Function1 _function_1 = it_1 -> it_1.getName();
                Map _map = IterableExtensions.toMap(_outputConfigurations, (Functions.Function1)_function_1);
                it.setOutputConfigurations(_map);
                IFilePostProcessor _get = serviceProvider.get(IFilePostProcessor.class);
                it.setPostProcessor(_get);
                IEncodingProvider newEncodingProvider = serviceProvider.get(IEncodingProvider.class);
                if (newEncodingProvider != null) {
                    it.setEncodingProvider(newEncodingProvider);
                }
                TraceFileNameProvider _get_1 = serviceProvider.get(TraceFileNameProvider.class);
                it.setTraceFileNameProvider(_get_1);
                TraceRegionSerializer _get_2 = serviceProvider.get(TraceRegionSerializer.class);
                it.setTraceRegionSerializer(_get_2);
                it.setGenerateTraces(true);
                URI _baseDir = this.request.getBaseDir();
                it.setBaseDir(_baseDir);
                String _name = null;
                if (sourceFolder != null) {
                    _name = sourceFolder.getName();
                }
                it.setCurrentSource(_name);
                ResourceSet _resourceSet_1 = resource.getResourceSet();
                URIConverter _uRIConverter = _resourceSet_1.getURIConverter();
                it.setConverter(_uRIConverter);
            };
            _xblockexpression = (URIBasedFileSystemAccess)ObjectExtensions.operator_doubleArrow((Object)_uRIBasedFileSystemAccess, (Procedures.Procedure1)_function);
            return _xblockexpression;
        }

        protected void setContext(BuildContext context) {
            this.context = context;
        }

        protected void setRequest(BuildRequest request) {
            this.request = request;
        }

        private static /* synthetic */ Boolean lambda$null$0(String configName, OutputConfiguration it) {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)configName);
        }
    }

    @Data
    public static class Result {
        private final IndexState indexState;
        private final List<IResourceDescription.Delta> affectedResources;

        public Result(IndexState indexState, List<IResourceDescription.Delta> affectedResources) {
            this.indexState = indexState;
            this.affectedResources = affectedResources;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.indexState == null ? 0 : this.indexState.hashCode());
            result = 31 * result + (this.affectedResources == null ? 0 : this.affectedResources.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (this.indexState == null ? other.indexState != null : !this.indexState.equals(other.indexState)) {
                return false;
            }
            return !(this.affectedResources == null ? other.affectedResources != null : !this.affectedResources.equals(other.affectedResources));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("indexState", (Object)this.indexState);
            b.add("affectedResources", this.affectedResources);
            return b.toString();
        }

        @Pure
        public IndexState getIndexState() {
            return this.indexState;
        }

        @Pure
        public List<IResourceDescription.Delta> getAffectedResources() {
            return this.affectedResources;
        }
    }
}

