/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.build.BuildContext;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProviderExtension;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.persistence.SourceLevelURIsAdapter;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@FinalFieldsConstructor
public class ClusteringStorageAwareResourceLoader {
    @Extension
    private final BuildContext context;

    public <T> Iterable<T> executeClustered(Iterable<URI> uris, Functions.Function1<? super Resource, ? extends T> operation) {
        ArrayList _xblockexpression = null;
        ArrayList loadedURIs = CollectionLiterals.newArrayList((Object[])new URI[0]);
        ArrayList sourceLevelURIs = CollectionLiterals.newArrayList((Object[])new URI[0]);
        ArrayList resources = CollectionLiterals.newArrayList((Object[])new Resource[0]);
        ArrayList result = CollectionLiterals.newArrayList((Object[])new Object[0]);
        for (URI uri : uris) {
            boolean _not;
            int _size;
            XtextResourceSet _resourceSet;
            IResourceClusteringPolicy _clusteringPolicy = this.context.getClusteringPolicy();
            boolean _continueProcessing = _clusteringPolicy.continueProcessing((ResourceSet)(_resourceSet = this.context.getResourceSet()), uri, _size = loadedURIs.size());
            boolean bl = _not = !_continueProcessing;
            if (_not) {
                Functions.Function1 _function = it -> operation.apply(it);
                List _map = ListExtensions.map((List)resources, (Functions.Function1)_function);
                Iterables.addAll((Collection)result, (Iterable)_map);
                resources.clear();
                this.clearResourceSet();
                loadedURIs.clear();
            }
            loadedURIs.add(uri);
            boolean _isSource = this.isSource(uri);
            if (_isSource) {
                boolean _isLoadedFromStorage;
                sourceLevelURIs.add(uri);
                XtextResourceSet _resourceSet_1 = this.context.getResourceSet();
                Resource existingResource = _resourceSet_1.getResource(uri, false);
                if (existingResource instanceof StorageAwareResource && (_isLoadedFromStorage = ((StorageAwareResource)existingResource).isLoadedFromStorage())) {
                    ((StorageAwareResource)existingResource).unload();
                }
                XtextResourceSet _resourceSet_2 = this.context.getResourceSet();
                SourceLevelURIsAdapter.setSourceLevelUris((ResourceSet)_resourceSet_2, sourceLevelURIs);
            }
            XtextResourceSet _resourceSet_3 = this.context.getResourceSet();
            Resource _resource = _resourceSet_3.getResource(uri, true);
            resources.add(_resource);
        }
        Functions.Function1 _function = it -> operation.apply(it);
        List _map = ListExtensions.map((List)resources, (Functions.Function1)_function);
        Iterables.addAll((Collection)result, (Iterable)_map);
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected boolean isSource(URI uri) {
        IResourceServiceProvider provider = this.context.getResourceServiceProvider(uri);
        return provider instanceof IResourceServiceProviderExtension && ((IResourceServiceProviderExtension)((Object)provider)).isSource(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearResourceSet() {
        XtextResourceSet _resourceSet = this.context.getResourceSet();
        boolean wasDeliver = _resourceSet.eDeliver();
        try {
            XtextResourceSet _resourceSet_1 = this.context.getResourceSet();
            _resourceSet_1.eSetDeliver(false);
            XtextResourceSet _resourceSet_2 = this.context.getResourceSet();
            EList _resources = _resourceSet_2.getResources();
            _resources.clear();
        }
        finally {
            XtextResourceSet _resourceSet_3 = this.context.getResourceSet();
            _resourceSet_3.eSetDeliver(wasDeliver);
        }
    }

    public ClusteringStorageAwareResourceLoader(BuildContext context) {
        this.context = context;
    }
}

