/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class PortableURIs {
    public static final String PORTABLE_SCHEME = "portable";
    @Inject
    private IGlobalScopeProvider globalScopeProvider;
    @Inject
    private EPackage.Registry packageRegistry;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    public boolean isPortableURIFragment(String uriFragment) {
        return uriFragment.startsWith(PORTABLE_SCHEME);
    }

    public EObject resolve(StorageAwareResource resource, String portableFragment) {
        PortableFragmentDescription desc = this.fromFragmentString(portableFragment);
        EReference mock = EcoreFactory.eINSTANCE.createEReference();
        mock.setEType((EClassifier)desc.descriptionEClass);
        Predicate _alwaysTrue = Predicates.alwaysTrue();
        IScope scope = this.globalScopeProvider.getScope((Resource)resource, mock, (Predicate<IEObjectDescription>)_alwaysTrue);
        Iterable<IEObjectDescription> _elements = scope.getElements(desc.descriptionQualifiedName);
        IEObjectDescription description = (IEObjectDescription)IterableExtensions.head(_elements);
        boolean _equals = Objects.equal((Object)description, null);
        if (_equals) {
            return null;
        }
        EObject _eObjectOrProxy = description.getEObjectOrProxy();
        EObject container = EcoreUtil.resolve((EObject)_eObjectOrProxy, (Resource)resource);
        return this.getEObject(container, desc.descriptionRelativeFragment);
    }

    public URI toPortableURI(StorageAwareResource sourceResource, URI targetURI) {
        ResourceSet _resourceSet = sourceResource.getResourceSet();
        URI _trimFragment = targetURI.trimFragment();
        Resource _resource = _resourceSet.getResource(_trimFragment, false);
        EObject _eObject = null;
        if (_resource != null) {
            String _fragment = targetURI.fragment();
            _eObject = _resource.getEObject(_fragment);
        }
        EObject to = _eObject;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)to, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _notEquals;
            Resource _eResource = to.eResource();
            ResourceSet _resourceSet_1 = null;
            if (_eResource != null) {
                _resourceSet_1 = _eResource.getResourceSet();
            }
            _or = _notEquals = !Objects.equal((Object)_resourceSet_1, null);
        }
        if (_or) {
            boolean _notEquals_1;
            URI result = this.toPortableURI(sourceResource, to);
            boolean bl = _notEquals_1 = !Objects.equal((Object)result, null);
            if (_notEquals_1) {
                return result;
            }
        }
        return null;
    }

    public URI toPortableURI(StorageAwareResource sourceResource, EObject targetObject) {
        boolean _notEquals;
        if (Objects.equal((Object)targetObject, null) || targetObject.eIsProxy()) {
            URI _uRI = sourceResource.getURI();
            return _uRI.appendFragment("UNRESOLVABLE");
        }
        String portableFragment = this.getPortableURIFragment(targetObject);
        boolean bl = _notEquals = !Objects.equal((Object)portableFragment, null);
        if (_notEquals) {
            URI _uRI_1 = sourceResource.getURI();
            return _uRI_1.appendFragment(portableFragment);
        }
        return null;
    }

    protected String getPortableURIFragment(final EObject obj) {
        boolean _notEquals;
        Functions.Function1<IEObjectDescription, Boolean> _function;
        Resource _eResource_1;
        URI _uRI;
        Resource _eResource = obj.eResource();
        IResourceDescriptions descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(_eResource);
        IResourceDescription desc = descriptions.getResourceDescription(_uRI = (_eResource_1 = obj.eResource()).getURI());
        boolean _equals = Objects.equal((Object)desc, null);
        if (_equals) {
            return null;
        }
        Iterable<IEObjectDescription> _exportedObjects = desc.getExportedObjects();
        IEObjectDescription containerDesc = (IEObjectDescription)IterableExtensions.findFirst(_exportedObjects, (Functions.Function1)(_function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                Resource _eResource;
                boolean _xblockexpression = false;
                EObject _eObjectOrProxy = it.getEObjectOrProxy();
                EObject possibleContainer = EcoreUtil.resolve((EObject)_eObjectOrProxy, (Resource)(_eResource = obj.eResource()));
                _xblockexpression = Objects.equal((Object)obj, (Object)possibleContainer) || EcoreUtil.isAncestor((EObject)obj, (EObject)possibleContainer);
                return _xblockexpression;
            }
        }));
        boolean bl = _notEquals = !Objects.equal((Object)containerDesc, null);
        if (_notEquals) {
            PortableFragmentDescription fragmentDescription = this.createPortableFragmentDescription(containerDesc, obj);
            return this.toFragmentString(fragmentDescription);
        }
        return null;
    }

    protected PortableFragmentDescription createPortableFragmentDescription(IEObjectDescription desc, EObject target) {
        EObject _eObjectOrProxy = desc.getEObjectOrProxy();
        EObject possibleContainer = EcoreUtil.resolve((EObject)_eObjectOrProxy, (EObject)target);
        String fragmentToTarget = this.getFragment(target, possibleContainer);
        EClass _eClass = desc.getEClass();
        QualifiedName _qualifiedName = desc.getQualifiedName();
        return new PortableFragmentDescription(_eClass, _qualifiedName, fragmentToTarget);
    }

    protected String toFragmentString(PortableFragmentDescription desc) {
        boolean _notEquals;
        URI _uRI = EcoreUtil.getURI((EObject)desc.descriptionEClass);
        String _string = _uRI.toString();
        String eclassUriAsString = URI.encodeFragment((String)_string, (boolean)false);
        List<String> segments = desc.descriptionQualifiedName.getSegments();
        String _join = IterableExtensions.join(segments, (CharSequence)":");
        String _encodeFragment = URI.encodeFragment((String)_join, (boolean)false);
        String uriFragment = "portable#" + eclassUriAsString + "#" + _encodeFragment;
        boolean bl = _notEquals = !Objects.equal((Object)desc.descriptionRelativeFragment, null);
        if (_notEquals) {
            String _uriFragment = uriFragment;
            String _encodeFragment_1 = URI.encodeFragment((String)desc.descriptionRelativeFragment, (boolean)false);
            String _plus = "#" + _encodeFragment_1;
            uriFragment = String.valueOf(_uriFragment) + _plus;
        }
        return uriFragment;
    }

    protected PortableFragmentDescription fromFragmentString(String fragmentString) {
        Splitter _on = Splitter.on((String)"#");
        Iterable _split = _on.split((CharSequence)fragmentString);
        Iterator segments = _split.iterator();
        segments.next();
        String _next = (String)segments.next();
        String _decode = URI.decode((String)_next);
        URI eClassURI = URI.createURI((String)_decode);
        URI _trimFragment = eClassURI.trimFragment();
        String _string = _trimFragment.toString();
        EPackage ePackage = this.packageRegistry.getEPackage(_string);
        Resource _eResource = null;
        if (ePackage != null) {
            _eResource = ePackage.eResource();
        }
        EObject _eObject = null;
        if (_eResource != null) {
            String _fragment = eClassURI.fragment();
            _eObject = _eResource.getEObject(_fragment);
        }
        EClass eClass = (EClass)_eObject;
        Splitter _on_1 = Splitter.on((String)":");
        String _next_1 = (String)segments.next();
        String _decode_1 = URI.decode((String)_next_1);
        Iterable _split_1 = _on_1.split((CharSequence)_decode_1);
        List _list = IterableExtensions.toList((Iterable)_split_1);
        QualifiedName qname = QualifiedName.create(_list);
        String _xifexpression = null;
        boolean _hasNext = segments.hasNext();
        if (_hasNext) {
            String _next_2 = (String)segments.next();
            _xifexpression = URI.decode((String)_next_2);
        }
        String fragment = _xifexpression;
        EClass _elvis = null;
        _elvis = eClass != null ? eClass : EcorePackage.Literals.EOBJECT;
        return new PortableFragmentDescription(_elvis, qname, fragment);
    }

    public String getFragment(EObject fromContainer, EObject toChild) {
        boolean _equals = Objects.equal((Object)fromContainer, (Object)toChild);
        if (_equals) {
            return null;
        }
        InternalEObject lastChild = (InternalEObject)toChild;
        InternalEObject lastContainer = lastChild.eInternalContainer();
        EStructuralFeature _eContainingFeature = lastChild.eContainingFeature();
        String result = lastContainer.eURIFragmentSegment(_eContainingFeature, (EObject)lastChild);
        while (!Objects.equal((Object)lastContainer, null) && !Objects.equal((Object)fromContainer, (Object)lastContainer)) {
            String _plus_1;
            lastChild = lastContainer;
            InternalEObject _eInternalContainer = lastContainer.eInternalContainer();
            boolean _equals_1 = Objects.equal((Object)(lastContainer = _eInternalContainer), null);
            if (_equals_1) {
                throw new IllegalStateException("No more containers for element " + lastChild);
            }
            EStructuralFeature _eContainingFeature_1 = lastChild.eContainingFeature();
            String _eURIFragmentSegment = lastContainer.eURIFragmentSegment(_eContainingFeature_1, (EObject)lastChild);
            String _plus = String.valueOf(_eURIFragmentSegment) + "/";
            result = _plus_1 = String.valueOf(_plus) + result;
        }
        return result;
    }

    public EObject getEObject(EObject from, String toFragment) {
        boolean _equals = Objects.equal((Object)toFragment, null);
        if (_equals) {
            return from;
        }
        Splitter _on = Splitter.on((String)"/");
        Iterable splitted = _on.split((CharSequence)toFragment);
        Functions.Function2<EObject, String, EObject> _function = new Functions.Function2<EObject, String, EObject>(){

            public EObject apply(EObject $0, String $1) {
                return ((InternalEObject)$0).eObjectForURIFragmentSegment($1);
            }
        };
        return (EObject)IterableExtensions.fold((Iterable)splitted, (Object)from, (Functions.Function2)_function);
    }

    @Data
    public static class PortableFragmentDescription {
        private final EClass descriptionEClass;
        private final QualifiedName descriptionQualifiedName;
        private final String descriptionRelativeFragment;

        public PortableFragmentDescription(EClass descriptionEClass, QualifiedName descriptionQualifiedName, String descriptionRelativeFragment) {
            this.descriptionEClass = descriptionEClass;
            this.descriptionQualifiedName = descriptionQualifiedName;
            this.descriptionRelativeFragment = descriptionRelativeFragment;
        }

        @Pure
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.descriptionEClass == null ? 0 : this.descriptionEClass.hashCode());
            result = 31 * result + (this.descriptionQualifiedName == null ? 0 : this.descriptionQualifiedName.hashCode());
            result = 31 * result + (this.descriptionRelativeFragment == null ? 0 : this.descriptionRelativeFragment.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortableFragmentDescription other = (PortableFragmentDescription)obj;
            if (this.descriptionEClass == null ? other.descriptionEClass != null : !this.descriptionEClass.equals(other.descriptionEClass)) {
                return false;
            }
            if (this.descriptionQualifiedName == null ? other.descriptionQualifiedName != null : !this.descriptionQualifiedName.equals(other.descriptionQualifiedName)) {
                return false;
            }
            return !(this.descriptionRelativeFragment == null ? other.descriptionRelativeFragment != null : !this.descriptionRelativeFragment.equals(other.descriptionRelativeFragment));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("descriptionEClass", (Object)this.descriptionEClass);
            b.add("descriptionQualifiedName", (Object)this.descriptionQualifiedName);
            b.add("descriptionRelativeFragment", (Object)this.descriptionRelativeFragment);
            return b.toString();
        }

        @Pure
        public EClass getDescriptionEClass() {
            return this.descriptionEClass;
        }

        @Pure
        public QualifiedName getDescriptionQualifiedName() {
            return this.descriptionQualifiedName;
        }

        @Pure
        public String getDescriptionRelativeFragment() {
            return this.descriptionRelativeFragment;
        }
    }
}

