/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractTextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionInIterableFinder;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionIterable;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionMatcher;

public abstract class AbstractEObjectRegion
extends AbstractTextSegment
implements IEObjectRegion {
    private final ITextRegionAccess access;
    private EObject grammarElement;
    private IHiddenRegion nextHidden;
    private IHiddenRegion previousHidden;
    private EObject semantcElement;
    private final List<ISemanticRegion> semanticRegions = Lists.newArrayList();

    public AbstractEObjectRegion(AbstractRegionAccess access) {
        this.access = access;
    }

    @Override
    public EObject getGrammarElement() {
        return this.grammarElement;
    }

    public IHiddenRegion getLeadingHiddenRegion() {
        return this.previousHidden;
    }

    public int getLength() {
        return this.nextHidden.getOffset() - this.getOffset();
    }

    @Override
    public IHiddenRegion getNextHiddenRegion() {
        return this.nextHidden;
    }

    @Override
    public ISemanticRegion getNextSemanticRegion() {
        return this.nextHidden.getNextSemanticRegion();
    }

    public int getOffset() {
        return this.previousHidden.getEndOffset();
    }

    @Override
    public IHiddenRegion getPreviousHiddenRegion() {
        return this.previousHidden;
    }

    @Override
    public ISemanticRegion getPreviousSemanticRegion() {
        return this.previousHidden.getPreviousSemanticRegion();
    }

    @Override
    public EObject getSemanticElement() {
        return this.semantcElement;
    }

    public List<ISemanticRegion> getSemanticRegions() {
        return this.semanticRegions;
    }

    @Override
    public ITextRegionAccess getTextRegionAccess() {
        return this.access;
    }

    public IHiddenRegion getTrailingHiddenRegion() {
        return this.nextHidden;
    }

    @Override
    public ISemanticRegionFinder immediatelyFollowing() {
        return new SemanticRegionMatcher(this.getNextSemanticRegion());
    }

    @Override
    public ISemanticRegionFinder immediatelyPreceding() {
        return new SemanticRegionMatcher(this.getPreviousSemanticRegion());
    }

    @Override
    public ISemanticRegionsFinder getRegionFor() {
        return new SemanticRegionInIterableFinder(this.semanticRegions);
    }

    @Override
    public Iterable<ISemanticRegion> getAllSemanticRegions() {
        ISemanticRegion first = this.previousHidden.getNextSemanticRegion();
        ISemanticRegion last = this.nextHidden.getPreviousSemanticRegion();
        return new SemanticRegionIterable(first, last);
    }

    @Override
    public ISemanticRegionsFinder getAllRegionsFor() {
        return new SemanticRegionInIterableFinder(this.getAllSemanticRegions());
    }

    protected void setGrammarElement(EObject grammarElement) {
        this.grammarElement = grammarElement;
    }

    protected void setLeadingHiddenRegion(IHiddenRegion leading) {
        this.previousHidden = leading;
    }

    protected void setSemantcElement(EObject semantcElement) {
        this.semantcElement = semantcElement;
    }

    protected void setTrailingHiddenRegion(IHiddenRegion trailing) {
        this.nextHidden = trailing;
    }
}

