/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.ecore.EcoreSupportStandaloneSetup;
import org.eclipse.xtext.generator.CompositeGeneratorFragment;
import org.eclipse.xtext.generator.IGeneratorFragment;
import org.eclipse.xtext.generator.ImplicitRuntimeFragment;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.ui.generator.ImplicitUiFragment;
import org.eclipse.xtext.util.Strings;

public class LanguageConfig
extends CompositeGeneratorFragment {
    private static final Logger LOG = Logger.getLogger(LanguageConfig.class);
    private Grammar grammar;
    private List<String> fileExtensions = new ArrayList<String>();
    private List<String> loadedResources = new ArrayList<String>();
    private ResourceSet forcedResourceSet = null;
    private boolean shouldCheckFileExtension = true;

    public void setForcedResourceSet(ResourceSet forcedResourceSet) {
        this.forcedResourceSet = forcedResourceSet;
    }

    public ResourceSet getForcedResourceSet() {
        return this.forcedResourceSet;
    }

    public void addLoadedResource(String uri) {
        this.loadedResources.add(uri);
    }

    public List<String> getLoadedResources() {
        return this.loadedResources;
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("generating infrastructure for " + grammar.getName() + " with fragments : " + Strings.toString((Collection)this.fragments, (Function)new ToStringFunction(", "), (String)", ")));
        }
        super.generate(grammar, ctx);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.isCheckFileExtension()) {
            for (String extension : this.fileExtensions) {
                char[] charArray = extension.toCharArray();
                if (!Character.isJavaIdentifierPart(charArray[0])) {
                    issues.addError("file extension '" + extension + "' starts with a non identifier letter : '" + charArray[0] + "'", this);
                }
                int i = 1;
                while (i < charArray.length) {
                    char c = charArray[i];
                    if (!Character.isJavaIdentifierPart(c)) {
                        issues.addError("file extension '" + extension + "' contains non identifier letter : '" + c + "'", this);
                    }
                    ++i;
                }
            }
        }
        if (this.getGrammar() == null) {
            issues.addError("property 'uri' is mandatory for element 'language'.", this);
        }
    }

    protected boolean isCheckFileExtension() {
        return this.shouldCheckFileExtension;
    }

    public void setCheckFileExtension(boolean shouldCheckFileExtension) {
        this.shouldCheckFileExtension = shouldCheckFileExtension;
    }

    public void setFileExtensions(String fileExtensions) {
        String[] split;
        if ("".equals(fileExtensions.trim())) {
            return;
        }
        String[] stringArray = split = fileExtensions.split("\\s*,\\s*");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.fileExtensions.add(string);
            ++n2;
        }
    }

    public List<String> getFileExtensions(Grammar g) {
        if (this.fileExtensions.isEmpty()) {
            String lowerCase = GrammarUtil.getName((Grammar)g).toLowerCase();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No explicit fileExtensions configured. Using '*." + lowerCase + "'."));
            }
            return Collections.singletonList(lowerCase);
        }
        return this.fileExtensions;
    }

    public void initialize(boolean isUi) {
        if (isUi) {
            this.fragments.add(0, new ImplicitUiFragment(this.getFileExtensions(this.getGrammar())));
        }
        this.fragments.add(0, new ImplicitRuntimeFragment());
    }

    public void setUri(String uri) {
        XtextResource resource;
        ResourceSet rs = this.forcedResourceSet != null ? this.forcedResourceSet : new XtextResourceSet();
        for (String loadedResource : this.loadedResources) {
            IResourceServiceProvider resourceServiceProvider;
            URI loadedResourceUri = URI.createURI((String)loadedResource);
            if (Strings.equal((String)loadedResourceUri.fileExtension(), (String)"genmodel")) {
                resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResourceUri);
                if (resourceServiceProvider == null) {
                    try {
                        Class<?> genModelSupport = Class.forName("org.eclipse.emf.codegen.ecore.xtext.GenModelSupport");
                        Object instance = genModelSupport.newInstance();
                        genModelSupport.getDeclaredMethod("createInjectorAndDoEMFRegistration", new Class[0]).invoke(instance, new Object[0]);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.error((Object)"Couldn't initialize GenModel support. Is it on the classpath?");
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Couldn't initialize GenModel support.", (Throwable)e);
                    }
                }
            } else if (Strings.equal((String)loadedResourceUri.fileExtension(), (String)"ecore")) {
                resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResourceUri);
                if (resourceServiceProvider == null) {
                    EcoreSupportStandaloneSetup.setup();
                }
            } else if (Strings.equal((String)loadedResourceUri.fileExtension(), (String)"xcore")) {
                resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResourceUri);
                if (resourceServiceProvider == null) {
                    try {
                        Class<?> xcore = Class.forName("org.eclipse.emf.ecore.xcore.XcoreStandaloneSetup");
                        xcore.getDeclaredMethod("doSetup", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.error((Object)"Couldn't initialize Xcore support. Is it on the classpath?");
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Couldn't initialize Xcore support.", (Throwable)e);
                    }
                }
                URI xcoreLangURI = URI.createPlatformResourceURI((String)"/org.eclipse.emf.ecore.xcore.lib/model/XcoreLang.xcore", (boolean)true);
                try {
                    rs.getResource(xcoreLangURI, true);
                }
                catch (WrappedException e) {
                    LOG.error((Object)"Could not load XcoreLang.xcore.", (Throwable)e);
                    Resource brokenResource = rs.getResource(xcoreLangURI, false);
                    rs.getResources().remove((Object)brokenResource);
                }
            }
            rs.getResource(loadedResourceUri, true);
        }
        if (!rs.getResources().isEmpty()) {
            this.installIndex(rs);
            int i = 0;
            int size = rs.getResources().size();
            while (i < size) {
                Resource res = (Resource)rs.getResources().get(i);
                if (res.getContents().isEmpty()) {
                    LOG.error((Object)("Error loading '" + res.getURI() + "'"));
                } else if (!res.getErrors().isEmpty()) {
                    LOG.error((Object)("Error loading '" + res.getURI() + "':\n" + Joiner.on((char)'\n').join((Iterable)res.getErrors())));
                }
                ++i;
            }
            EcoreUtil.resolveAll((ResourceSet)rs);
        }
        if ((resource = (XtextResource)rs.getResource(URI.createURI((String)uri), true)).getContents().isEmpty()) {
            throw new IllegalArgumentException("Couldn't load grammar for '" + uri + "'.");
        }
        if (!resource.getErrors().isEmpty()) {
            LOG.error((Object)resource.getErrors());
            throw new IllegalStateException("Problem parsing '" + uri + "':\n" + Joiner.on((char)'\n').join((Iterable)resource.getErrors()));
        }
        Grammar grammar = (Grammar)resource.getContents().get(0);
        this.validateGrammar(grammar);
        this.grammar = grammar;
    }

    private void installIndex(ResourceSet resourceSet) {
        ResourceDescriptionsData index = new ResourceDescriptionsData(Collections.emptyList());
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            this.index(resource, resource.getURI(), index);
        }
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)resourceSet, (ResourceDescriptionsData)index);
    }

    private void index(Resource resource, URI uri, ResourceDescriptionsData index) {
        IResourceDescription resourceDescription;
        IResourceServiceProvider serviceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        if (serviceProvider != null && (resourceDescription = serviceProvider.getResourceDescriptionManager().getResourceDescription(resource)) != null) {
            index.addDescription(uri, resourceDescription);
        }
    }

    protected void validateGrammar(Grammar grammar) {
        this.validateAllImports(grammar);
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator((EPackage)XtextPackage.eINSTANCE);
        if (validator != null) {
            DiagnosticChain chain = new DiagnosticChain(){

                public void add(Diagnostic diagnostic) {
                    if (diagnostic.getSeverity() == 4) {
                        if (diagnostic.getException() == null) {
                            throw new IllegalStateException(diagnostic.getMessage());
                        }
                        throw new IllegalStateException(diagnostic.getMessage(), diagnostic.getException());
                    }
                }

                public void addAll(Diagnostic diagnostic) {
                    this.add(diagnostic);
                }

                public void merge(Diagnostic diagnostic) {
                    throw new UnsupportedOperationException();
                }
            };
            validator.validate((EObject)grammar, chain, null);
            TreeIterator iterator = grammar.eAllContents();
            while (iterator.hasNext()) {
                validator.validate((EObject)iterator.next(), chain, new HashMap());
            }
        }
    }

    protected void validateAllImports(Grammar grammar) {
        for (AbstractMetamodelDeclaration amd : GrammarUtil.allMetamodelDeclarations((Grammar)grammar)) {
            if (!(amd instanceof ReferencedMetamodel)) continue;
            this.validateReferencedMetamodel((ReferencedMetamodel)amd);
        }
    }

    protected void validateReferencedMetamodel(ReferencedMetamodel ref) {
        if (ref.getEPackage() != null && !ref.getEPackage().eIsProxy()) {
            return;
        }
        EReference eref = XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE;
        List nodes = NodeModelUtils.findNodesForFeature((EObject)ref, (EStructuralFeature)eref);
        String refName = nodes.isEmpty() ? "(unknown)" : NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
        String grammarName = GrammarUtil.getGrammar((EObject)ref).getName();
        String msg = "The EPackage " + refName + " in grammar " + grammarName + " could not be found. ";
        msg = String.valueOf(msg) + "You might want to register that EPackage in your workflow file.";
        throw new IllegalStateException(msg);
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    private final class ToStringFunction
    implements Function<IGeneratorFragment, String> {
        private String delim;

        public ToStringFunction(String string) {
            this.delim = string;
        }

        public String apply(IGeneratorFragment from) {
            if (from instanceof CompositeGeneratorFragment) {
                return Strings.toString(((CompositeGeneratorFragment)from).fragments, (Function)this, (String)this.delim);
            }
            return from.getClass().getSimpleName();
        }
    }
}

