/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

@Deprecated
public class XmiWriter
extends AbstractWorkflowComponent {
    private static final Map saveOptions = new HashMap();
    private static final String COMPONENT_NAME = "XMI Writer";
    private String modelFile;
    private String inputSlot = "default";
    private String pathPrefix = ".";

    static {
        XMIResourceImpl resource = new XMIResourceImpl();
        saveOptions.putAll(resource.getDefaultSaveOptions());
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
    }

    public void setModelFile(String modelFile) {
        this.modelFile = modelFile;
    }

    public String getModelFile() {
        return this.modelFile;
    }

    public void setInputSlot(String inputSlot) {
        this.inputSlot = inputSlot;
    }

    public String getInputSlot() {
        return this.inputSlot;
    }

    public String getLogMessage() {
        return "slot '" + this.inputSlot + "' => file '" + this.pathPrefix + "/" + this.modelFile + "'";
    }

    public void checkConfiguration(Issues issues) {
        this.modelFile = this.modelFile.replace('\\', '/');
        int p = this.modelFile.lastIndexOf("/");
        if (p >= 0) {
            this.pathPrefix = this.modelFile.substring(0, p + 1);
            this.modelFile = this.modelFile.substring(p + 1);
        }
    }

    public void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        Object slotContent = ctx.get(this.inputSlot);
        if (slotContent == null) {
            issues.addError(this, "slot '" + this.inputSlot + "' is empty.");
            return;
        }
        if (!(slotContent instanceof Collection) && !(slotContent instanceof EObject)) {
            issues.addError(this, "slot '" + this.inputSlot + "' neither contains an EList nor an EObject", slotContent);
            return;
        }
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)this.modelFile);
        ResourceSetImpl rsImpl = new ResourceSetImpl();
        rsImpl.setURIConverter((URIConverter)new XmiWriterURIConverter(this.pathPrefix));
        Resource r = rsImpl.createResource(fileURI);
        if (r instanceof XMIResource) {
            XMIResource xmiRes = (XMIResource)r;
            xmiRes.getDefaultSaveOptions().putAll(saveOptions);
        }
        r.setURI(URI.createFileURI((String)this.modelFile));
        if (slotContent instanceof Collection) {
            r.getContents().addAll((Collection)slotContent);
        } else {
            r.getContents().add((Object)((EObject)slotContent));
        }
        try {
            if (r.getURI().isFile()) {
                File file = new File(String.valueOf(this.pathPrefix) + "/" + this.modelFile);
                FileOutputStream os = new FileOutputStream(file);
                r.save((OutputStream)os, null);
                ((OutputStream)os).close();
            } else {
                r.save(null);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    class XmiWriterURIConverter
    extends URIConverterImpl {
        private String pathPrefix;

        public XmiWriterURIConverter(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        protected OutputStream createFileOutputStream(String filename) throws IOException {
            if (this.pathPrefix != null) {
                int lastSlashPos;
                this.pathPrefix = this.pathPrefix.replace('\\', '/');
                if (!this.pathPrefix.endsWith("/")) {
                    this.pathPrefix = String.valueOf(this.pathPrefix) + "/";
                }
                if ((lastSlashPos = (filename = filename.replace('\\', '/')).lastIndexOf("/")) >= 0) {
                    filename = String.valueOf(filename.substring(0, lastSlashPos + 1)) + this.pathPrefix + filename.substring(lastSlashPos + 1);
                }
            }
            return super.createFileOutputStream(filename);
        }
    }
}

