/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard.cli;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtext.wizard.Outlet;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectsCreator;
import org.eclipse.xtext.xtext.wizard.SourceLayout;
import org.eclipse.xtext.xtext.wizard.TextFile;
import org.eclipse.xtext.xtext.wizard.WizardConfiguration;

public class CliProjectsCreator
implements ProjectsCreator {
    @Override
    public void createProjects(WizardConfiguration config) {
        Set<ProjectDescriptor> _enabledProjects = config.getEnabledProjects();
        Procedures.Procedure1<ProjectDescriptor> _function = new Procedures.Procedure1<ProjectDescriptor>(){

            public void apply(ProjectDescriptor it) {
                CliProjectsCreator.this.createProject(it);
            }
        };
        IterableExtensions.forEach(_enabledProjects, (Procedures.Procedure1)_function);
    }

    public void createProject(final ProjectDescriptor project) {
        String _location = project.getLocation();
        final File projectRoot = new File(_location);
        projectRoot.mkdirs();
        Iterable<? extends TextFile> _files = project.getFiles();
        Procedures.Procedure1<TextFile> _function = new Procedures.Procedure1<TextFile>(){

            public void apply(TextFile it) {
                try {
                    WizardConfiguration _config = project.getConfig();
                    SourceLayout _sourceLayout = _config.getSourceLayout();
                    Outlet _outlet = it.getOutlet();
                    String _pathFor = _sourceLayout.getPathFor(_outlet);
                    String _plus = String.valueOf(_pathFor) + "/";
                    String _relativePath = it.getRelativePath();
                    String projectRelativePath = String.valueOf(_plus) + _relativePath;
                    File file = new File(projectRoot, projectRelativePath);
                    File _parentFile = file.getParentFile();
                    _parentFile.mkdirs();
                    String _content = it.getContent();
                    WizardConfiguration _config_1 = project.getConfig();
                    Charset _encoding = _config_1.getEncoding();
                    Files.write((CharSequence)_content, (File)file, (Charset)_encoding);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        IterableExtensions.forEach(_files, (Procedures.Procedure1)_function);
        Set<String> _sourceFolders = project.getSourceFolders();
        Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                File _file = new File(projectRoot, it);
                _file.mkdirs();
            }
        };
        IterableExtensions.forEach(_sourceFolders, (Procedures.Procedure1)_function_1);
    }
}

