/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmByteAnnotationValue;
import org.eclipse.xtext.common.types.JvmCharAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDoubleAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFloatAnnotationValue;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmLongAnnotationValue;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.IFileHeaderProvider;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.DisableCodeGenerationAdapter;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.ErrorSafeExtensions;
import org.eclipse.xtext.xbase.compiler.FileHeaderAdapter;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.compiler.LoopExtensions;
import org.eclipse.xtext.xbase.compiler.LoopParams;
import org.eclipse.xtext.xbase.compiler.TreeAppendableUtil;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ImportingStringConcatenation;
import org.eclipse.xtext.xbase.compiler.output.SharedAppendableState;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class JvmModelGenerator
implements IGenerator {
    @Inject
    @Extension
    protected ILogicalContainerProvider _iLogicalContainerProvider;
    @Inject
    @Extension
    protected TypeReferences _typeReferences;
    @Inject
    @Extension
    protected TreeAppendableUtil _treeAppendableUtil;
    @Inject
    @Extension
    protected JvmTypeExtensions _jvmTypeExtensions;
    @Inject
    @Extension
    protected LoopExtensions _loopExtensions;
    @Inject
    @Extension
    protected ErrorSafeExtensions _errorSafeExtensions;
    @Inject
    private CommonTypeComputationServices commonServices;
    @Inject
    private XbaseCompiler compiler;
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    @Inject
    private IFileHeaderProvider fileHeaderProvider;
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private JavaKeywords keywords;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private ITraceURIConverter converter;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        EList _contents = input.getContents();
        for (EObject obj : _contents) {
            this.internalDoGenerate(obj, fsa);
        }
    }

    protected void _internalDoGenerate(EObject obj, IFileSystemAccess fsa) {
    }

    protected void _internalDoGenerate(JvmDeclaredType type, IFileSystemAccess fsa) {
        boolean _notEquals;
        boolean _isDisabled = DisableCodeGenerationAdapter.isDisabled(type);
        if (_isDisabled) {
            return;
        }
        String _qualifiedName = type.getQualifiedName();
        boolean bl = _notEquals = !Objects.equal((Object)_qualifiedName, null);
        if (_notEquals) {
            String _qualifiedName_1 = type.getQualifiedName();
            String _replace = _qualifiedName_1.replace(".", "/");
            String _plus = String.valueOf(_replace) + ".java";
            GeneratorConfig _get = this.generatorConfigProvider.get((EObject)type);
            CharSequence _generateType = this.generateType(type, _get);
            fsa.generateFile(_plus, _generateType);
        }
    }

    protected ImportManager createImportManager(JvmDeclaredType type) {
        return new ImportManager(true, type);
    }

    public CharSequence generateType(JvmDeclaredType type, GeneratorConfig config) {
        boolean _not;
        boolean _notEquals;
        ImportManager importManager = this.createImportManager(type);
        TreeAppendable bodyAppendable = this.createAppendable((EObject)type, importManager, config);
        bodyAppendable.openScope();
        this.assignThisAndSuper(bodyAppendable, type, config);
        this.generateBody(type, bodyAppendable, config);
        bodyAppendable.closeScope();
        TreeAppendable importAppendable = this.createAppendable((EObject)type, importManager, config);
        this.generateFileHeader(type, importAppendable, config);
        String _packageName = type.getPackageName();
        boolean bl = _notEquals = !Objects.equal((Object)_packageName, null);
        if (_notEquals) {
            ITreeAppendable _append = importAppendable.append("package ");
            String _packageName_1 = type.getPackageName();
            ITreeAppendable _append_1 = _append.append(_packageName_1);
            _append_1.append(";");
            TreeAppendable _newLine = importAppendable.newLine();
            _newLine.newLine();
        }
        List<String> _imports = importManager.getImports();
        for (String i : _imports) {
            ITreeAppendable _append_2 = importAppendable.append("import ");
            ITreeAppendable _append_3 = _append_2.append(i);
            ITreeAppendable _append_4 = _append_3.append(";");
            _append_4.newLine();
        }
        List<String> _imports_1 = importManager.getImports();
        boolean _isEmpty = _imports_1.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            importAppendable.newLine();
        }
        importAppendable.append(bodyAppendable);
        return importAppendable;
    }

    protected ITreeAppendable _generateBody(JvmGenericType it, ITreeAppendable appendable, GeneratorConfig config) {
        EObject _eContainer;
        boolean _not_1;
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable childAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, childAppendable, true, config);
        this.generateModifier((JvmMember)it, childAppendable, config);
        boolean _isInterface = it.isInterface();
        if (_isInterface) {
            childAppendable.append("interface ");
        } else {
            childAppendable.append("class ");
        }
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        _traceSignificant.append(_makeJavaIdentifier);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, childAppendable, config);
        EList _typeParameters = it.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        if (_isEmpty) {
            childAppendable.append(" ");
        }
        this.generateExtendsClause((JvmDeclaredType)it, childAppendable, config);
        this.generateMembersInBody((JvmDeclaredType)it, childAppendable, config);
        ITreeAppendable _xifexpression = null;
        boolean _and = false;
        boolean _isAnonymous = it.isAnonymous();
        boolean bl = _not = !_isAnonymous;
        _and = !_not ? false : (_not_1 = !((_eContainer = it.eContainer()) instanceof JvmType));
        if (_and) {
            _xifexpression = appendable.newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ITreeAppendable generateMembersInBody(JvmDeclaredType it, final ITreeAppendable appendable, final GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        ITreeAppendable _append = appendable.append("{");
        _append.increaseIndentation();
        Iterable<JvmMember> _membersToBeCompiled = this.getMembersToBeCompiled(it);
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                    public ITreeAppendable apply(ITreeAppendable it) {
                        return it.newLine();
                    }
                };
                it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)_function);
            }
        };
        Procedures.Procedure1<JvmMember> _function_1 = new Procedures.Procedure1<JvmMember>(){

            public void apply(JvmMember it) {
                ITreeAppendable memberAppendable = JvmModelGenerator.this._treeAppendableUtil.traceWithComments(appendable, (EObject)it);
                memberAppendable.openScope();
                JvmModelGenerator.this.generateMember(it, memberAppendable, config);
                memberAppendable.closeScope();
            }
        };
        this._loopExtensions.forEach(appendable, _membersToBeCompiled, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
        ITreeAppendable _decreaseIndentation = appendable.decreaseIndentation();
        ITreeAppendable _newLine = _decreaseIndentation.newLine();
        _xblockexpression = _newLine.append("}");
        return _xblockexpression;
    }

    @Deprecated
    public ITreeAppendable generateAnnotationsWithSyntheticSuppressWarnings(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        Functions.Function1<JvmAnnotationReference, Boolean> _function;
        ITreeAppendable _xblockexpression = null;
        Functions.Function1<JvmAnnotationReference, Boolean> noSuppressWarningsFilter = _function = new Functions.Function1<JvmAnnotationReference, Boolean>(){

            public Boolean apply(JvmAnnotationReference it) {
                String _name;
                JvmAnnotationType _annotation = it.getAnnotation();
                String _identifier = null;
                if (_annotation != null) {
                    _identifier = _annotation.getIdentifier();
                }
                return !Objects.equal((Object)_identifier, (Object)(_name = SuppressWarnings.class.getName()));
            }
        };
        EList _annotations = it.getAnnotations();
        Iterable _filter = IterableExtensions.filter((Iterable)_annotations, (Functions.Function1)noSuppressWarningsFilter);
        this.generateAnnotations(_filter, appendable, true, config);
        ITreeAppendable _xifexpression = null;
        EObject _eContainer = it.eContainer();
        boolean _equals = Objects.equal((Object)_eContainer, null);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"@SuppressWarnings(\"all\")");
            ITreeAppendable _append = appendable.append((CharSequence)_builder);
            _xifexpression = _append.newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateBody(JvmEnumerationType it, ITreeAppendable appendable, final GeneratorConfig config) {
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable, config);
        final ITreeAppendable childAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, childAppendable, true, config);
        this.generateModifier((JvmMember)it, childAppendable, config);
        childAppendable.append("enum ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        _traceSignificant.append(_makeJavaIdentifier);
        childAppendable.append(" ");
        this.generateExtendsClause((JvmDeclaredType)it, childAppendable, config);
        ITreeAppendable _append = childAppendable.append("{");
        _append.increaseIndentation();
        EList _literals = it.getLiterals();
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                    public ITreeAppendable apply(ITreeAppendable it) {
                        ITreeAppendable _append = it.append(",");
                        return _append.newLine();
                    }
                };
                it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)_function);
                it.setSuffix(";");
            }
        };
        Procedures.Procedure1<JvmEnumerationLiteral> _function_1 = new Procedures.Procedure1<JvmEnumerationLiteral>(){

            public void apply(JvmEnumerationLiteral it) {
                ITreeAppendable _trace = childAppendable.trace((EObject)it);
                JvmModelGenerator.this.generateEnumLiteral(it, _trace, config);
            }
        };
        this._loopExtensions.forEach(childAppendable, _literals, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
        Iterable<JvmMember> _membersToBeCompiled = this.getMembersToBeCompiled((JvmDeclaredType)it);
        Functions.Function1<JvmMember, Boolean> _function_2 = new Functions.Function1<JvmMember, Boolean>(){

            public Boolean apply(JvmMember it) {
                return !(it instanceof JvmEnumerationLiteral);
            }
        };
        Iterable _filter = IterableExtensions.filter(_membersToBeCompiled, (Functions.Function1)_function_2);
        Procedures.Procedure1<LoopParams> _function_3 = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                    public ITreeAppendable apply(ITreeAppendable it) {
                        return it.newLine();
                    }
                };
                it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)_function);
            }
        };
        Procedures.Procedure1<JvmMember> _function_4 = new Procedures.Procedure1<JvmMember>(){

            public void apply(JvmMember it) {
                ITreeAppendable _trace = childAppendable.trace((EObject)it);
                JvmModelGenerator.this.generateMember(it, _trace, config);
            }
        };
        this._loopExtensions.forEach(childAppendable, _filter, (Procedures.Procedure1<? super LoopParams>)_function_3, _function_4);
        ITreeAppendable _decreaseIndentation = childAppendable.decreaseIndentation();
        ITreeAppendable _newLine = _decreaseIndentation.newLine();
        _newLine.append("}");
        ITreeAppendable _xifexpression = null;
        EObject _eContainer = it.eContainer();
        boolean bl = _not = !(_eContainer instanceof JvmType);
        if (_not) {
            _xifexpression = appendable.newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void generateEnumLiteral(JvmEnumerationLiteral it, ITreeAppendable appendable, GeneratorConfig config) {
        appendable.newLine();
        this.generateJavaDoc((EObject)it, appendable, config);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, appendable, true, config);
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        appendable.append(_makeJavaIdentifier);
    }

    protected ITreeAppendable _generateBody(JvmAnnotationType it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable childAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, childAppendable, true, config);
        this.generateModifier((JvmMember)it, childAppendable, config);
        childAppendable.append("@interface ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        _traceSignificant.append(_makeJavaIdentifier);
        childAppendable.append(" {");
        Iterable<JvmMember> _membersToBeCompiled = this.getMembersToBeCompiled((JvmDeclaredType)it);
        Iterable _filter = Iterables.filter(_membersToBeCompiled, JvmDeclaredType.class);
        for (JvmDeclaredType innerType : _filter) {
            ITreeAppendable innerTypeAppendable = childAppendable.trace((EObject)innerType);
            innerTypeAppendable.increaseIndentation();
            this.generateMember((JvmMember)innerType, innerTypeAppendable, config);
            innerTypeAppendable.decreaseIndentation();
        }
        Iterable<JvmMember> _membersToBeCompiled_1 = this.getMembersToBeCompiled((JvmDeclaredType)it);
        Iterable _filter_1 = Iterables.filter(_membersToBeCompiled_1, JvmOperation.class);
        for (JvmOperation operation : _filter_1) {
            this.generateAnnotationMethod(operation, childAppendable, config);
        }
        ITreeAppendable _newLine = childAppendable.newLine();
        _newLine.append("}");
        ITreeAppendable _xifexpression = null;
        EObject _eContainer = it.eContainer();
        boolean bl = _not = !(_eContainer instanceof JvmType);
        if (_not) {
            _xifexpression = appendable.newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void generateAnnotationMethod(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
        _increaseIndentation.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        JvmTypeReference _returnType = it.getReturnType();
        this._errorSafeExtensions.serializeSafely(_returnType, "Object", tracedAppendable);
        tracedAppendable.append(" ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        _traceSignificant.append(_makeJavaIdentifier);
        tracedAppendable.append("()");
        this.generateDefaultExpression(it, tracedAppendable, config);
        tracedAppendable.append(";");
        appendable.decreaseIndentation();
        appendable.closeScope();
    }

    public void generateDefaultExpression(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _notEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
        boolean bl = _notEquals = !Objects.equal(_compilationStrategy, null);
        if (_notEquals) {
            appendable.append(" default ");
            appendable.increaseIndentation();
            Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy_1 = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
            _compilationStrategy_1.apply((Object)appendable);
            appendable.decreaseIndentation();
        } else {
            boolean _notEquals_1;
            StringConcatenationClient _compilationTemplate = this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)it);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_compilationTemplate, null);
            if (_notEquals_1) {
                ITreeAppendable _append = appendable.append(" default ");
                _append.increaseIndentation();
                this.appendCompilationTemplate(appendable, (JvmIdentifiableElement)it);
                appendable.decreaseIndentation();
            } else {
                boolean _isGenerateExpressions = config.isGenerateExpressions();
                if (_isGenerateExpressions) {
                    boolean _notEquals_2;
                    XExpression body = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
                    boolean bl3 = _notEquals_2 = !Objects.equal((Object)body, null);
                    if (_notEquals_2) {
                        boolean _hasErrors = this._errorSafeExtensions.hasErrors(body);
                        if (_hasErrors) {
                            appendable.append("/* skipped default expression with errors */");
                        } else {
                            appendable.append(" default ");
                            JvmTypeReference _returnType = it.getReturnType();
                            this.compiler.compileAsJavaExpression(body, appendable, _returnType);
                        }
                    } else {
                        boolean _notEquals_3;
                        JvmAnnotationValue _defaultValue = it.getDefaultValue();
                        boolean bl4 = _notEquals_3 = !Objects.equal((Object)_defaultValue, null);
                        if (_notEquals_3) {
                            JvmAnnotationValue _defaultValue_1 = it.getDefaultValue();
                            boolean _hasErrors_1 = this._errorSafeExtensions.hasErrors((EObject)_defaultValue_1);
                            if (_hasErrors_1) {
                                appendable.append("/* skipped default expression with errors */");
                            } else {
                                appendable.append(" default ");
                                JvmAnnotationValue _defaultValue_2 = it.getDefaultValue();
                                this.toJavaLiteral(_defaultValue_2, appendable, config);
                            }
                        }
                    }
                }
            }
        }
    }

    private void appendCompilationTemplate(ITreeAppendable appendable, JvmIdentifiableElement it) {
        boolean _matched = false;
        if (!_matched && appendable instanceof TreeAppendable) {
            _matched = true;
            SharedAppendableState _state = ((TreeAppendable)appendable).getState();
            StandardTypeReferenceOwner _standardTypeReferenceOwner = new StandardTypeReferenceOwner(this.commonServices, (EObject)it);
            ImportingStringConcatenation target = this.createImportingStringConcatenation(_state, _standardTypeReferenceOwner);
            StringConcatenationClient _compilationTemplate = this._jvmTypeExtensions.getCompilationTemplate(it);
            target.append(_compilationTemplate);
            ((TreeAppendable)appendable).append((CharSequence)((Object)target));
        }
        if (!_matched) {
            Class<?> _class = appendable.getClass();
            String _name = _class.getName();
            String _plus = "unexpected appendable: " + _name;
            throw new IllegalStateException(_plus);
        }
    }

    protected ImportingStringConcatenation createImportingStringConcatenation(SharedAppendableState state, ITypeReferenceOwner owner) {
        return new ImportingStringConcatenation(state, owner);
    }

    protected ITreeAppendable _generateModifier(JvmGenericType it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isFinal;
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        this.generateVisibilityModifier((JvmMember)it, appendable);
        boolean _isInterface = it.isInterface();
        boolean bl = _not = !_isInterface;
        if (_not) {
            boolean _isAbstract;
            boolean _isStatic = it.isStatic();
            if (_isStatic) {
                appendable.append("static ");
            }
            if (_isAbstract = it.isAbstract()) {
                appendable.append("abstract ");
            }
        }
        if (_isFinal = it.isFinal()) {
            appendable.append("final ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isStrictFloatingPoint = it.isStrictFloatingPoint();
        if (_isStrictFloatingPoint) {
            _xifexpression = appendable.append("strictfp ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        return this.generateVisibilityModifier((JvmMember)it, appendable);
    }

    protected ITreeAppendable _generateModifier(JvmField it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isTransient;
        boolean _isStatic;
        ITreeAppendable _xblockexpression = null;
        this.generateVisibilityModifier((JvmMember)it, appendable);
        boolean _isFinal = it.isFinal();
        if (_isFinal) {
            appendable.append("final ");
        }
        if (_isStatic = it.isStatic()) {
            appendable.append("static ");
        }
        if (_isTransient = it.isTransient()) {
            appendable.append("transient ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isVolatile = it.isVolatile();
        if (_isVolatile) {
            _xifexpression = appendable.append("volatile ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isStrictFloatingPoint;
        boolean _isSynchronized;
        boolean _isFinal;
        boolean _isStatic_1;
        boolean _not_1;
        boolean _not;
        boolean _isStatic;
        ITreeAppendable _xblockexpression = null;
        this.generateVisibilityModifier((JvmMember)it, appendable);
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            appendable.append("abstract ");
        }
        if (_isStatic = it.isStatic()) {
            appendable.append("static ");
        }
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        boolean _and_3 = false;
        boolean _isAbstract_1 = it.isAbstract();
        boolean bl = _not = !_isAbstract_1;
        _and_3 = !_not ? false : (_not_1 = !(_isStatic_1 = it.isStatic()));
        if (!_and_3) {
            _and_2 = false;
        } else {
            boolean _isAtLeast;
            JavaVersion _javaSourceVersion = config.getJavaSourceVersion();
            _and_2 = _isAtLeast = _javaSourceVersion.isAtLeast(JavaVersion.JAVA8);
        }
        if (!_and_2) {
            _and_1 = false;
        } else {
            EObject _eContainer = it.eContainer();
            _and_1 = _eContainer instanceof JvmGenericType;
        }
        if (!_and_1) {
            _and = false;
        } else {
            boolean _isInterface;
            EObject _eContainer_1 = it.eContainer();
            _and = _isInterface = ((JvmGenericType)_eContainer_1).isInterface();
        }
        if (_and) {
            appendable.append("default ");
        }
        if (_isFinal = it.isFinal()) {
            appendable.append("final ");
        }
        if (_isSynchronized = it.isSynchronized()) {
            appendable.append("synchronized ");
        }
        if (_isStrictFloatingPoint = it.isStrictFloatingPoint()) {
            appendable.append("strictfp ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isNative = it.isNative();
        if (_isNative) {
            _xifexpression = appendable.append("native ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ITreeAppendable generateVisibilityModifier(JvmMember it, ITreeAppendable result) {
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        return result.append(_javaName);
    }

    protected ITreeAppendable _generateModifier(JvmConstructor it, ITreeAppendable appendable, GeneratorConfig config) {
        return this.generateVisibilityModifier((JvmMember)it, appendable);
    }

    public String javaName(JvmVisibility visibility) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)visibility, null);
        if (_notEquals) {
            String _switchResult = null;
            if (visibility != null) {
                switch (visibility) {
                    case PRIVATE: {
                        _switchResult = "private ";
                        break;
                    }
                    case PUBLIC: {
                        _switchResult = "public ";
                        break;
                    }
                    case PROTECTED: {
                        _switchResult = "protected ";
                        break;
                    }
                    case DEFAULT: {
                        _switchResult = "";
                        break;
                    }
                }
            }
            return _switchResult;
        }
        return "";
    }

    public void generateExtendsClause(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && it instanceof JvmAnnotationType) {
            _matched = true;
            _switchResult = "java.lang.Annotation";
        }
        if (!_matched && it instanceof JvmEnumerationType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"java.lang.Enum<");
            String _identifier = ((JvmEnumerationType)it).getIdentifier();
            _builder.append((Object)_identifier, "");
            _builder.append((Object)">");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            _switchResult = "java.lang.Object";
        }
        final String implicitSuperType = _switchResult;
        boolean _or = false;
        if (it instanceof JvmAnnotationType) {
            _or = true;
        } else {
            boolean _isInterface;
            boolean _and = false;
            _and = !(it instanceof JvmGenericType) ? false : (_isInterface = ((JvmGenericType)it).isInterface());
            _or = _and;
        }
        if (_or) {
            EList _superTypes = it.getSuperTypes();
            Functions.Function1<JvmTypeReference, Boolean> _function = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    String _identifier = typeRef.getIdentifier();
                    return !Objects.equal((Object)_identifier, (Object)implicitSuperType);
                }
            };
            Iterable withoutObject = IterableExtensions.filter((Iterable)_superTypes, (Functions.Function1)_function);
            Procedures.Procedure1<LoopParams> _function_1 = new Procedures.Procedure1<LoopParams>(){

                public void apply(LoopParams it) {
                    it.setPrefix("extends ");
                    it.setSeparator(", ");
                    it.setSuffix(" ");
                }
            };
            Procedures.Procedure2<JvmTypeReference, ITreeAppendable> _function_2 = new Procedures.Procedure2<JvmTypeReference, ITreeAppendable>(){

                public void apply(JvmTypeReference it, ITreeAppendable app) {
                    JvmModelGenerator.this._errorSafeExtensions.serializeSafely(it, app);
                }
            };
            this._errorSafeExtensions.forEachSafely(appendable, withoutObject, (Procedures.Procedure1<? super LoopParams>)_function_1, _function_2);
        } else {
            boolean _notEquals;
            EList _superTypes_1 = it.getSuperTypes();
            Functions.Function1<JvmTypeReference, Boolean> _function_3 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    String _identifier = typeRef.getIdentifier();
                    return !Objects.equal((Object)_identifier, (Object)implicitSuperType);
                }
            };
            Iterable withoutObject_1 = IterableExtensions.filter((Iterable)_superTypes_1, (Functions.Function1)_function_3);
            Functions.Function1<JvmTypeReference, Boolean> _function_4 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    JvmType _type_1;
                    boolean _isInterface;
                    boolean _not;
                    boolean _and = false;
                    JvmType _type = typeRef.getType();
                    _and = !(_type instanceof JvmGenericType) ? false : (_not = !(_isInterface = ((JvmGenericType)(_type_1 = typeRef.getType())).isInterface()));
                    return _and;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)withoutObject_1, (Functions.Function1)_function_4);
            final JvmTypeReference superClazz = (JvmTypeReference)IterableExtensions.head((Iterable)_filter);
            Functions.Function1<JvmTypeReference, Boolean> _function_5 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    return !Objects.equal((Object)typeRef, (Object)superClazz);
                }
            };
            Iterable superInterfaces = IterableExtensions.filter((Iterable)withoutObject_1, (Functions.Function1)_function_5);
            boolean bl = _notEquals = !Objects.equal((Object)superClazz, null);
            if (_notEquals) {
                boolean hasErrors = this._errorSafeExtensions.hasErrors((EObject)superClazz);
                if (hasErrors) {
                    appendable.append("/* ");
                }
                try {
                    appendable.append("extends ");
                    this._errorSafeExtensions.serializeSafely(superClazz, appendable);
                    appendable.append(" ");
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception cfr_ignored_0 = (Exception)_t;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                if (hasErrors) {
                    appendable.append(" */");
                }
            }
            Procedures.Procedure1<LoopParams> _function_6 = new Procedures.Procedure1<LoopParams>(){

                public void apply(LoopParams it) {
                    it.setPrefix("implements ");
                    it.setSeparator(", ");
                    it.setSuffix(" ");
                }
            };
            Procedures.Procedure2<JvmTypeReference, ITreeAppendable> _function_7 = new Procedures.Procedure2<JvmTypeReference, ITreeAppendable>(){

                public void apply(JvmTypeReference it, ITreeAppendable app) {
                    JvmModelGenerator.this._errorSafeExtensions.serializeSafely(it, app);
                }
            };
            this._errorSafeExtensions.forEachSafely(appendable, superInterfaces, (Procedures.Procedure1<? super LoopParams>)_function_6, _function_7);
        }
    }

    protected ITreeAppendable _generateMember(JvmMember it, ITreeAppendable appendable, GeneratorConfig config) {
        Class<?> _class = null;
        if (it != null) {
            _class = it.getClass();
        }
        String _name = null;
        if (_class != null) {
            _name = _class.getName();
        }
        String _plus = "generateMember not implemented for elements of type " + _name;
        throw new UnsupportedOperationException(_plus);
    }

    protected ITreeAppendable _generateMember(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        appendable.openScope();
        this.assignThisAndSuper(appendable, it, config);
        ITreeAppendable _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = this.generateBody(it, appendable, config);
        }
        finally {
            appendable.closeScope();
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateMember(JvmField it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        JvmTypeReference _type = it.getType();
        this._errorSafeExtensions.serializeSafely(_type, "Object", tracedAppendable);
        tracedAppendable.append(" ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        _traceSignificant.append(_makeJavaIdentifier);
        this.generateInitialization(it, tracedAppendable, config);
        _xblockexpression = tracedAppendable.append(";");
        return _xblockexpression;
    }

    protected ITreeAppendable _generateMember(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _hasBody;
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable, config);
        JvmTypeReference _returnType = it.getReturnType();
        boolean _equals = Objects.equal((Object)_returnType, null);
        if (_equals) {
            tracedAppendable.append("void");
        } else {
            JvmTypeReference _returnType_1 = it.getReturnType();
            this._errorSafeExtensions.serializeSafely(_returnType_1, "Object", tracedAppendable);
        }
        tracedAppendable.append(" ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        _traceSignificant.append(_makeJavaIdentifier);
        tracedAppendable.append("(");
        this.generateParameters((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append(")");
        this.generateThrowsClause((JvmExecutable)it, tracedAppendable, config);
        boolean _or = false;
        boolean _isAbstract = it.isAbstract();
        _or = _isAbstract ? true : (_not = !(_hasBody = this.hasBody((JvmExecutable)it)));
        if (_or) {
            tracedAppendable.append(";");
        } else {
            tracedAppendable.append(" ");
            this.generateExecutableBody((JvmExecutable)it, tracedAppendable, config);
        }
        appendable.closeScope();
        _xblockexpression = appendable;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateMember(JvmConstructor it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable, config);
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        _traceSignificant.append(_makeJavaIdentifier);
        tracedAppendable.append("(");
        this.generateParameters((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append(")");
        this.generateThrowsClause((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append(" ");
        this.generateExecutableBody((JvmExecutable)it, tracedAppendable, config);
        appendable.closeScope();
        _xblockexpression = appendable;
        return _xblockexpression;
    }

    public void generateInitialization(JvmField it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _notEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
        boolean bl = _notEquals = !Objects.equal(_compilationStrategy, null);
        if (_notEquals) {
            Iterable<Issue> errors = this.getDirectErrorsOrLogicallyContainedErrors((JvmFeature)it);
            boolean _isEmpty = IterableExtensions.isEmpty(errors);
            if (_isEmpty) {
                appendable.append(" = ");
                appendable.increaseIndentation();
                Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy_1 = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
                _compilationStrategy_1.apply((Object)appendable);
                appendable.decreaseIndentation();
            } else {
                appendable.append(" /* Skipped initializer because of errors */");
            }
        } else {
            boolean _notEquals_1;
            StringConcatenationClient _compilationTemplate = this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)it);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_compilationTemplate, null);
            if (_notEquals_1) {
                Iterable<Issue> errors_1 = this.getDirectErrorsOrLogicallyContainedErrors((JvmFeature)it);
                boolean _isEmpty_1 = IterableExtensions.isEmpty(errors_1);
                if (_isEmpty_1) {
                    ITreeAppendable _append = appendable.append(" = ");
                    _append.increaseIndentation();
                    this.appendCompilationTemplate(appendable, (JvmIdentifiableElement)it);
                    appendable.decreaseIndentation();
                } else {
                    appendable.append(" /* Skipped initializer because of errors */");
                }
            } else {
                boolean _isGenerateExpressions;
                XExpression expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
                boolean _and = false;
                boolean _notEquals_2 = !Objects.equal((Object)expression, null);
                _and = !_notEquals_2 ? false : (_isGenerateExpressions = config.isGenerateExpressions());
                if (_and) {
                    boolean _hasErrors = this._errorSafeExtensions.hasErrors(expression);
                    if (_hasErrors) {
                        appendable.append(" /* Skipped initializer because of errors */");
                    } else {
                        appendable.append(" = ");
                        JvmTypeReference _type = it.getType();
                        this.compiler.compileAsJavaExpression(expression, appendable, _type);
                    }
                }
            }
        }
    }

    public void generateTypeParameterDeclaration(JvmTypeParameterDeclarator it, final ITreeAppendable appendable, final GeneratorConfig config) {
        EList _typeParameters = it.getTypeParameters();
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                it.setPrefix("<");
                it.setSeparator(", ");
                it.setSuffix("> ");
            }
        };
        Procedures.Procedure1<JvmTypeParameter> _function_1 = new Procedures.Procedure1<JvmTypeParameter>(){

            public void apply(JvmTypeParameter it) {
                JvmModelGenerator.this.generateTypeParameterDeclaration(it, appendable, config);
            }
        };
        this._loopExtensions.forEach(appendable, _typeParameters, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void generateTypeParameterDeclaration(JvmTypeParameter it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _name = it.getName();
        _traceSignificant.append(_name);
        this.generateTypeParameterConstraints(it, tracedAppendable, config);
    }

    public void generateTypeParameterConstraints(JvmTypeParameter it, ITreeAppendable appendable, GeneratorConfig config) {
        EList _constraints = it.getConstraints();
        Iterable upperBounds = Iterables.filter((Iterable)_constraints, JvmUpperBound.class);
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                it.setPrefix(" extends ");
                it.setSeparator(" & ");
            }
        };
        Procedures.Procedure2<JvmUpperBound, ITreeAppendable> _function_1 = new Procedures.Procedure2<JvmUpperBound, ITreeAppendable>(){

            public void apply(JvmUpperBound it, ITreeAppendable app) {
                JvmTypeReference _typeReference = it.getTypeReference();
                JvmModelGenerator.this._errorSafeExtensions.serializeSafely(_typeReference, app);
            }
        };
        this._errorSafeExtensions.forEachSafely(appendable, upperBounds, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void generateThrowsClause(JvmExecutable it, ITreeAppendable appendable, GeneratorConfig config) {
        final LinkedHashMap toBeGenerated = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        EList _exceptions = it.getExceptions();
        Procedures.Procedure1<JvmTypeReference> _function = new Procedures.Procedure1<JvmTypeReference>(){

            public void apply(JvmTypeReference it) {
                boolean _not;
                JvmType _type = it.getType();
                boolean _containsKey = toBeGenerated.containsKey(_type);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    JvmType _type_1 = it.getType();
                    toBeGenerated.put(_type_1, it);
                }
            }
        };
        IterableExtensions.forEach((Iterable)_exceptions, (Procedures.Procedure1)_function);
        Collection _values = toBeGenerated.values();
        Procedures.Procedure1<LoopParams> _function_1 = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                it.setPrefix(" throws ");
                it.setSeparator(", ");
            }
        };
        Procedures.Procedure2<JvmTypeReference, ITreeAppendable> _function_2 = new Procedures.Procedure2<JvmTypeReference, ITreeAppendable>(){

            public void apply(JvmTypeReference it, ITreeAppendable app) {
                ITreeAppendable _trace = app.trace((EObject)it);
                JvmType _type = it.getType();
                _trace.append(_type);
            }
        };
        this._errorSafeExtensions.forEachSafely(appendable, _values, (Procedures.Procedure1<? super LoopParams>)_function_1, _function_2);
    }

    public void generateParameters(JvmExecutable it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _not;
        EList _parameters = it.getParameters();
        boolean _isEmpty = _parameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList _parameters_1 = it.getParameters();
            int _size = _parameters_1.size();
            int _minus = _size - 1;
            IntegerRange _upTo = new IntegerRange(0, _minus);
            for (Integer i : _upTo) {
                boolean _isVarArgs;
                EList _parameters_2 = it.getParameters();
                int _size_1 = _parameters_2.size();
                boolean last = i + 1 == _size_1;
                EList _parameters_3 = it.getParameters();
                JvmFormalParameter p = (JvmFormalParameter)_parameters_3.get(i.intValue());
                boolean _and = false;
                _and = !last ? false : (_isVarArgs = it.isVarArgs());
                this.generateParameter(p, appendable, _and, config);
                if (last) continue;
                appendable.append(", ");
            }
        }
    }

    public void generateParameter(JvmFormalParameter it, ITreeAppendable appendable, boolean vararg, GeneratorConfig config) {
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, false, config);
        tracedAppendable.append("final ");
        if (vararg) {
            boolean _not;
            JvmTypeReference _parameterType = it.getParameterType();
            boolean bl = _not = !(_parameterType instanceof JvmGenericArrayTypeReference);
            if (_not) {
                tracedAppendable.append("/* Internal Error: Parameter was vararg but not an array type. */");
            } else {
                JvmTypeReference _parameterType_1 = it.getParameterType();
                JvmTypeReference _componentType = ((JvmGenericArrayTypeReference)_parameterType_1).getComponentType();
                this._errorSafeExtensions.serializeSafely(_componentType, "Object", tracedAppendable);
            }
            tracedAppendable.append("...");
        } else {
            JvmTypeReference _parameterType_2 = it.getParameterType();
            this._errorSafeExtensions.serializeSafely(_parameterType_2, "Object", tracedAppendable);
        }
        tracedAppendable.append(" ");
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        String name = tracedAppendable.declareVariable(it, _makeJavaIdentifier);
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        _traceSignificant.append(name);
    }

    public boolean hasBody(JvmExecutable it) {
        XExpression _associatedExpression;
        boolean _notEquals_2;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _or = false;
        boolean _or_1 = false;
        StringConcatenationClient _compilationTemplate = this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)it);
        boolean bl = _notEquals = !Objects.equal((Object)_compilationTemplate, null);
        _or_1 = _notEquals ? true : (_notEquals_1 = !Objects.equal(_compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it), null));
        _or = _or_1 ? true : (_notEquals_2 = !Objects.equal((Object)(_associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it)), null));
        return _or;
    }

    private Iterable<Issue> getDirectErrorsOrLogicallyContainedErrors(JvmFeature feature) {
        Iterable<Issue> errors = this._errorSafeExtensions.getErrors((EObject)feature);
        boolean _isEmpty = IterableExtensions.isEmpty(errors);
        if (_isEmpty) {
            boolean _notEquals;
            XExpression expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)feature);
            boolean bl = _notEquals = !Objects.equal((Object)expression, null);
            if (_notEquals) {
                Iterable<Issue> _errors;
                errors = _errors = this._errorSafeExtensions.getErrors(expression);
            }
        }
        return errors;
    }

    public void generateExecutableBody(JvmExecutable op, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _notEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)op);
        boolean bl = _notEquals = !Objects.equal(_compilationStrategy, null);
        if (_notEquals) {
            Iterable<Issue> errors = this.getDirectErrorsOrLogicallyContainedErrors((JvmFeature)op);
            boolean _isEmpty = IterableExtensions.isEmpty(errors);
            if (_isEmpty) {
                ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
                ITreeAppendable _append = _increaseIndentation.append("{");
                _append.newLine();
                Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy_1 = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)op);
                _compilationStrategy_1.apply((Object)appendable);
                ITreeAppendable _decreaseIndentation = appendable.decreaseIndentation();
                ITreeAppendable _newLine = _decreaseIndentation.newLine();
                _newLine.append("}");
            } else {
                this.generateBodyWithIssues(appendable, errors);
            }
        } else {
            boolean _notEquals_1;
            StringConcatenationClient _compilationTemplate = this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)op);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_compilationTemplate, null);
            if (_notEquals_1) {
                Iterable<Issue> errors_1 = this.getDirectErrorsOrLogicallyContainedErrors((JvmFeature)op);
                boolean _isEmpty_1 = IterableExtensions.isEmpty(errors_1);
                if (_isEmpty_1) {
                    ITreeAppendable _increaseIndentation_1 = appendable.increaseIndentation();
                    ITreeAppendable _append_1 = _increaseIndentation_1.append("{");
                    _append_1.newLine();
                    this.appendCompilationTemplate(appendable, (JvmIdentifiableElement)op);
                    ITreeAppendable _decreaseIndentation_1 = appendable.decreaseIndentation();
                    ITreeAppendable _newLine_1 = _decreaseIndentation_1.newLine();
                    _newLine_1.append("}");
                } else {
                    this.generateBodyWithIssues(appendable, errors_1);
                }
            } else {
                boolean _isGenerateExpressions;
                XExpression expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)op);
                boolean _and = false;
                boolean _notEquals_2 = !Objects.equal((Object)expression, null);
                _and = !_notEquals_2 ? false : (_isGenerateExpressions = config.isGenerateExpressions());
                if (_and) {
                    Iterable<Issue> errors_2 = this._errorSafeExtensions.getErrors(expression);
                    boolean _isEmpty_2 = IterableExtensions.isEmpty(errors_2);
                    if (_isEmpty_2) {
                        JvmTypeReference _switchResult = null;
                        boolean _matched = false;
                        if (!_matched && op instanceof JvmOperation) {
                            _matched = true;
                            _switchResult = ((JvmOperation)op).getReturnType();
                        }
                        if (!_matched && op instanceof JvmConstructor) {
                            _matched = true;
                            _switchResult = this._typeReferences.getTypeForName(Void.TYPE, (Notifier)op, new JvmTypeReference[0]);
                        }
                        if (!_matched) {
                            _switchResult = null;
                        }
                        JvmTypeReference returnType = _switchResult;
                        ITreeAppendable _append_2 = appendable.append("{");
                        _append_2.increaseIndentation();
                        this.compile(op, expression, returnType, appendable, config);
                        ITreeAppendable _decreaseIndentation_2 = appendable.decreaseIndentation();
                        ITreeAppendable _newLine_2 = _decreaseIndentation_2.newLine();
                        _newLine_2.append("}");
                    } else {
                        this.generateBodyWithIssues(appendable, errors_2);
                    }
                } else if (op instanceof JvmOperation) {
                    ITreeAppendable _increaseIndentation_2 = appendable.increaseIndentation();
                    ITreeAppendable _append_3 = _increaseIndentation_2.append("{");
                    _append_3.newLine();
                    appendable.append("throw new UnsupportedOperationException(\"");
                    String _simpleName = ((JvmOperation)op).getSimpleName();
                    appendable.append(_simpleName);
                    appendable.append(" is not implemented\");");
                    ITreeAppendable _decreaseIndentation_3 = appendable.decreaseIndentation();
                    ITreeAppendable _newLine_3 = _decreaseIndentation_3.newLine();
                    _newLine_3.append("}");
                } else if (op instanceof JvmConstructor) {
                    ITreeAppendable _append_4 = appendable.append("{");
                    ITreeAppendable _newLine_4 = _append_4.newLine();
                    _newLine_4.append("}");
                }
            }
        }
    }

    public ITreeAppendable compile(JvmExecutable executable, XExpression expression, JvmTypeReference returnType, ITreeAppendable appendable, GeneratorConfig config) {
        EList _exceptions = executable.getExceptions();
        Set _set = IterableExtensions.toSet((Iterable)_exceptions);
        return this.compiler.compile(expression, appendable, returnType, (Set<JvmTypeReference>)_set);
    }

    public void assignThisAndSuper(ITreeAppendable b, JvmDeclaredType declaredType, GeneratorConfig config) {
        this.reassignSuperType(b, declaredType, config);
        this.reassignThisType(b, declaredType);
    }

    private String reassignSuperType(ITreeAppendable b, JvmDeclaredType declaredType, GeneratorConfig config) {
        boolean _notEquals;
        JavaVersion _javaSourceVersion;
        boolean _isAtLeast;
        Object superElement;
        String superVariable;
        boolean _equals;
        Object element;
        String _xblockexpression = null;
        JvmTypeReference _extendedClass = declaredType.getExtendedClass();
        JvmType _type = null;
        if (_extendedClass != null) {
            _type = _extendedClass.getType();
        }
        JvmType superType = _type;
        boolean _hasObject = b.hasObject("super");
        if (_hasObject && (element = b.getObject("this")) instanceof JvmDeclaredType && (_equals = "super".equals(superVariable = b.getName(superElement = b.getObject("super"))))) {
            String _simpleName = ((JvmDeclaredType)element).getSimpleName();
            String proposedName = String.valueOf(_simpleName) + ".super";
            b.declareVariable(superElement, proposedName);
        }
        if (_isAtLeast = (_javaSourceVersion = config.getJavaSourceVersion()).isAtLeast(JavaVersion.JAVA8)) {
            Iterable _extendedInterfaces = declaredType.getExtendedInterfaces();
            for (JvmTypeReference interfaceRef : _extendedInterfaces) {
                JvmType interfaze = interfaceRef.getType();
                String _simpleName_1 = interfaze.getSimpleName();
                String simpleVarName = String.valueOf(_simpleName_1) + ".super";
                boolean _hasObject_1 = b.hasObject(simpleVarName);
                if (_hasObject_1) {
                    boolean _notEquals2;
                    Object element_1 = b.getObject(simpleVarName);
                    boolean bl = _notEquals2 = !Objects.equal((Object)element_1, (Object)interfaceRef);
                    if (!_notEquals2) continue;
                    String _qualifiedName = interfaze.getQualifiedName();
                    String qualifiedVarName = String.valueOf(_qualifiedName) + ".super";
                    b.declareVariable(interfaze, qualifiedVarName);
                    continue;
                }
                b.declareVariable(interfaze, simpleVarName);
            }
        }
        String _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)superType, null);
        if (_notEquals) {
            _xifexpression = b.declareVariable(superType, "super");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected String reassignThisType(ITreeAppendable b, JvmDeclaredType declaredType) {
        boolean _notEquals;
        Object element;
        String _xblockexpression = null;
        boolean _hasObject = b.hasObject("this");
        if (_hasObject && (element = b.getObject("this")) instanceof JvmDeclaredType) {
            boolean _isLocal = ((JvmDeclaredType)element).isLocal();
            if (_isLocal) {
                b.declareVariable(element, "");
            } else {
                String _simpleName = ((JvmDeclaredType)element).getSimpleName();
                String proposedName = String.valueOf(_simpleName) + ".this";
                b.declareVariable(element, proposedName);
            }
        }
        String _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)declaredType, null);
        if (_notEquals) {
            _xifexpression = b.declareVariable(declaredType, "this");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ITreeAppendable generateBodyWithIssues(final ITreeAppendable appendable, Iterable<Issue> errors) {
        ITreeAppendable _xblockexpression = null;
        ITreeAppendable _append = appendable.append("{");
        ITreeAppendable _increaseIndentation = _append.increaseIndentation();
        ITreeAppendable _newLine = _increaseIndentation.newLine();
        _newLine.append("throw new Error(\"Unresolved compilation problems:\"");
        appendable.increaseIndentation();
        Procedures.Procedure1<Issue> _function = new Procedures.Procedure1<Issue>(){

            public void apply(Issue it) {
                ITreeAppendable _newLine = appendable.newLine();
                ITreeAppendable _append = _newLine.append("+ \"\\n");
                String _message = it.getMessage();
                String _doConvertToJavaString = JvmModelGenerator.this.doConvertToJavaString(_message);
                ITreeAppendable _append_1 = _append.append(_doConvertToJavaString);
                _append_1.append("\"");
            }
        };
        IterableExtensions.forEach(errors, (Procedures.Procedure1)_function);
        ITreeAppendable _append_1 = appendable.append(");");
        ITreeAppendable _decreaseIndentation = _append_1.decreaseIndentation();
        ITreeAppendable _decreaseIndentation_1 = _decreaseIndentation.decreaseIndentation();
        ITreeAppendable _newLine_1 = _decreaseIndentation_1.newLine();
        _xblockexpression = _newLine_1.append("}");
        return _xblockexpression;
    }

    protected String doConvertToJavaString(String input) {
        return Strings.convertToJavaString((String)input, (boolean)true);
    }

    public void generateFileHeader(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isNullOrEmpty;
        boolean _not;
        EList _eAdapters = it.eAdapters();
        Iterable _filter = Iterables.filter((Iterable)_eAdapters, FileHeaderAdapter.class);
        FileHeaderAdapter fileHeaderAdapter = (FileHeaderAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        String _headerText = null;
        if (fileHeaderAdapter != null) {
            _headerText = fileHeaderAdapter.getHeaderText();
        }
        boolean bl = _not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_headerText));
        if (_not) {
            String _headerText_1 = fileHeaderAdapter.getHeaderText();
            Resource _eResource = it.eResource();
            List _fileHeaderNodes = this.fileHeaderProvider.getFileHeaderNodes(_eResource);
            this.generateDocumentation(_headerText_1, _fileHeaderNodes, appendable, config);
        }
    }

    public void generateJavaDoc(EObject it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isNullOrEmpty;
        boolean _not;
        EList _eAdapters = it.eAdapters();
        Iterable _filter = Iterables.filter((Iterable)_eAdapters, DocumentationAdapter.class);
        DocumentationAdapter adapter = (DocumentationAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        String _documentation = null;
        if (adapter != null) {
            _documentation = adapter.getDocumentation();
        }
        boolean bl = _not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_documentation));
        if (_not) {
            Set<EObject> sourceElements = this.getSourceElements(it);
            boolean _and = false;
            int _size = sourceElements.size();
            boolean _equals = _size == 1;
            _and = !_equals ? false : this.documentationProvider instanceof IEObjectDocumentationProviderExtension;
            if (_and) {
                EObject _head = (EObject)IterableExtensions.head(sourceElements);
                List documentationNodes = ((IEObjectDocumentationProviderExtension)this.documentationProvider).getDocumentationNodes(_head);
                this.addJavaDocImports(it, appendable, documentationNodes);
                String _documentation_1 = adapter.getDocumentation();
                this.generateDocumentation(_documentation_1, documentationNodes, appendable, config);
            } else {
                String _documentation_2 = adapter.getDocumentation();
                List _emptyList = CollectionLiterals.emptyList();
                this.generateDocumentation(_documentation_2, _emptyList, appendable, config);
            }
        }
    }

    public void addJavaDocImports(EObject it, ITreeAppendable appendable, List<INode> documentationNodes) {
        for (INode node : documentationNodes) {
            List _computeTypeRefRegions = this.javaDocTypeReferenceProvider.computeTypeRefRegions(node);
            for (ReplaceRegion region : _computeTypeRefRegions) {
                String _packageName_1;
                boolean _notEquals_3;
                boolean _eIsProxy_1;
                boolean _not;
                boolean _notEquals_2;
                boolean _notEquals_1;
                boolean _equals;
                int _length;
                boolean _greaterThan;
                boolean _notEquals;
                String text = region.getText();
                boolean _and = false;
                boolean bl = _notEquals = !Objects.equal((Object)text, null);
                _and = !_notEquals ? false : (_greaterThan = (_length = text.length()) > 0);
                if (!_and) continue;
                QualifiedName fqn = this.qualifiedNameConverter.toQualifiedName(text);
                EObject context = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                boolean _and_1 = false;
                int _segmentCount = fqn.getSegmentCount();
                boolean bl2 = _equals = _segmentCount == 1;
                _and_1 = !_equals ? false : (_notEquals_1 = !Objects.equal((Object)context, null));
                if (!_and_1) continue;
                IScope scope = this.scopeProvider.getScope(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
                IEObjectDescription candidate = scope.getSingleElement(fqn);
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)candidate, null);
                if (!_notEquals_2) continue;
                EObject _xifexpression = null;
                EObject _eObjectOrProxy = candidate.getEObjectOrProxy();
                boolean _eIsProxy = _eObjectOrProxy.eIsProxy();
                if (_eIsProxy) {
                    EObject _eObjectOrProxy_1 = candidate.getEObjectOrProxy();
                    _xifexpression = EcoreUtil.resolve((EObject)_eObjectOrProxy_1, (EObject)context);
                } else {
                    _xifexpression = candidate.getEObjectOrProxy();
                }
                JvmType jvmType = (JvmType)_xifexpression;
                boolean _and_2 = false;
                _and_2 = !(jvmType instanceof JvmDeclaredType) ? false : (_not = !(_eIsProxy_1 = jvmType.eIsProxy()));
                if (!_and_2) continue;
                JvmDeclaredType referencedType = (JvmDeclaredType)jvmType;
                JvmDeclaredType contextDeclarator = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)it, JvmDeclaredType.class);
                String _packageName = referencedType.getPackageName();
                boolean bl4 = _notEquals_3 = !Objects.equal((Object)_packageName, (Object)(_packageName_1 = contextDeclarator.getPackageName()));
                if (!_notEquals_3) continue;
                ImportManager importManager = this.getImportManager(appendable);
                importManager.addImportFor(jvmType);
            }
        }
    }

    public ImportManager getImportManager(ITreeAppendable appendable) {
        try {
            ImportManager _xblockexpression = null;
            Class<?> _class = appendable.getClass();
            Field stateField = _class.getDeclaredField("state");
            stateField.setAccessible(true);
            Object stateValue = stateField.get(appendable);
            Class<?> _class_1 = stateValue.getClass();
            Field importManagerField = _class_1.getDeclaredField("importManager");
            importManagerField.setAccessible(true);
            Object _get = importManagerField.get(stateValue);
            _xblockexpression = (ImportManager)_get;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ITreeAppendable generateDocumentation(String text, List<INode> documentationNodes, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        StringConcatenation doc = _builder;
        doc.newLine();
        doc.append((Object)" * ");
        doc.append((Object)text, " * ");
        doc.newLine();
        doc.append((Object)" */");
        ITreeAppendable _xifexpression = null;
        boolean _isEmpty = documentationNodes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ITreeAppendable _xblockexpression_1 = null;
            ITextRegionWithLineInformation documentationTrace = ITextRegionWithLineInformation.EMPTY_REGION;
            for (INode node : documentationNodes) {
                ITextRegionWithLineInformation _merge;
                ITextRegionWithLineInformation _textRegionWithLineInformation = node.getTextRegionWithLineInformation();
                documentationTrace = _merge = documentationTrace.merge(_textRegionWithLineInformation);
            }
            LocationData _locationData = new LocationData(documentationTrace, null);
            ITreeAppendable _trace = appendable.trace((ILocationData)_locationData);
            String _string = doc.toString();
            _trace.append(_string);
            _xifexpression = _xblockexpression_1 = appendable.newLine();
        } else {
            String _string = doc.toString();
            ITreeAppendable _append = appendable.append(_string);
            _xifexpression = _append.newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void generateAnnotations(Iterable<JvmAnnotationReference> annotations, ITreeAppendable appendable, final boolean withLineBreak, final GeneratorConfig config) {
        Functions.Function1<ITreeAppendable, ITreeAppendable> _function;
        Functions.Function1<ITreeAppendable, ITreeAppendable> sep = _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

            public ITreeAppendable apply(ITreeAppendable it) {
                ITreeAppendable _xifexpression = null;
                _xifexpression = withLineBreak ? it.newLine() : it.append(" ");
                return _xifexpression;
            }
        };
        Procedures.Procedure1<LoopParams> _function_1 = new Procedures.Procedure1<LoopParams>((Functions.Function1)sep){
            private final /* synthetic */ Functions.Function1 val$sep;
            {
                this.val$sep = function1;
            }

            public void apply(LoopParams it) {
                it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)this.val$sep);
                it.setSuffix((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)this.val$sep);
            }
        };
        Procedures.Procedure2<JvmAnnotationReference, ITreeAppendable> _function_2 = new Procedures.Procedure2<JvmAnnotationReference, ITreeAppendable>(){

            public void apply(JvmAnnotationReference it, ITreeAppendable app) {
                JvmModelGenerator.this.generateAnnotation(it, app, config);
            }
        };
        this._errorSafeExtensions.forEachSafely(appendable, annotations, (Procedures.Procedure1<? super LoopParams>)_function_1, _function_2);
    }

    public void generateAnnotation(JvmAnnotationReference it, final ITreeAppendable appendable, final GeneratorConfig config) {
        appendable.append("@");
        JvmAnnotationType _annotation = it.getAnnotation();
        appendable.append((JvmType)_annotation);
        EList _explicitValues = it.getExplicitValues();
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                it.setPrefix("(");
                it.setSeparator(", ");
                it.setSuffix(")");
            }
        };
        Procedures.Procedure1<JvmAnnotationValue> _function_1 = new Procedures.Procedure1<JvmAnnotationValue>(){

            public void apply(JvmAnnotationValue it) {
                JvmModelGenerator.this.toJava(it, appendable, config);
            }
        };
        this._loopExtensions.forEach(appendable, _explicitValues, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void toJava(JvmAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _notEquals;
        JvmOperation _operation = it.getOperation();
        boolean bl = _notEquals = !Objects.equal((Object)_operation, null);
        if (_notEquals) {
            JvmOperation _operation_1 = it.getOperation();
            String _simpleName = _operation_1.getSimpleName();
            boolean _equals = Objects.equal((Object)_simpleName, null);
            if (_equals) {
                return;
            }
            JvmOperation _operation_2 = it.getOperation();
            String _simpleName_1 = _operation_2.getSimpleName();
            appendable.append(_simpleName_1);
            appendable.append(" = ");
        } else {
            boolean _greaterThan;
            EObject _eContainer = it.eContainer();
            EList _explicitValues = ((JvmAnnotationReference)_eContainer).getExplicitValues();
            int _size = _explicitValues.size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                appendable.append("value = ");
            }
        }
        this.toJavaLiteral(it, appendable, config);
    }

    protected void _toJavaLiteral(JvmAnnotationAnnotationValue value, final ITreeAppendable appendable, final GeneratorConfig config) {
        EList _values = value.getValues();
        Procedures.Procedure1<JvmAnnotationReference> _function = new Procedures.Procedure1<JvmAnnotationReference>(){

            public void apply(JvmAnnotationReference it) {
                JvmModelGenerator.this.generateAnnotation(it, appendable, config);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmShortAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Short> _function = new Procedures.Procedure1<Short>(){

            public void apply(Short it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmIntAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Integer> _function = new Procedures.Procedure1<Integer>(){

            public void apply(Integer it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmLongAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Long> _function = new Procedures.Procedure1<Long>(){

            public void apply(Long it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmByteAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Byte> _function = new Procedures.Procedure1<Byte>(){

            public void apply(Byte it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmDoubleAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Double> _function = new Procedures.Procedure1<Double>(){

            public void apply(Double it) {
                boolean _isNaN;
                String _switchResult = null;
                boolean _matched = false;
                if (!_matched && (_isNaN = Double.isNaN(it))) {
                    _matched = true;
                    _switchResult = "Double.NaN";
                }
                if (!_matched && Objects.equal((Object)it, (Object)Double.POSITIVE_INFINITY)) {
                    _matched = true;
                    _switchResult = "Double.POSITIVE_INFINITY";
                }
                if (!_matched && Objects.equal((Object)it, (Object)Double.NEGATIVE_INFINITY)) {
                    _matched = true;
                    _switchResult = "Double.NEGATIVE_INFINITY";
                }
                if (!_matched) {
                    String _string = it.toString();
                    _switchResult = String.valueOf(_string) + "d";
                }
                appendable.append(_switchResult);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmFloatAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Float> _function = new Procedures.Procedure1<Float>(){

            public void apply(Float it) {
                boolean _isNaN;
                String _switchResult = null;
                boolean _matched = false;
                if (!_matched && (_isNaN = Float.isNaN(it.floatValue()))) {
                    _matched = true;
                    _switchResult = "Float.NaN";
                }
                if (!_matched && Objects.equal((Object)it, (Object)Float.valueOf(Float.POSITIVE_INFINITY))) {
                    _matched = true;
                    _switchResult = "Float.POSITIVE_INFINITY";
                }
                if (!_matched && Objects.equal((Object)it, (Object)Float.valueOf(Float.NEGATIVE_INFINITY))) {
                    _matched = true;
                    _switchResult = "Float.NEGATIVE_INFINITY";
                }
                if (!_matched) {
                    String _string = it.toString();
                    _switchResult = String.valueOf(_string) + "f";
                }
                appendable.append(_switchResult);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmCharAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Character> _function = new Procedures.Procedure1<Character>(){

            public void apply(Character it) {
                String _string = it.toString();
                String _doConvertToJavaString = JvmModelGenerator.this.doConvertToJavaString(_string);
                String _plus = "'" + _doConvertToJavaString;
                String _plus_1 = String.valueOf(_plus) + "'";
                appendable.append(_plus_1);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmStringAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                String _string = it.toString();
                String _doConvertToJavaString = JvmModelGenerator.this.doConvertToJavaString(_string);
                String _plus = "\"" + _doConvertToJavaString;
                String _plus_1 = String.valueOf(_plus) + "\"";
                appendable.append(_plus_1);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmTypeAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<JvmTypeReference> _function = new Procedures.Procedure1<JvmTypeReference>(){

            public void apply(JvmTypeReference it) {
                JvmType _type = it.getType();
                ITreeAppendable _append = appendable.append(_type);
                _append.append(".class");
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmEnumAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<JvmEnumerationLiteral> _function = new Procedures.Procedure1<JvmEnumerationLiteral>(){

            public void apply(JvmEnumerationLiteral it) {
                JvmDeclaredType _declaringType = it.getDeclaringType();
                appendable.append((JvmType)_declaringType);
                appendable.append(".");
                String _simpleName = it.getSimpleName();
                String _makeJavaIdentifier = JvmModelGenerator.this.makeJavaIdentifier(_simpleName);
                appendable.append(_makeJavaIdentifier);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmBooleanAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Boolean> _function = new Procedures.Procedure1<Boolean>(){

            public void apply(Boolean it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmCustomAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        boolean _isEmpty = _values.isEmpty();
        if (_isEmpty) {
            appendable.append("{}");
        } else {
            EList _values_1 = it.getValues();
            Iterable _filter = Iterables.filter((Iterable)_values_1, XExpression.class);
            Procedures.Procedure1<XExpression> _function = new Procedures.Procedure1<XExpression>(){

                public void apply(XExpression it) {
                    JvmModelGenerator.this.compiler.toJavaExpression(it, appendable);
                }
            };
            this._loopExtensions.forEachWithShortcut(appendable, _filter, _function);
        }
    }

    public TreeAppendable createAppendable(EObject context, ImportManager importManager, GeneratorConfig config) {
        abstract class __JvmModelGenerator_1
        implements ITraceURIConverter {
            Map<URI, SourceRelativeURI> uriForTraceCache;

            __JvmModelGenerator_1() {
            }
        }
        __JvmModelGenerator_1 cachingConverter = new __JvmModelGenerator_1(this){
            {
                this.uriForTraceCache = Maps.newHashMap();
            }

            public SourceRelativeURI getURIForTrace(IProjectConfig config, AbsoluteURI uri) {
                boolean _not;
                URI _uRI = uri.getURI();
                boolean _containsKey = this.uriForTraceCache.containsKey(_uRI);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    SourceRelativeURI result = converter.getURIForTrace(config, uri);
                    URI _uRI_1 = uri.getURI();
                    this.uriForTraceCache.put(_uRI_1, result);
                }
                URI _uRI_2 = uri.getURI();
                return (SourceRelativeURI)this.uriForTraceCache.get(_uRI_2);
            }

            public SourceRelativeURI getURIForTrace(Resource resource) {
                boolean _not;
                URI _uRI = resource.getURI();
                boolean _containsKey = this.uriForTraceCache.containsKey(_uRI);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    SourceRelativeURI result = converter.getURIForTrace(resource);
                    URI _uRI_1 = resource.getURI();
                    this.uriForTraceCache.put(_uRI_1, result);
                }
                URI _uRI_2 = resource.getURI();
                return (SourceRelativeURI)this.uriForTraceCache.get(_uRI_2);
            }
        };
        TreeAppendable appendable = new TreeAppendable(importManager, cachingConverter, this.locationProvider, this.jvmModelAssociations, context, "  ", "\n");
        SharedAppendableState _state = appendable.getState();
        _state.setGeneratorConfig(config);
        return appendable;
    }

    public JvmGenericType containerType(EObject context) {
        JvmGenericType _xifexpression = null;
        boolean _equals = Objects.equal((Object)context, null);
        if (_equals) {
            _xifexpression = null;
        } else {
            JvmGenericType _xifexpression_1 = null;
            if (context instanceof JvmGenericType) {
                _xifexpression_1 = (JvmGenericType)context;
            } else {
                EObject _eContainer = context.eContainer();
                _xifexpression_1 = this.containerType(_eContainer);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected String makeJavaIdentifier(String name) {
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)name, null);
        if (_equals) {
            return "__unknown__";
        }
        String _xifexpression_1 = null;
        boolean _isJavaKeyword = this.keywords.isJavaKeyword(name);
        _xifexpression_1 = _isJavaKeyword ? String.valueOf(name) + "_" : name;
        _xifexpression = _xifexpression_1;
        return _xifexpression;
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmEnumerationType type) {
        Iterable _xblockexpression = null;
        String _identifier = type.getIdentifier();
        String _plus = String.valueOf(_identifier) + ".";
        String _plus_1 = String.valueOf(_plus) + "valueOf(java.lang.String)";
        String _identifier_1 = type.getIdentifier();
        String _plus_2 = String.valueOf(_identifier_1) + ".";
        String _plus_3 = String.valueOf(_plus_2) + "values()";
        final Set syntheticEnumMethods = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{_plus_1, _plus_3}));
        EList _members = type.getMembers();
        Functions.Function1<JvmMember, Boolean> _function = new Functions.Function1<JvmMember, Boolean>(){

            public Boolean apply(JvmMember it) {
                boolean _and = false;
                if (!(it instanceof JvmOperation)) {
                    _and = false;
                } else {
                    boolean _contains;
                    String _identifier = it.getIdentifier();
                    _and = _contains = syntheticEnumMethods.contains(_identifier);
                }
                return !_and;
            }
        };
        _xblockexpression = IterableExtensions.filter((Iterable)_members, (Functions.Function1)_function);
        return _xblockexpression;
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmDeclaredType it) {
        EList _members = it.getMembers();
        Functions.Function1<JvmMember, Boolean> _function = new Functions.Function1<JvmMember, Boolean>(){

            public Boolean apply(JvmMember it) {
                boolean _isSingleSyntheticDefaultConstructor;
                boolean _and = false;
                _and = !(it instanceof JvmConstructor) ? false : (_isSingleSyntheticDefaultConstructor = JvmModelGenerator.this._jvmTypeExtensions.isSingleSyntheticDefaultConstructor((JvmConstructor)it));
                return !_and;
            }
        };
        return IterableExtensions.filter((Iterable)_members, (Functions.Function1)_function);
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmGenericType it) {
        Iterable _xifexpression = null;
        boolean _isAnonymous = it.isAnonymous();
        if (_isAnonymous) {
            EList _members = it.getMembers();
            Functions.Function1<JvmMember, Boolean> _function = new Functions.Function1<JvmMember, Boolean>(){

                public Boolean apply(JvmMember it) {
                    return !(it instanceof JvmConstructor);
                }
            };
            _xifexpression = IterableExtensions.filter((Iterable)_members, (Functions.Function1)_function);
        } else {
            _xifexpression = this._getMembersToBeCompiled((JvmDeclaredType)it);
        }
        return _xifexpression;
    }

    protected Set<EObject> getSourceElements(EObject jvmElement) {
        return this.jvmModelAssociations.getSourceElements(jvmElement);
    }

    public void internalDoGenerate(EObject type, IFileSystemAccess fsa) {
        if (type instanceof JvmDeclaredType) {
            this._internalDoGenerate((JvmDeclaredType)type, fsa);
            return;
        }
        if (type != null) {
            this._internalDoGenerate(type, fsa);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, fsa).toString());
    }

    public ITreeAppendable generateBody(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmAnnotationType) {
            return this._generateBody((JvmAnnotationType)it, appendable, config);
        }
        if (it instanceof JvmEnumerationType) {
            return this._generateBody((JvmEnumerationType)it, appendable, config);
        }
        if (it instanceof JvmGenericType) {
            return this._generateBody((JvmGenericType)it, appendable, config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }

    public ITreeAppendable generateModifier(JvmMember it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmConstructor) {
            return this._generateModifier((JvmConstructor)it, appendable, config);
        }
        if (it instanceof JvmOperation) {
            return this._generateModifier((JvmOperation)it, appendable, config);
        }
        if (it instanceof JvmField) {
            return this._generateModifier((JvmField)it, appendable, config);
        }
        if (it instanceof JvmGenericType) {
            return this._generateModifier((JvmGenericType)it, appendable, config);
        }
        if (it instanceof JvmDeclaredType) {
            return this._generateModifier((JvmDeclaredType)it, appendable, config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }

    public ITreeAppendable generateMember(JvmMember it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmConstructor) {
            return this._generateMember((JvmConstructor)it, appendable, config);
        }
        if (it instanceof JvmOperation) {
            return this._generateMember((JvmOperation)it, appendable, config);
        }
        if (it instanceof JvmField) {
            return this._generateMember((JvmField)it, appendable, config);
        }
        if (it instanceof JvmDeclaredType) {
            return this._generateMember((JvmDeclaredType)it, appendable, config);
        }
        if (it != null) {
            return this._generateMember(it, appendable, config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }

    public void toJavaLiteral(JvmAnnotationValue value, ITreeAppendable appendable, GeneratorConfig config) {
        if (value instanceof JvmAnnotationAnnotationValue) {
            this._toJavaLiteral((JvmAnnotationAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmBooleanAnnotationValue) {
            this._toJavaLiteral((JvmBooleanAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmByteAnnotationValue) {
            this._toJavaLiteral((JvmByteAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmCharAnnotationValue) {
            this._toJavaLiteral((JvmCharAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmCustomAnnotationValue) {
            this._toJavaLiteral((JvmCustomAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmDoubleAnnotationValue) {
            this._toJavaLiteral((JvmDoubleAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmEnumAnnotationValue) {
            this._toJavaLiteral((JvmEnumAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmFloatAnnotationValue) {
            this._toJavaLiteral((JvmFloatAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmIntAnnotationValue) {
            this._toJavaLiteral((JvmIntAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmLongAnnotationValue) {
            this._toJavaLiteral((JvmLongAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmShortAnnotationValue) {
            this._toJavaLiteral((JvmShortAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmStringAnnotationValue) {
            this._toJavaLiteral((JvmStringAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmTypeAnnotationValue) {
            this._toJavaLiteral((JvmTypeAnnotationValue)value, appendable, config);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(value, appendable, config).toString());
    }

    public Iterable<JvmMember> getMembersToBeCompiled(JvmDeclaredType type) {
        if (type instanceof JvmEnumerationType) {
            return this._getMembersToBeCompiled((JvmEnumerationType)type);
        }
        if (type instanceof JvmGenericType) {
            return this._getMembersToBeCompiled((JvmGenericType)type);
        }
        if (type != null) {
            return this._getMembersToBeCompiled(type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }
}

