/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.SwitchConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XSwitchExpressions {
    @Inject
    @Extension
    private IBatchTypeResolver _iBatchTypeResolver;
    @Inject
    @Extension
    private SwitchConstantExpressionsInterpreter _switchConstantExpressionsInterpreter;

    public boolean isJavaSwitchExpression(XSwitchExpression it) {
        boolean _xblockexpression = false;
        LightweightTypeReference switchType = this.getSwitchVariableType(it);
        boolean _equals = Objects.equal((Object)switchType, null);
        if (_equals) {
            return false;
        }
        boolean _isSubtypeOf = switchType.isSubtypeOf(Integer.TYPE);
        if (_isSubtypeOf) {
            return true;
        }
        boolean _isSubtypeOf_1 = switchType.isSubtypeOf(Enum.class);
        if (_isSubtypeOf_1) {
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean isJava7SwitchExpression(XSwitchExpression it) {
        boolean _xblockexpression = false;
        LightweightTypeReference switchType = this.getSwitchVariableType(it);
        boolean _equals = Objects.equal((Object)switchType, null);
        if (_equals) {
            return false;
        }
        boolean _isSubtypeOf = switchType.isSubtypeOf(Integer.TYPE);
        if (_isSubtypeOf) {
            return true;
        }
        boolean _isSubtypeOf_1 = switchType.isSubtypeOf(Enum.class);
        if (_isSubtypeOf_1) {
            return true;
        }
        boolean _isSubtypeOf_2 = switchType.isSubtypeOf(String.class);
        if (_isSubtypeOf_2) {
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean isJavaCaseExpression(XSwitchExpression it, XCasePart casePart) {
        boolean _not;
        boolean _notEquals;
        boolean _xblockexpression = false;
        JvmTypeReference _typeGuard = casePart.getTypeGuard();
        boolean bl = _notEquals = !Objects.equal((Object)_typeGuard, null);
        if (_notEquals) {
            return false;
        }
        XExpression case_ = casePart.getCase();
        boolean _equals = Objects.equal((Object)case_, null);
        if (_equals) {
            return false;
        }
        IResolvedTypes resolvedTypes = this._iBatchTypeResolver.resolveTypes(it);
        LightweightTypeReference caseType = resolvedTypes.getActualType(case_);
        boolean _equals_1 = Objects.equal((Object)caseType, null);
        if (_equals_1) {
            return false;
        }
        LightweightTypeReference switchType = this.getSwitchVariableType(it);
        boolean _isAssignableFrom = switchType.isAssignableFrom(caseType);
        boolean bl2 = _not = !_isAssignableFrom;
        if (_not) {
            return false;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    public LightweightTypeReference getSwitchVariableType(XSwitchExpression it) {
        IResolvedTypes resolvedTypes = this._iBatchTypeResolver.resolveTypes(it);
        JvmFormalParameter declaredParam = it.getDeclaredParam();
        boolean _equals = Objects.equal((Object)declaredParam, null);
        if (_equals) {
            XExpression _switch = it.getSwitch();
            return resolvedTypes.getActualType(_switch);
        }
        LightweightTypeReference paramType = resolvedTypes.getActualType((JvmIdentifiableElement)declaredParam);
        LightweightTypeReference _elvis = null;
        if (paramType != null) {
            _elvis = paramType;
        } else {
            LightweightTypeReference _actualType;
            XExpression _switch_1 = it.getSwitch();
            _elvis = _actualType = resolvedTypes.getActualType(_switch_1);
        }
        return _elvis;
    }

    public boolean isConstant(XCasePart casePart) {
        XExpression case_ = casePart.getCase();
        boolean _equals = Objects.equal((Object)case_, null);
        if (_equals) {
            return false;
        }
        try {
            this._switchConstantExpressionsInterpreter.evaluate(case_);
            return true;
        }
        catch (Throwable _t) {
            if (_t instanceof ConstantExpressionEvaluationException) {
                ConstantExpressionEvaluationException cfr_ignored_0 = (ConstantExpressionEvaluationException)_t;
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public XExpression getThen(XCasePart casePart, XSwitchExpression switchExpression) {
        boolean _notEquals;
        XExpression then = casePart.getThen();
        boolean bl = _notEquals = !Objects.equal((Object)then, null);
        if (_notEquals) {
            return then;
        }
        EList<XCasePart> _cases = switchExpression.getCases();
        int casePartIndex = _cases.indexOf((Object)casePart);
        if (casePartIndex == -1) {
            return null;
        }
        EList<XCasePart> _cases_1 = switchExpression.getCases();
        int count = _cases_1.size();
        if (casePartIndex == count - 1) {
            return switchExpression.getDefault();
        }
        if (casePartIndex + 1 < count) {
            EList<XCasePart> _cases_2 = switchExpression.getCases();
            XCasePart _get = (XCasePart)_cases_2.get(casePartIndex + 1);
            return this.getThen(_get, switchExpression);
        }
        return null;
    }
}

